/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.minerva.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.ofbiz.minerva.pool.BeanFactory;
import org.ofbiz.minerva.pool.ObjectRecord;
import org.ofbiz.minerva.pool.PoolEvent;
import org.ofbiz.minerva.pool.PoolEventListener;
import org.ofbiz.minerva.pool.PoolGCThread;
import org.ofbiz.minerva.pool.PoolObjectFactory;
import org.ofbiz.minerva.pool.PooledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPool
implements PoolEventListener {
    private static final String INITIALIZED = "Pool already initialized!";
    private static final PoolGCThread collector = new PoolGCThread();
    private Logger log = Logger.getLogger(ObjectPool.class);
    private PoolObjectFactory factory;
    private String poolName;
    private final Map objects = new HashMap();
    private final Set deadObjects = Collections.synchronizedSet(new HashSet());
    private int minSize = 0;
    private int maxSize = 0;
    private boolean idleTimeout = true;
    private boolean runGC = true;
    private float maxIdleShrinkPercent = 1.0f;
    private long idleTimeoutMillis = 1800000L;
    private long gcMinIdleMillis = 1200000L;
    private long gcIntervalMillis = 120000L;
    private long lastGC = System.currentTimeMillis();
    private boolean blocking = true;
    private int blockingTimeout = 30000;
    private boolean trackLastUsed = true;
    private boolean invalidateOnError = true;
    private Semaphore permits;
    private boolean initialized = false;

    public ObjectPool() {
    }

    public ObjectPool(PoolObjectFactory factory, String poolName) {
        this.setObjectFactory(factory);
        this.setName(poolName);
    }

    public ObjectPool(Class javaBeanClass, String poolName) {
        this.setObjectFactory(javaBeanClass);
        this.setName(poolName);
    }

    public void setObjectFactory(PoolObjectFactory factory) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.factory = factory;
    }

    public void setObjectFactory(Class javaBeanClass) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.factory = new BeanFactory(javaBeanClass);
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cannot set pool name to null or empty!");
        }
        if (this.poolName != null && !this.poolName.equals(name)) {
            throw new IllegalStateException("Cannot change pool name once set!");
        }
        this.poolName = name;
        this.log = Logger.getLogger((String)(ObjectPool.class.getName() + "." + name));
    }

    public String getName() {
        return this.poolName;
    }

    public void setMinSize(int size) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.minSize = size;
        if (this.maxSize != 0 && this.minSize > this.maxSize) {
            this.maxSize = this.minSize;
            this.log.warn((Object)("pool max size set to " + this.maxSize + " to stay >= min size"));
        }
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMaxSize(int size) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.maxSize = size;
        if (this.maxSize != 0 && this.minSize > this.maxSize) {
            this.minSize = this.maxSize;
            this.log.warn((Object)("pool min size set to " + this.minSize + " to stay <= max size"));
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setIdleTimeoutEnabled(boolean enableTimeout) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.idleTimeout = enableTimeout;
    }

    public boolean isIdleTimeoutEnabled() {
        return this.idleTimeout;
    }

    public void setGCEnabled(boolean enabled) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.runGC = enabled;
    }

    public boolean isGCEnabled() {
        return this.runGC;
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0 and 1!");
        }
        this.maxIdleShrinkPercent = percent;
    }

    public float getMaxIdleTimeoutPercent() {
        return this.maxIdleShrinkPercent;
    }

    public void setIdleTimeout(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.idleTimeoutMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setIdleTimeout(" + millis + ")"));
        }
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMillis;
    }

    public void setGCMinIdleTime(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.gcMinIdleMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setGCMinIdleTime(" + millis + ")"));
        }
    }

    public long getGCMinIdleTime() {
        return this.gcMinIdleMillis;
    }

    public void setGCInterval(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.gcIntervalMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setGCInterval(" + this.gcIntervalMillis + ")"));
        }
    }

    public long getGCInterval() {
        return this.gcIntervalMillis;
    }

    public void setBlocking(boolean blocking) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.blocking = blocking;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setTimestampUsed(boolean timestamp) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.trackLastUsed = timestamp;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setTimestampUsed(" + timestamp + ")"));
        }
    }

    public boolean isTimestampUsed() {
        return this.trackLastUsed;
    }

    public void setInvalidateOnError(boolean invalidate) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.invalidateOnError = invalidate;
    }

    public boolean isInvalidateOnError() {
        return this.invalidateOnError;
    }

    public void initialize() {
        if (this.factory == null || this.poolName == null) {
            throw new IllegalStateException("Factory and Name must be set before pool initialization!");
        }
        if (this.initialized) {
            throw new IllegalStateException("Cannot initialize more than once!");
        }
        this.initialized = true;
        this.permits = new Semaphore(this.maxSize);
        this.factory.poolStarted(this);
        this.lastGC = System.currentTimeMillis();
        this.fillToMin();
        collector.addPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        collector.removePool(this);
        this.factory.poolClosing(this);
        Map map = this.objects;
        synchronized (map) {
            for (ObjectRecord rec : this.objects.values()) {
                if (null == rec) continue;
                if (rec.isInUse()) {
                    this.factory.returnObject(rec.getClientObject());
                }
                this.factory.deleteObject(rec.getObject());
                rec.close();
            }
            this.objects.clear();
            this.deadObjects.clear();
        }
        this.factory = null;
        this.poolName = null;
        this.initialized = false;
    }

    public Object getObject() {
        return this.getObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object parameters) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getObject() called for pool: " + this));
        }
        if (this.objects == null) {
            throw new IllegalStateException("Tried to use pool before it was Initialized or after it was ShutDown!");
        }
        Object result = this.factory.isUniqueRequest();
        if (result != null) {
            return result;
        }
        try {
            if (this.permits.tryAcquire(this.blocking ? (long)this.blockingTimeout : 1L, TimeUnit.MILLISECONDS)) {
                ObjectRecord rec2 = null;
                Map map = this.objects;
                synchronized (map) {
                    for (ObjectRecord rec2 : this.objects.values()) {
                        if (null != rec2 && !rec2.isInUse() && this.factory.checkValidObject(rec2.getObject(), parameters)) {
                            this.log.trace((Object)("Handing out from pool object: " + rec2.getObject()));
                            try {
                                rec2.setInUse(true);
                                break;
                            }
                            catch (ConcurrentModificationException e) {
                                this.log.trace((Object)("Conflict trying to set rec. in use flag:" + rec2.getObject()));
                                continue;
                            }
                        }
                        rec2 = null;
                    }
                }
                if (rec2 == null) {
                    try {
                        rec2 = this.createNewObject(parameters);
                    }
                    catch (Exception e) {
                        this.log.fatal((Object)"Exception in creating new object for pool", (Throwable)e);
                        this.permits.release();
                        throw e;
                    }
                }
                if (rec2 == null) {
                    this.permits.release();
                    String message = "Pool is broken, did not find or create an object";
                    this.log.error((Object)message);
                    throw new RuntimeException(message);
                }
                Object ob = rec2.getObject();
                result = this.factory.prepareObject(ob);
                if (result != ob) {
                    rec2.setClientObject(result);
                }
                if (result instanceof PooledObject) {
                    ((PooledObject)result).addPoolEventListener(this);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Pool " + this + " gave out object: " + result));
                }
                return result;
            }
            throw new RuntimeException("No ManagedConnections Available!");
        }
        catch (RuntimeException e) {
            this.log.fatal((Object)("fatal pool error : " + this.displayPoolData()), (Throwable)e);
            throw e;
        }
        catch (InterruptedException ie) {
            this.log.fatal((Object)("interrupted while requesting permit : " + this.displayPoolData()), (Throwable)ie);
            throw new RuntimeException("Interrupted while requesting permit!");
        }
        catch (Exception e) {
            this.log.fatal((Object)("problem getting connection from pool : " + this.displayPoolData()), (Throwable)e);
            throw new RuntimeException("problem getting connection from pool " + e.getMessage());
        }
    }

    public void setLastUsed(Object object) {
        ObjectRecord rec;
        Object ob;
        if (!this.trackLastUsed) {
            return;
        }
        try {
            ob = this.factory.translateObject(object);
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Pool " + this.getName() + " does not recognize object for last used time (throwing IAE): " + object), (Throwable)e);
            }
            throw new IllegalArgumentException("Pool " + this.getName() + " does not recognize object for last used time: " + object);
        }
        ObjectRecord objectRecord = rec = ob == null ? null : (ObjectRecord)this.objects.get(ob);
        if (rec == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Pool " + this.getName() + " does not recognize object for last used time (throwing IAE): " + object));
            }
            throw new IllegalArgumentException("Pool " + this.getName() + " does not recognize object for last used time: " + object);
        }
        if (!rec.isInUse()) {
            this.log.trace((Object)"Cannot set last updated time for an object that's not in use! (throwing IAE)");
            throw new IllegalStateException("Cannot set last updated time for an object that's not in use!");
        }
        rec.setLastUsed();
    }

    public void markObjectAsInvalid(Object object) {
        if (this.deadObjects == null) {
            this.log.trace((Object)"Tried to use pool before it was Initialized or after it was ShutDown!");
            throw new IllegalStateException("Tried to use pool before it was Initialized or after it was ShutDown!");
        }
        this.deadObjects.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObject(Object object) {
        boolean removed;
        Object pooled;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Pool " + this + " object being released: " + object));
        }
        try {
            this.factory.returnObject(object);
            pooled = this.factory.translateObject(object);
        }
        catch (Exception e) {
            this.log.trace((Object)e);
            return;
        }
        if (pooled == null) {
            return;
        }
        Map map = this.objects;
        synchronized (map) {
            ObjectRecord rec = (ObjectRecord)this.objects.get(pooled);
            if (rec == null) {
                throw new IllegalArgumentException("Object " + object + " is not in pool " + this.poolName + "!");
            }
            if (!rec.isInUse()) {
                return;
            }
            if (object instanceof PooledObject) {
                ((PooledObject)object).removePoolEventListener(this);
            }
            removed = this.deadObjects.remove(object);
            rec.setInUse(false);
            if (removed) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Object was dead: " + object));
                }
                this.objects.remove(pooled);
                rec.close();
            }
        }
        if (removed) {
            try {
                this.factory.deleteObject(pooled);
            }
            catch (Exception e) {
                this.log.error((Object)("Pool " + this + " factory (" + this.factory.getClass().getName() + " delete error: "), (Throwable)e);
            }
            this.fillToMin();
        }
        if (removed) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Pool " + this + " destroyed object " + object + "."));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Pool " + this + " returned object " + object + " to the pool."));
            }
        }
        this.permits.release();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Pool " + this + " release complete"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUsedCount() {
        int total = 0;
        Map map = this.objects;
        synchronized (map) {
            for (ObjectRecord or : new HashSet(this.objects.values())) {
                if (or == null || !or.isInUse()) continue;
                ++total;
            }
        }
        return total;
    }

    public String toString() {
        return this.poolName + " [" + this.getUsedCount() + "/" + (this.objects == null ? 0 : this.objects.size()) + "/" + (this.maxSize == 0 ? "Unlimited" : Integer.toString(this.maxSize)) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectRecord> getPooledObjects(int inUse) {
        HashSet<ObjectRecord> pooledObjs;
        Map map = this.objects;
        synchronized (map) {
            pooledObjs = new HashSet<ObjectRecord>(this.objects.values());
        }
        if (inUse != 0) {
            for (ObjectRecord rec : pooledObjs) {
                if ((inUse != 1 || rec.isInUse()) && (inUse != -1 || !rec.isInUse())) continue;
                pooledObjs.remove(rec);
            }
        }
        return pooledObjs;
    }

    public String displayPoolData() {
        Set<ObjectRecord> objs = this.getPooledObjects(0);
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("Pool Data ").append(this.toString());
        buf.append(" ").append(objs.size()).append(sep);
        for (ObjectRecord rec : objs) {
            buf.append("    ---- ").append(rec).append(sep);
        }
        return buf.toString();
    }

    @Override
    public void objectClosed(PoolEvent evt) {
        this.releaseObject(evt.getSource());
    }

    @Override
    public void objectError(PoolEvent evt) {
        if (this.invalidateOnError || evt.isCatastrophic()) {
            this.markObjectAsInvalid(evt.getSource());
        }
    }

    @Override
    public void objectUsed(PoolEvent evt) {
        if (!this.trackLastUsed) {
            return;
        }
        this.setLastUsed(evt.getSource());
    }

    long getNextGCMillis(long now) {
        long t = this.lastGC + this.gcIntervalMillis - now;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNextGCMillis(): returning " + t));
        }
        if (!this.runGC) {
            return Long.MAX_VALUE;
        }
        return t;
    }

    boolean isTimeToGC() {
        long now = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isTimeToGC(): " + (now >= this.lastGC + (long)Math.round((float)this.gcIntervalMillis * 0.9f))));
        }
        return now >= this.lastGC + (long)Math.round((float)this.gcIntervalMillis * 0.9f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runGCandShrink() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("runGCandShrink(): runGC = " + this.runGC + "; idleTimeout = " + this.idleTimeout));
        }
        if (this.runGC || this.idleTimeout) {
            HashSet objsCopy;
            Map map = this.objects;
            synchronized (map) {
                objsCopy = new HashSet(this.objects.values());
            }
            if (this.runGC) {
                for (ObjectRecord rec : objsCopy) {
                    if (rec == null || !rec.isInUse() || rec.getMillisSinceLastUse() < this.gcMinIdleMillis) continue;
                    this.releaseObject(rec.getClientObject());
                }
            }
            if (this.idleTimeout) {
                HashSet<ObjectRecord> eligible = new HashSet<ObjectRecord>();
                for (ObjectRecord rec : objsCopy) {
                    if (rec == null || rec.isInUse() || rec.getMillisSinceLastUse() <= this.idleTimeoutMillis) continue;
                    eligible.add(rec);
                }
                int max = Math.round((float)eligible.size() * this.maxIdleShrinkPercent);
                if (max == 0 && eligible.size() > 0) {
                    max = 1;
                }
                int count = 0;
                Iterator<Object> it = eligible.iterator();
                while (it.hasNext()) {
                    try {
                        ObjectRecord rec = (ObjectRecord)it.next();
                        if (rec != null) {
                            rec.setInUse(true);
                            Object pooled = rec.getObject();
                            Map map2 = this.objects;
                            synchronized (map2) {
                                this.objects.remove(pooled);
                            }
                            try {
                                this.factory.deleteObject(pooled);
                            }
                            catch (Exception e) {
                                this.log.error((Object)("Pool " + this + " factory (" + this.factory.getClass().getName() + " delete error: "), (Throwable)e);
                            }
                            rec.close();
                            ++count;
                        }
                        this.fillToMin();
                    }
                    catch (ConcurrentModificationException e) {
                        this.log.trace((Object)e);
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("removed [" + count + "] objects from the pool"));
                }
            }
        }
        this.lastGC = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRecord createNewObject(Object parameters) {
        Object ob;
        try {
            ob = this.factory.createObject(parameters);
        }
        catch (Exception ex) {
            this.log.trace((Object)ex);
            throw new RuntimeException("Could not create connection");
        }
        if (ob != null) {
            ObjectRecord rec = new ObjectRecord(ob);
            Map map = this.objects;
            synchronized (map) {
                this.objects.put(ob, rec);
            }
            return rec;
        }
        this.log.trace((Object)"could not create new object!");
        throw new RuntimeException("could not create new object!");
    }

    public void fillToMin() {
        ArrayList<Object> newMCs = new ArrayList<Object>();
        try {
            while (this.objects.size() < this.minSize) {
                newMCs.add(this.getObject(null));
            }
        }
        catch (Exception re) {
            // empty catch block
        }
        Iterator i = newMCs.iterator();
        while (i.hasNext()) {
            this.releaseObject(i.next());
        }
    }

    static {
        collector.start();
    }
}

