/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory factory;
    private static final SecureEntityResolver secureEntityResolver;
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = false;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected static final URLEncoder urlEncoder;
    protected String localXsltFile = null;
    protected String contextXsltFile = null;
    protected String globalXsltFile = null;
    protected String readmeFile = null;
    protected transient ProxyDirContext resources = null;
    protected String fileEncoding = null;
    protected int sendfileSize = 49152;
    protected boolean useAcceptRanges = true;
    protected static final ArrayList<Range> FULL;
    protected boolean showServerInfo = true;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static final StringManager sm;
    protected static final int BUFFER_SIZE = 4096;

    public void destroy() {
    }

    public void init() throws ServletException {
        if (this.getServletConfig().getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
        if (this.getServletConfig().getInitParameter("input") != null) {
            this.input = Integer.parseInt(this.getServletConfig().getInitParameter("input"));
        }
        if (this.getServletConfig().getInitParameter("output") != null) {
            this.output = Integer.parseInt(this.getServletConfig().getInitParameter("output"));
        }
        this.listings = Boolean.parseBoolean(this.getServletConfig().getInitParameter("listings"));
        if (this.getServletConfig().getInitParameter("readonly") != null) {
            this.readOnly = Boolean.parseBoolean(this.getServletConfig().getInitParameter("readonly"));
        }
        if (this.getServletConfig().getInitParameter("sendfileSize") != null) {
            this.sendfileSize = Integer.parseInt(this.getServletConfig().getInitParameter("sendfileSize")) * 1024;
        }
        this.fileEncoding = this.getServletConfig().getInitParameter("fileEncoding");
        this.globalXsltFile = this.getServletConfig().getInitParameter("globalXsltFile");
        this.contextXsltFile = this.getServletConfig().getInitParameter("contextXsltFile");
        this.localXsltFile = this.getServletConfig().getInitParameter("localXsltFile");
        this.readmeFile = this.getServletConfig().getInitParameter("readmeFile");
        if (this.getServletConfig().getInitParameter("useAcceptRanges") != null) {
            this.useAcceptRanges = Boolean.parseBoolean(this.getServletConfig().getInitParameter("useAcceptRanges"));
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
        }
        this.resources = (ProxyDirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        if (this.resources == null) {
            try {
                this.resources = (ProxyDirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
            }
            catch (NamingException e) {
                throw new ServletException("No resources", (Throwable)e);
            }
        }
        if (this.resources == null) {
            throw new UnavailableException("No resources");
        }
        if (this.getServletConfig().getInitParameter("showServerInfo") != null) {
            this.showServerInfo = Boolean.parseBoolean(this.getServletConfig().getInitParameter("showServerInfo"));
        }
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            result = result == null ? (String)request.getAttribute("javax.servlet.include.servlet_path") : (String)request.getAttribute("javax.servlet.include.servlet_path") + result;
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        result = result == null ? request.getServletPath() : request.getServletPath() + result;
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    protected String getPathPrefix(HttpServletRequest request) {
        return request.getContextPath();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuilder allow = new StringBuilder();
        allow.append("GET, HEAD");
        allow.append(", POST");
        allow.append(", PUT");
        allow.append(", DELETE");
        if (req instanceof RequestFacade && ((RequestFacade)req).getAllowTrace()) {
            allow.append(", TRACE");
        }
        allow.append(", OPTIONS");
        resp.setHeader("Allow", allow.toString());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        boolean result = true;
        File contentFile = null;
        Range range = this.parseContentRange(req, resp);
        Object resourceInputStream = null;
        if (range != null) {
            contentFile = this.executePartialPut(req, range, path);
            resourceInputStream = new FileInputStream(contentFile);
        } else {
            resourceInputStream = req.getInputStream();
        }
        try {
            Resource newResource = new Resource((InputStream)resourceInputStream);
            if (exists) {
                this.resources.rebind(path, (Object)newResource);
            } else {
                this.resources.bind(path, (Object)newResource);
            }
        }
        catch (NamingException e) {
            result = false;
        }
        if (result) {
            if (exists) {
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else {
            resp.sendError(409);
        }
    }

    protected File executePartialPut(HttpServletRequest req, Range range, String path) throws IOException {
        int numBytesRead;
        String convertedResourcePath;
        File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File contentFile = new File(tempDir, convertedResourcePath = path.replace('/', '.'));
        if (contentFile.createNewFile()) {
            contentFile.deleteOnExit();
        }
        RandomAccessFile randAccessContentFile = new RandomAccessFile(contentFile, "rw");
        Resource oldResource = null;
        try {
            Object obj = this.resources.lookup(path);
            if (obj instanceof Resource) {
                oldResource = (Resource)obj;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (oldResource != null) {
            int numBytesRead2;
            BufferedInputStream bufOldRevStream = new BufferedInputStream(oldResource.streamContent(), 4096);
            byte[] copyBuffer = new byte[4096];
            while ((numBytesRead2 = bufOldRevStream.read(copyBuffer)) != -1) {
                randAccessContentFile.write(copyBuffer, 0, numBytesRead2);
            }
            bufOldRevStream.close();
        }
        randAccessContentFile.setLength(range.length);
        randAccessContentFile.seek(range.start);
        byte[] transferBuffer = new byte[4096];
        BufferedInputStream requestBufInStream = new BufferedInputStream((InputStream)req.getInputStream(), 4096);
        while ((numBytesRead = requestBufInStream.read(transferBuffer)) != -1) {
            randAccessContentFile.write(transferBuffer, 0, numBytesRead);
        }
        randAccessContentFile.close();
        requestBufInStream.close();
        return contentFile;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (exists) {
            boolean result = true;
            try {
                this.resources.unbind(path);
            }
            catch (NamingException e) {
                result = false;
            }
            if (result) {
                resp.setStatus(204);
            } else {
                resp.sendError(405);
            }
        } else {
            resp.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        return this.checkIfMatch(request, response, resourceAttributes) && this.checkIfModifiedSince(request, response, resourceAttributes) && this.checkIfNoneMatch(request, response, resourceAttributes) && this.checkIfUnmodifiedSince(request, response, resourceAttributes);
    }

    protected String rewriteUrl(String path) {
        return urlEncoder.encode(path);
    }

    @Deprecated
    protected void displaySize(StringBuilder buf, int filesize) {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.append(leftside).append(".").append(rightside);
        buf.append(" KB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String contentType;
        boolean isError;
        boolean serveContent = content;
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            if (serveContent) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers only");
            }
        }
        CacheEntry cacheEntry = this.resources.lookupCache(path);
        if (!cacheEntry.exists) {
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri != null) {
                throw new FileNotFoundException(sm.getString("defaultServlet.missingResource", new Object[]{requestUri}));
            }
            requestUri = request.getRequestURI();
            response.sendError(404, requestUri);
            return;
        }
        if (cacheEntry.context == null && (path.endsWith("/") || path.endsWith("\\"))) {
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri == null) {
                requestUri = request.getRequestURI();
            }
            response.sendError(404, requestUri);
            return;
        }
        boolean bl = isError = response.getStatus() >= 400;
        if (cacheEntry.context == null) {
            boolean included;
            boolean bl2 = included = request.getAttribute("javax.servlet.include.context_path") != null;
            if (!(included || isError || this.checkIfHeaders(request, response, cacheEntry.attributes))) {
                return;
            }
        }
        if ((contentType = cacheEntry.attributes.getMimeType()) == null) {
            contentType = this.getServletContext().getMimeType(cacheEntry.name);
            cacheEntry.attributes.setMimeType(contentType);
        }
        ArrayList<Range> ranges = null;
        long contentLength = -1L;
        if (cacheEntry.context != null) {
            if (!this.listings) {
                response.sendError(404, request.getRequestURI());
                return;
            }
            contentType = "text/html;charset=UTF-8";
        } else {
            if (!isError) {
                if (this.useAcceptRanges) {
                    response.setHeader("Accept-Ranges", "bytes");
                }
                ranges = this.parseRange(request, response, cacheEntry.attributes);
                response.setHeader("ETag", cacheEntry.attributes.getETag());
                response.setHeader("Last-Modified", cacheEntry.attributes.getLastModifiedHttp());
            }
            if ((contentLength = cacheEntry.attributes.getContentLength()) == 0L) {
                serveContent = false;
            }
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (serveContent) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType != null && !contentType.startsWith("text") && !contentType.endsWith("xml") && !contentType.contains("/javascript")) throw e;
                writer = response.getWriter();
                ranges = FULL;
            }
        }
        HttpServletResponse r = response;
        long contentWritten = 0L;
        while (r instanceof ServletResponseWrapper) {
            r = ((ServletResponseWrapper)r).getResponse();
        }
        if (r instanceof ResponseFacade) {
            contentWritten = ((ResponseFacade)r).getContentWritten();
        }
        if (contentWritten > 0L) {
            ranges = FULL;
        }
        if (cacheEntry.context != null || isError || (ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null || ranges == FULL) {
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            if (!(cacheEntry.resource == null || contentLength < 0L || serveContent && ostream == null)) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + contentLength);
                }
                if (contentWritten == 0L) {
                    if (contentLength < Integer.MAX_VALUE) {
                        response.setContentLength((int)contentLength);
                    } else {
                        response.setHeader("content-length", "" + contentLength);
                    }
                }
            }
            InputStream renderResult = null;
            if (cacheEntry.context != null && serveContent) {
                renderResult = this.render(this.getPathPrefix(request), cacheEntry);
            }
            if (!serveContent) return;
            try {
                response.setBufferSize(this.output);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (ostream != null) {
                if (this.checkSendfile(request, response, cacheEntry, contentLength, null)) return;
                this.copy(cacheEntry, renderResult, ostream);
                return;
            } else {
                this.copy(cacheEntry, renderResult, writer);
            }
            return;
        }
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        response.setStatus(206);
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
            long length = range.end - range.start + 1L;
            if (length < Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            } else {
                response.setHeader("content-length", "" + length);
            }
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            if (!serveContent) return;
            try {
                response.setBufferSize(this.output);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (ostream == null) throw new IllegalStateException();
            if (this.checkSendfile(request, response, cacheEntry, range.end - range.start + 1L, range)) return;
            this.copy(cacheEntry, ostream, range);
            return;
        }
        response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
        if (!serveContent) return;
        try {
            response.setBufferSize(this.output);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (ostream == null) throw new IllegalStateException();
        this.copy(cacheEntry, ostream, ranges.iterator(), contentType);
    }

    protected Range parseContentRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rangeHeader = request.getHeader("Content-Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(400);
            return null;
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            response.sendError(400);
            return null;
        }
        if (slashPos == -1) {
            response.sendError(400);
            return null;
        }
        Range range = new Range();
        try {
            range.start = Long.parseLong(rangeHeader.substring(0, dashPos));
            range.end = Long.parseLong(rangeHeader.substring(dashPos + 1, slashPos));
            range.length = Long.parseLong(rangeHeader.substring(slashPos + 1, rangeHeader.length()));
        }
        catch (NumberFormatException e) {
            response.sendError(400);
            return null;
        }
        if (!range.validate()) {
            response.sendError(400);
            return null;
        }
        return range;
    }

    protected ArrayList<Range> parseRange(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            String eTag = resourceAttributes.getETag();
            long lastModified = resourceAttributes.getLastModified();
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if ((fileLength = resourceAttributes.getContentLength()) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    protected InputStream render(String contextPath, CacheEntry cacheEntry) throws IOException, ServletException {
        Source xsltSource = this.findXsltInputStream(cacheEntry.context);
        if (xsltSource == null) {
            return this.renderHtml(contextPath, cacheEntry);
        }
        return this.renderXml(contextPath, cacheEntry, xsltSource);
    }

    protected InputStream renderXml(String contextPath, CacheEntry cacheEntry, Source xsltSource) throws IOException, ServletException {
        ClassLoader original;
        PrivilegedGetTccl pa;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<listing ");
        sb.append(" contextPath='");
        sb.append(contextPath);
        sb.append("'");
        sb.append(" directory='");
        sb.append(cacheEntry.name);
        sb.append("' ");
        sb.append(" hasParent='").append(!cacheEntry.name.equals("/"));
        sb.append("'>");
        sb.append("<entries>");
        try {
            NamingEnumeration<NameClassPair> enumeration = this.resources.list(cacheEntry.name);
            String rewrittenContextPath = this.rewriteUrl(contextPath);
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF") || trimmed.equalsIgnoreCase(this.localXsltFile) || (cacheEntry.name + trimmed).equals(this.contextXsltFile)) continue;
                CacheEntry childCacheEntry = this.resources.lookupCache(cacheEntry.name + resourceName);
                if (!childCacheEntry.exists) continue;
                sb.append("<entry");
                sb.append(" type='").append(childCacheEntry.context != null ? "dir" : "file").append("'");
                sb.append(" urlPath='").append(rewrittenContextPath).append(this.rewriteUrl(cacheEntry.name + resourceName)).append(childCacheEntry.context != null ? "/" : "").append("'");
                if (childCacheEntry.resource != null) {
                    sb.append(" size='").append(this.renderSize(childCacheEntry.attributes.getContentLength())).append("'");
                }
                sb.append(" date='").append(childCacheEntry.attributes.getLastModifiedHttp()).append("'");
                sb.append(">");
                sb.append(RequestUtil.filter(trimmed));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</entry>");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</entries>");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append("<readme><![CDATA[");
            sb.append(readme);
            sb.append("]]></readme>");
        }
        sb.append("</listing>");
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            original = (ClassLoader)AccessController.doPrivileged(pa);
        } else {
            original = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(DefaultServlet.class.getClassLoader());
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(DefaultServlet.class.getClassLoader());
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlSource = new StreamSource(new StringReader(sb.toString()));
            Transformer transformer = tFactory.newTransformer(xsltSource);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
            StreamResult out = new StreamResult(osWriter);
            transformer.transform(xmlSource, out);
            osWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
            return byteArrayInputStream;
        }
        catch (TransformerException e) {
            throw new ServletException("XSL transformer error", (Throwable)e);
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(original);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    protected InputStream renderHtml(String contextPath, CacheEntry cacheEntry) throws IOException, ServletException {
        int slash;
        String name = cacheEntry.name;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuilder sb = new StringBuilder();
        String rewrittenContextPath = this.rewriteUrl(contextPath);
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append(sm.getString("directory.title", new Object[]{name}));
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}");
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(sm.getString("directory.title", new Object[]{name}));
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = name.substring(0, slash);
            sb.append(" - <a href=\"");
            sb.append(rewrittenContextPath);
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append("<b>");
            sb.append(sm.getString("directory.parent", new Object[]{parent}));
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.filename"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.size"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.lastModified"));
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        try {
            NamingEnumeration<NameClassPair> enumeration = this.resources.list(cacheEntry.name);
            boolean shade = false;
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                CacheEntry childCacheEntry = this.resources.lookupCache(cacheEntry.name + resourceName);
                if (!childCacheEntry.exists) continue;
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"#eeeeee\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                sb.append("<a href=\"");
                sb.append(rewrittenContextPath);
                resourceName = this.rewriteUrl(name + resourceName);
                sb.append(resourceName);
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(RequestUtil.filter(trimmed));
                if (childCacheEntry.context != null) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (childCacheEntry.context != null) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(this.renderSize(childCacheEntry.attributes.getContentLength()));
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                sb.append(childCacheEntry.attributes.getLastModifiedHttp());
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (NamingException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        String readme = this.getReadme(cacheEntry.context);
        if (readme != null) {
            sb.append(readme);
            sb.append("<HR size=\"1\" noshade=\"noshade\">");
        }
        if (this.showServerInfo) {
            sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    protected String getReadme(DirContext directory) throws IOException {
        if (this.readmeFile != null) {
            try {
                Object obj = directory.lookup(this.readmeFile);
                if (obj != null && obj instanceof Resource) {
                    StringWriter buffer = new StringWriter();
                    InputStream is = ((Resource)obj).streamContent();
                    this.copyRange(new InputStreamReader(is), new PrintWriter(buffer));
                    return buffer.toString();
                }
            }
            catch (NamingException e) {
                if (this.debug > 10) {
                    this.log("readme '" + this.readmeFile + "' not found", e);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source findXsltInputStream(DirContext directory) throws IOException {
        File f;
        block18: {
            if (this.localXsltFile != null) {
                try {
                    InputStream is;
                    Object obj = directory.lookup(this.localXsltFile);
                    if (obj != null && obj instanceof Resource && (is = ((Resource)obj).streamContent()) != null) {
                        if (Globals.IS_SECURITY_ENABLED) {
                            return this.secureXslt(is);
                        }
                        return new StreamSource(is);
                    }
                }
                catch (NamingException e) {
                    if (this.debug <= 10) break block18;
                    this.log("localXsltFile '" + this.localXsltFile + "' not found", e);
                }
            }
        }
        if (this.contextXsltFile != null) {
            InputStream is = this.getServletContext().getResourceAsStream(this.contextXsltFile);
            if (is != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    return this.secureXslt(is);
                }
                return new StreamSource(is);
            }
            if (this.debug > 10) {
                this.log("contextXsltFile '" + this.contextXsltFile + "' not found");
            }
        }
        if (this.globalXsltFile != null && (f = this.validateGlobalXsltFile()) != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                byte[] b = new byte[(int)f.length()];
                fis.read(b);
                StreamSource streamSource = new StreamSource(new ByteArrayInputStream(b));
                return streamSource;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return null;
    }

    private File validateGlobalXsltFile() {
        String home;
        File result = null;
        String base = System.getProperty("catalina.base");
        if (base != null) {
            File baseConf = new File(base, "conf");
            result = this.validateGlobalXsltFile(baseConf);
        }
        if (result == null && (home = System.getProperty("catalina.home")) != null && !home.equals(base)) {
            File homeConf = new File(home, "conf");
            result = this.validateGlobalXsltFile(homeConf);
        }
        return result;
    }

    private File validateGlobalXsltFile(File base) {
        File candidate = new File(this.globalXsltFile);
        if (!candidate.isAbsolute()) {
            candidate = new File(base, this.globalXsltFile);
        }
        if (!candidate.isFile()) {
            return null;
        }
        try {
            if (!candidate.getCanonicalPath().startsWith(base.getCanonicalPath())) {
                return null;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        String nameLower = candidate.getName().toLowerCase(Locale.ENGLISH);
        if (!nameLower.endsWith(".xslt") && !nameLower.endsWith(".xsl")) {
            return null;
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source secureXslt(InputStream is) {
        DOMSource result = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(secureEntityResolver);
            Document document = builder.parse(is);
            result = new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        catch (SAXException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            if (this.debug > 0) {
                this.log(e.getMessage(), e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    protected boolean checkSendfile(HttpServletRequest request, HttpServletResponse response, CacheEntry entry, long length, Range range) {
        if (this.sendfileSize > 0 && entry.resource != null && (length > (long)this.sendfileSize || entry.resource.getContent() == null) && entry.attributes.getCanonicalPath() != null && Boolean.TRUE == request.getAttribute("org.apache.tomcat.sendfile.support") && request.getClass().getName().equals("org.apache.catalina.connector.RequestFacade") && response.getClass().getName().equals("org.apache.catalina.connector.ResponseFacade")) {
            request.setAttribute("org.apache.tomcat.sendfile.filename", (Object)entry.attributes.getCanonicalPath());
            if (range == null) {
                request.setAttribute("org.apache.tomcat.sendfile.start", (Object)0L);
                request.setAttribute("org.apache.tomcat.sendfile.end", (Object)length);
            } else {
                request.setAttribute("org.apache.tomcat.sendfile.start", (Object)range.start);
                request.setAttribute("org.apache.tomcat.sendfile.end", (Object)(range.end + 1L));
            }
            return true;
        }
        return false;
    }

    protected boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            long lastModified = resourceAttributes.getLastModified();
            if (headerValue != -1L && request.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                response.setStatus(304);
                response.setHeader("ETag", resourceAttributes.getETag());
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    response.setHeader("ETag", eTag);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long lastModified = resourceAttributes.getLastModified();
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected void copy(CacheEntry cacheEntry, InputStream is, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        if (cacheEntry.resource != null) {
            byte[] buffer = cacheEntry.resource.getContent();
            if (buffer != null) {
                ostream.write(buffer, 0, buffer.length);
                return;
            }
            resourceInputStream = cacheEntry.resource.streamContent();
        } else {
            resourceInputStream = is;
        }
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, InputStream is, PrintWriter writer) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        resourceInputStream = cacheEntry.resource != null ? cacheEntry.resource.streamContent() : is;
        InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
        exception = this.copyRange(reader, writer);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = cacheEntry.resource.streamContent();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Iterator<Range> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            InputStream resourceInputStream = cacheEntry.resource.streamContent();
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = ranges.next();
            ostream.println();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            ((InputStream)istream).close();
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    protected IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        if (this.debug > 10) {
            this.log("Serving bytes:" + start + "-" + end);
        }
        long skipped = 0L;
        try {
            skipped = istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        if (skipped < start) {
            return new IOException(sm.getString("defaultservlet.skipfail", new Object[]{skipped, start}));
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    static {
        FULL = new ArrayList();
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        if (Globals.IS_SECURITY_ENABLED) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            secureEntityResolver = new SecureEntityResolver();
        } else {
            factory = null;
            secureEntityResolver = null;
        }
        sm = StringManager.getManager((String)"org.apache.catalina.servlets");
    }

    private static class SecureEntityResolver
    implements EntityResolver2 {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity", new Object[]{publicId, systemId}));
        }

        @Override
        public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalSubset", new Object[]{name, baseURI}));
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity2", new Object[]{name, publicId, baseURI, systemId}));
        }
    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }
}

