/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class HSLFExtractor
extends AbstractPOIFSExtractor {
    public HSLFExtractor(ParseContext context) {
        super(context);
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HSLFSlideShow ss = new HSLFSlideShow(root);
        SlideShow _show = new SlideShow(ss);
        Slide[] _slides = _show.getSlides();
        xhtml.startElement("div", "class", "slideShow");
        for (Slide slide : _slides) {
            xhtml.startElement("div", "class", "slide");
            HeadersFooters hf = slide.getHeadersFooters();
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            xhtml.startElement("p", "class", "slide-content");
            this.textRunsToText(xhtml, slide.getTextRuns());
            xhtml.endElement("p");
            if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                xhtml.startElement("p", "class", "slide-footer");
                xhtml.characters(hf.getFooterText());
                xhtml.endElement("p");
            }
            for (Comment comment : slide.getComments()) {
                xhtml.startElement("p", "class", "slide-comment");
                if (comment.getAuthor() != null) {
                    xhtml.startElement("b");
                    xhtml.characters(comment.getAuthor());
                    xhtml.endElement("b");
                    if (comment.getText() != null) {
                        xhtml.characters(" - ");
                    }
                }
                if (comment.getText() != null) {
                    xhtml.characters(comment.getText());
                }
                xhtml.endElement("p");
            }
            this.handleSlideEmbeddedResources(slide, xhtml);
            xhtml.endElement("div");
        }
        xhtml.endElement("div");
        xhtml.startElement("div", "class", "slideNotes");
        HashSet<Integer> seenNotes = new HashSet<Integer>();
        HeadersFooters hf = _show.getNotesHeadersFooters();
        for (Slide slide : _slides) {
            Integer id;
            Notes notes = slide.getNotesSheet();
            if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
            seenNotes.add(id);
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-note-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.textRunsToText(xhtml, notes.getTextRuns());
            if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
            xhtml.startElement("p", "class", "slide-note-footer");
            xhtml.characters(hf.getFooterText());
            xhtml.endElement("p");
        }
        xhtml.endElement("div");
    }

    private void textRunsToText(XHTMLContentHandler xhtml, TextRun[] runs) throws SAXException {
        if (runs == null) {
            return;
        }
        for (TextRun run : runs) {
            if (run == null) continue;
            xhtml.characters(run.getText());
            xhtml.startElement("br");
            xhtml.endElement("br");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSlideEmbeddedResources(Slide slide, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        Shape[] shapes;
        try {
            shapes = slide.getShapes();
        }
        catch (NullPointerException e) {
            return;
        }
        for (Shape shape : shapes) {
            if (!(shape instanceof OLEShape)) continue;
            OLEShape oleShape = (OLEShape)shape;
            try {
                ObjectData data = oleShape.getObjectData();
                if (data == null) continue;
                TikaInputStream stream = TikaInputStream.get((InputStream)data.getData());
                try {
                    String mediaType = null;
                    if ("Excel.Chart.8".equals(oleShape.getProgID())) {
                        mediaType = "application/vnd.ms-excel";
                    }
                    this.handleEmbeddedResource(stream, Integer.toString(oleShape.getObjectID()), mediaType, xhtml, false);
                }
                finally {
                    stream.close();
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

