/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.os;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LibraryLoader {
    protected static final int BUF_LEN = 4096;
    protected static String extractDir = null;
    private static Hashtable loadedResources = new Hashtable();
    private static long sourceModDate = 0L;

    public static void load(ClassLoader classLoader, String string) {
        LibraryLoader libraryLoader = new LibraryLoader();
        libraryLoader.load(classLoader, string, true, false);
    }

    public static String extractFile(ClassLoader classLoader, String string) throws IOException {
        LibraryLoader libraryLoader = new LibraryLoader();
        return libraryLoader.extractFile(classLoader, string, false);
    }

    public void load(ClassLoader classLoader, String string, boolean bl, boolean bl2) {
        if (loadedResources.get(string) == null) {
            boolean bl3 = bl;
            if (bl) {
                try {
                    System.load(string);
                }
                catch (SecurityException securityException) {
                    bl3 = false;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl3 = false;
                }
            }
            try {
                if (!bl3) {
                    String string2 = this.extractFile(classLoader, string, bl2);
                    System.load(string2);
                }
                loadedResources.put(string, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String getExtractDirectory() {
        if (extractDir == null) {
            try {
                File file = File.createTempFile("xui", ".dll");
                String string = file.getPath();
                extractDir = string.substring(0, string.lastIndexOf(File.separatorChar) + 1);
                file.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return extractDir;
    }

    protected boolean isUpToDate(URL uRL, File file) {
        try {
            long l = 0L;
            sourceModDate = 0L;
            if (!file.exists()) {
                return false;
            }
            l = file.lastModified();
            String string = uRL.getFile();
            if (string.indexOf(".jar") > 0) {
                string = string.substring(6);
                int n = string.indexOf(33);
                String string2 = string.substring(n + 2);
                string2 = string2.replace('\\', '/');
                JarFile jarFile = new JarFile(string.substring(0, n));
                JarEntry jarEntry = jarFile.getJarEntry(string2);
                sourceModDate = jarEntry.getTime();
            } else {
                File file2 = new File(uRL.getFile());
                sourceModDate = file2.lastModified();
            }
            return sourceModDate == l;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String extractFile(ClassLoader classLoader, String string, boolean bl) throws IOException {
        URL uRL = classLoader.getResource(string);
        String string2 = LibraryLoader.getExtractDirectory() + string;
        File file = new File(string2);
        if (!bl && uRL != null) {
            boolean bl2 = bl = !this.isUpToDate(uRL, file);
        }
        if (bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = classLoader.getResource(string).openStream();
            byte[] byArray = new byte[4096];
            int n = 1;
            while (n != -1) {
                n = inputStream.read(byArray, 0, 4096);
                if (n <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            if (sourceModDate != 0L) {
                file.setLastModified(sourceModDate);
            }
        }
        return string2;
    }
}

