/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg.tinyline;

import com.tinyline.svg.AnimationCallback;
import com.tinyline.svg.SVGDocument;
import com.tinyline.svg.SVGGroupElem;
import com.tinyline.svg.SVGNode;
import com.tinyline.svg.SVGRect;
import com.tinyline.svg.SVGSVGElem;
import com.tinyline.tiny2d.TinyNumber;
import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyString;
import com.tinyline.tiny2d.TinyUtil;
import net.xoetrope.optional.svg.XSvgCanvas;
import net.xoetrope.optional.svg.tinyline.SVGEvent;
import net.xoetrope.optional.svg.w3c.dom.events.Event;
import net.xoetrope.optional.svg.w3c.dom.events.EventListener;

public class PlayerListener
implements EventListener,
AnimationCallback {
    private static int MAX_ZOOMLEVEL = 5;
    private static int MIN_ZOOMLEVEL = -5;
    private int zoomLevel = 0;
    private boolean timePaused;
    private long startTime;
    private long offsetTime;
    private long pauseTime;
    private XSvgCanvas canvas;

    public PlayerListener(XSvgCanvas xSvgCanvas) {
        this.canvas = xSvgCanvas;
    }

    public int getCurrentTime() {
        long l = System.currentTimeMillis() / 4L;
        return (int)(l - this.startTime + this.offsetTime);
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis() / 4L;
        this.offsetTime = 0L;
        this.timePaused = false;
    }

    public void setCurrentTime(long l) {
        long l2 = System.currentTimeMillis() / 4L;
        this.offsetTime = l - l2;
    }

    public void pauseAnimations() {
        this.pauseTime = System.currentTimeMillis() / 4L;
        this.timePaused = true;
    }

    public void resumeAnimations() {
        if (this.timePaused) {
            this.setCurrentTime(this.pauseTime);
        }
        this.timePaused = false;
    }

    public boolean animationsPaused() {
        return this.timePaused;
    }

    public void postSMILEvent(int n, TinyString tinyString) {
        switch (n) {
            case 0: {
                SVGEvent sVGEvent = new SVGEvent(1, tinyString);
                this.canvas.postEvent(sVGEvent);
                break;
            }
            case 1: {
                SVGEvent sVGEvent = new SVGEvent(3, tinyString);
                this.canvas.postEvent(sVGEvent);
                break;
            }
            case 2: {
                SVGEvent sVGEvent = new SVGEvent(16, tinyString);
                this.canvas.postEvent(sVGEvent);
            }
        }
    }

    public void doLink(SVGNode sVGNode) {
        TinyString tinyString = ((SVGGroupElem)sVGNode).xlink_href;
        if (tinyString == null) {
            return;
        }
        int n = tinyString.indexOf(35, 0);
        if (n != -1) {
            SVGDocument sVGDocument = this.canvas.raster.document;
            TinyString tinyString2 = tinyString.substring(n + 1);
            if (sVGDocument.resolveLinkBased(tinyString2)) {
                SVGEvent sVGEvent = new SVGEvent(0, null);
                this.canvas.postEvent(sVGEvent);
            }
        } else {
            String string = new String(tinyString.data);
            SVGEvent sVGEvent = new SVGEvent(12, string);
            this.canvas.postEvent(sVGEvent);
        }
    }

    public void handleEvent(Event event) {
        SVGEvent sVGEvent = (SVGEvent)event;
        switch (sVGEvent.id) {
            case 19: {
                this.canvas.raster.setDevClip((TinyRect)sVGEvent.data);
                this.canvas.raster.update();
                this.canvas.raster.sendPixels();
                break;
            }
            case 0: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                TinyRect tinyRect = sVGDocument.animate(this.getCurrentTime());
                SVGEvent sVGEvent2 = new SVGEvent(19, tinyRect);
                this.canvas.postEvent(sVGEvent2);
                if (sVGDocument.nActiveAnimations <= 0 || this.animationsPaused()) break;
                sVGEvent2 = new SVGEvent(0, null);
                this.canvas.postEvent(sVGEvent2);
                break;
            }
            case 1: 
            case 3: 
            case 16: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                TinyString tinyString = (TinyString)sVGEvent.data;
                if (!sVGDocument.resolveEventBased(tinyString)) break;
                SVGEvent sVGEvent3 = new SVGEvent(0, null);
                this.canvas.postEvent(sVGEvent3);
                break;
            }
            case 12: {
                this.canvas.eventQueue.reset();
                String string = (String)sVGEvent.data;
                SVGDocument sVGDocument = this.canvas.loadSVG(string);
                if (sVGDocument == null) break;
                this.canvas.currentURL = new String(string);
                this.canvas.raster.setSVGDocument(sVGDocument);
                SVGRect sVGRect = this.canvas.raster.view;
                SVGRect sVGRect2 = this.canvas.raster.origview;
                sVGRect.x = sVGRect2.x;
                sVGRect.y = sVGRect2.y;
                sVGRect.width = sVGRect2.width;
                sVGRect.height = sVGRect2.height;
                this.canvas.raster.setCamera();
                sVGDocument.nActiveAnimations = 0;
                sVGDocument.animTargets.count = 0;
                sVGDocument.addAnimations(sVGDocument.root);
                sVGDocument.acb = this;
                this.setStartTime();
                SVGEvent sVGEvent4 = new SVGEvent(0, null);
                this.canvas.postEvent(sVGEvent4);
                sVGEvent4 = new SVGEvent(19, this.canvas.raster.getDevClip());
                this.canvas.postEvent(sVGEvent4);
                break;
            }
            case 17: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (!sVGDocument.isZoomAndPanAnable()) {
                    return;
                }
                TinyPoint tinyPoint = (TinyPoint)sVGEvent.data;
                SVGSVGElem sVGSVGElem = (SVGSVGElem)sVGDocument.root;
                int n = sVGSVGElem.getCurrentScale();
                SVGRect sVGRect = this.canvas.raster.view;
                sVGRect.x += TinyUtil.div((int)(tinyPoint.x << 8), (int)n);
                sVGRect.y += TinyUtil.div((int)(tinyPoint.y << 8), (int)n);
                this.canvas.raster.setCamera();
                SVGEvent sVGEvent5 = new SVGEvent(19, this.canvas.raster.getDevClip());
                this.canvas.postEvent(sVGEvent5);
                break;
            }
            case 18: {
                break;
            }
            case 20: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (!sVGDocument.isZoomAndPanAnable()) {
                    return;
                }
                TinyNumber tinyNumber = (TinyNumber)sVGEvent.data;
                if (tinyNumber.val == 0) {
                    --this.zoomLevel;
                    if (this.zoomLevel < MIN_ZOOMLEVEL) {
                        this.zoomLevel = MIN_ZOOMLEVEL;
                        return;
                    }
                } else {
                    ++this.zoomLevel;
                    if (this.zoomLevel > MAX_ZOOMLEVEL) {
                        this.zoomLevel = MAX_ZOOMLEVEL;
                        return;
                    }
                }
                SVGRect sVGRect = new SVGRect();
                SVGRect sVGRect3 = this.canvas.raster.view;
                int n = sVGRect3.x + sVGRect3.width / 2;
                int n2 = sVGRect3.y + sVGRect3.height / 2;
                if (tinyNumber.val == 0) {
                    sVGRect.width = sVGRect3.width / 2;
                    sVGRect.height = sVGRect3.height / 2;
                } else {
                    sVGRect.width = sVGRect3.width * 2;
                    sVGRect.height = sVGRect3.height * 2;
                }
                sVGRect.x = n - sVGRect.width / 2;
                sVGRect.y = n2 - sVGRect.height / 2;
                sVGRect3.x = sVGRect.x;
                sVGRect3.y = sVGRect.y;
                sVGRect3.width = sVGRect.width;
                sVGRect3.height = sVGRect.height;
                this.canvas.raster.setCamera();
                SVGEvent sVGEvent6 = new SVGEvent(19, this.canvas.raster.getDevClip());
                this.canvas.postEvent(sVGEvent6);
                break;
            }
            case 14: {
                if (this.animationsPaused()) {
                    this.resumeAnimations();
                    SVGEvent sVGEvent7 = new SVGEvent(0, null);
                    this.canvas.postEvent(sVGEvent7);
                    break;
                }
                this.pauseAnimations();
                break;
            }
            case 15: {
                if (this.canvas.raster.isAntialiased()) {
                    this.canvas.raster.setAntialiased(false);
                } else {
                    this.canvas.raster.setAntialiased(true);
                }
                this.canvas.raster.setCamera();
                SVGEvent sVGEvent8 = new SVGEvent(19, this.canvas.raster.getDevClip());
                this.canvas.postEvent(sVGEvent8);
                break;
            }
            case 13: {
                SVGRect sVGRect = this.canvas.raster.view;
                SVGRect sVGRect4 = this.canvas.raster.origview;
                sVGRect.x = sVGRect4.x;
                sVGRect.y = sVGRect4.y;
                sVGRect.width = sVGRect4.width;
                sVGRect.height = sVGRect4.height;
                this.canvas.raster.setCamera();
                SVGEvent sVGEvent9 = new SVGEvent(19, this.canvas.raster.getDevClip());
                this.canvas.postEvent(sVGEvent9);
                break;
            }
            case 2: {
                SVGNode sVGNode;
                TinyPoint tinyPoint = (TinyPoint)sVGEvent.data;
                SVGDocument sVGDocument = this.canvas.raster.document;
                SVGNode sVGNode2 = sVGDocument.root.nodeHitAt(this.canvas.raster, tinyPoint);
                if (sVGNode2 == null || (sVGNode = sVGNode2.seekAElem()) == null) break;
                this.doLink(sVGNode);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (sVGDocument.linkTargets.count == 0) {
                    return;
                }
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem != null) {
                    SVGEvent sVGEvent10 = new SVGEvent(8, sVGGroupElem);
                    this.canvas.postEvent(sVGEvent10);
                }
                sVGDocument.linkIndex = 0;
                sVGDocument.linkTargets.count = 0;
                break;
            }
            case 6: {
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGEvent.data;
                if (sVGGroupElem == null) break;
                sVGGroupElem.showBounds = true;
                SVGEvent sVGEvent11 = new SVGEvent(19, sVGGroupElem.getDevBounds(this.canvas.raster));
                this.canvas.postEvent(sVGEvent11);
                break;
            }
            case 7: {
                SVGEvent sVGEvent12;
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (sVGDocument.linkTargets.count == 0) {
                    return;
                }
                if (sVGDocument.linkIndex + 1 == sVGDocument.linkTargets.count) {
                    return;
                }
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem != null) {
                    sVGEvent12 = new SVGEvent(8, sVGGroupElem);
                    this.canvas.postEvent(sVGEvent12);
                }
                ++sVGDocument.linkIndex;
                sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem == null) break;
                sVGEvent12 = new SVGEvent(6, sVGGroupElem);
                this.canvas.postEvent(sVGEvent12);
                break;
            }
            case 8: {
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGEvent.data;
                if (sVGGroupElem == null) break;
                sVGGroupElem.showBounds = false;
                SVGEvent sVGEvent13 = new SVGEvent(19, sVGGroupElem.getDevBounds(this.canvas.raster));
                this.canvas.postEvent(sVGEvent13);
                break;
            }
            case 9: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (sVGDocument.linkTargets.count == 0) {
                    return;
                }
                this.doLink((SVGNode)((SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex]));
                break;
            }
            case 10: {
                SVGEvent sVGEvent14;
                SVGDocument sVGDocument = this.canvas.raster.document;
                if (sVGDocument.linkTargets.count == 0) {
                    return;
                }
                if (sVGDocument.linkIndex == 0) {
                    return;
                }
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem != null) {
                    sVGEvent14 = new SVGEvent(8, sVGGroupElem);
                    this.canvas.postEvent(sVGEvent14);
                }
                --sVGDocument.linkIndex;
                sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem == null) break;
                sVGEvent14 = new SVGEvent(6, sVGGroupElem);
                this.canvas.postEvent(sVGEvent14);
                break;
            }
            case 11: {
                SVGDocument sVGDocument = this.canvas.raster.document;
                sVGDocument.linkTargets.count = 0;
                sVGDocument.linkIndex = 0;
                sVGDocument.addLinks(sVGDocument.root);
                if (sVGDocument.linkTargets.count == 0) {
                    return;
                }
                SVGGroupElem sVGGroupElem = (SVGGroupElem)sVGDocument.linkTargets.data[sVGDocument.linkIndex];
                if (sVGGroupElem == null) break;
                SVGEvent sVGEvent15 = new SVGEvent(6, sVGGroupElem);
                this.canvas.postEvent(sVGEvent15);
            }
        }
    }
}

