/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg.svgsalamander;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.PlayerThread;
import com.kitfox.svg.app.PlayerThreadListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComponent;
import net.xoetrope.optional.svg.HitTester;
import net.xoetrope.optional.svg.XSvgStateHelper;
import net.xoetrope.optional.svg.XSvgStateHelperFactory;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import org.jdesktop.swingx.painter.Painter;

public class XSvgPainter
implements Painter,
HitTester,
PlayerThreadListener {
    protected SVGDiagram diagram;
    protected int oldWidth;
    protected int oldHeight;
    protected Color bkColor;
    protected double scaleX;
    protected double scaleY;
    private JComponent component;
    private boolean scaled;
    private Vector rescaleElements;
    private Rectangle2D viewBox;
    private Insets insets;
    private XSvgStateHelper helper;
    private XmlElement metadata;
    private PlayerThread animationThread;

    public XSvgPainter(JComponent jComponent) {
        this.component = jComponent;
        this.helper = XSvgStateHelperFactory.getXSvgStateHelper(jComponent);
    }

    public String getSelectedId() {
        if (this.helper == null) {
            return "";
        }
        return this.helper.getSelectedId();
    }

    public void setAnimate(boolean bl) {
        if (bl) {
            this.animationThread = new PlayerThread();
            this.animationThread.addListener((PlayerThreadListener)this);
        } else {
            this.animationThread = null;
        }
    }

    public void play() {
        this.animationThread.setPlayState(1);
        this.animationThread.setTimeStep(0.02);
        this.animationThread.setCurTime(0.0);
    }

    public double getCurTime() {
        if (this.animationThread != null) {
            return this.animationThread.getCurTime();
        }
        return 0.0;
    }

    public void updateTime(double d, double d2, int n) {
        try {
            if (n == 0) {
                return;
            }
            SVGUniverse sVGUniverse = this.diagram.getUniverse();
            if (sVGUniverse != null) {
                sVGUniverse.setCurTime(d);
                sVGUniverse.updateTime();
                this.component.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setElementIds(String[][] stringArray) {
        this.helper.setElementIds(stringArray);
        this.helper.getStates(this.diagram);
    }

    public void setMetadata(URL uRL) {
        try {
            this.metadata = XmlSource.read((Reader)new BufferedReader(new InputStreamReader(uRL.openStream())));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setImage(URL uRL) {
        this.setImage(uRL, false);
    }

    public void setImage(URL uRL, boolean bl) {
        try {
            SVGUniverse sVGUniverse = new SVGUniverse();
            if (bl) {
                sVGUniverse.clear();
            }
            this.diagram = sVGUniverse.getDiagram(new URI(uRL.toExternalForm()));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    public void paint(Graphics2D graphics2D, Object object, int n, int n2) {
        this.paint(graphics2D, (JComponent)object, n, n2);
    }

    public void paint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
        Object object;
        block10: {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!this.scaled) {
                this.componentResized();
            }
            try {
                if (this.bkColor != null) {
                    graphics2D.setColor(this.bkColor);
                    graphics2D.fillRect(0, 0, n, n2);
                }
                if (this.diagram == null) break block10;
                SVGRoot sVGRoot = this.diagram.getRoot();
                if (this.oldWidth != n || this.oldHeight != n2) {
                    if (sVGRoot != null) {
                        sVGRoot.setAttribute("width", 1, Double.toString(n));
                        sVGRoot.setAttribute("height", 1, Double.toString(n2));
                        sVGRoot.build();
                        this.oldWidth = n;
                        this.oldHeight = n2;
                    }
                    try {
                        double[] dArray = sVGRoot.getPresAbsolute("viewBox").getDoubleList();
                        this.scaleX = dArray[2] / (double)n;
                        this.scaleY = dArray[3] / (double)n2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sVGRoot != null) {
                    if (this.insets != null) {
                        this.diagram.setDeviceViewport(new Rectangle(this.insets.left, this.insets.top, n - (this.insets.left + this.insets.right), n2 - (this.insets.top + this.insets.bottom)));
                    }
                    this.diagram.render(graphics2D);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public void setBackground(Color color) {
        this.bkColor = color;
    }

    public boolean contains(int n, int n2) {
        return this.helper.contains(this.scaleX * (double)n, this.scaleY * (double)n2);
    }

    public boolean updateState(int n) {
        return this.helper.updateState(n);
    }

    public void setup() {
        String string;
        RescaleElement rescaleElement;
        int n;
        Object object;
        if (this.diagram == null) {
            return;
        }
        if (this.helper == null) {
            this.helper = XSvgStateHelperFactory.getXSvgStateHelper(this.component);
        }
        this.helper.getStates(this.diagram);
        this.viewBox = this.diagram.getViewRect();
        this.rescaleElements = new Vector();
        SVGElement sVGElement = this.diagram.getElement("metadata");
        if (sVGElement != null) {
            object = sVGElement.getPresAbsolute("modlist").getStringValue();
            String[] stringArray = ((String)object).split(";");
            for (n = 0; n < stringArray.length; ++n) {
                rescaleElement = new RescaleElement();
                rescaleElement.element = this.diagram.getElement(stringArray[n]);
                string = rescaleElement.element.getId();
                double d = 5.0;
                double d2 = 4.0;
                int n2 = string.indexOf(95);
                if (n2 > 0) {
                    int n3 = string.lastIndexOf(95);
                    if (n3 > n2) {
                        rescaleElement.radius = Integer.parseInt(string.substring(n2 + 1, n3));
                        rescaleElement.stroke = Integer.parseInt(string.substring(n3 + 1));
                    } else {
                        rescaleElement.radius = Integer.parseInt(string.substring(n2 + 1));
                    }
                }
                this.rescaleElements.add(rescaleElement);
            }
        }
        if (this.metadata != null) {
            object = this.metadata.getChildren();
            int n4 = ((Vector)object).size();
            for (n = 0; n < n4; ++n) {
                rescaleElement = (XmlElement)((Vector)object).elementAt(n);
                string = rescaleElement.getName();
                String string2 = rescaleElement.getAttribute("id");
                RescaleElement rescaleElement2 = new RescaleElement();
                rescaleElement2.element = this.diagram.getElement(string2);
                if (rescaleElement2.element == null) continue;
                String string3 = rescaleElement.getAttribute("x");
                if (string3 != null) {
                    rescaleElement2.x = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("y")) != null) {
                    rescaleElement2.y = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("w")) != null) {
                    rescaleElement2.w = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("h")) != null) {
                    rescaleElement2.h = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("radius")) != null) {
                    rescaleElement2.radius = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("stroke")) != null) {
                    rescaleElement2.stroke = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("ow")) != null) {
                    rescaleElement2.origW = new Double(string3);
                }
                if ((string3 = rescaleElement.getAttribute("oh")) != null) {
                    rescaleElement2.origH = new Double(string3);
                }
                this.rescaleElements.add(rescaleElement2);
            }
        }
    }

    public void componentResized() {
        try {
            if (this.rescaleElements != null) {
                Dimension dimension = this.component.getSize();
                double d = this.viewBox.getWidth();
                double d2 = this.viewBox.getHeight();
                double d3 = dimension.width;
                double d4 = dimension.height;
                int n = this.rescaleElements.size();
                for (int i = 0; i < n; ++i) {
                    RescaleElement rescaleElement = (RescaleElement)this.rescaleElements.get(i);
                    if (this.component != null && this.diagram != null) {
                        double d5;
                        double d6;
                        if (rescaleElement.radius > 0.0) {
                            d6 = rescaleElement.radius * d / d3;
                            d5 = rescaleElement.radius * d2 / d4;
                            rescaleElement.element.setAttribute("rx", 1, Double.toString(d6));
                            rescaleElement.element.setAttribute("ry", 1, Double.toString(d5));
                            this.scaled = true;
                        }
                        if (rescaleElement.stroke > 0.0) {
                            d6 = Math.sqrt(d2 * d2 + d * d);
                            d5 = Math.sqrt(d4 * d4 + d3 * d3);
                            rescaleElement.element.setAttribute("stroke-width", 1, Double.toString(rescaleElement.stroke * d6 / d5));
                            rescaleElement.element.updateTime(0.0);
                            this.scaled = true;
                        }
                        d5 = 0.0;
                        d6 = 0.0;
                        double d7 = 1.0;
                        double d8 = 1.0;
                        if (rescaleElement.x != 0.0) {
                            d6 = rescaleElement.x > 1.0 ? rescaleElement.x / d3 * d : (rescaleElement.x < 0.0 ? (d3 + rescaleElement.x) / d3 * d : rescaleElement.x * d);
                        }
                        if (rescaleElement.y != 0.0) {
                            d5 = rescaleElement.y > 1.0 ? rescaleElement.y / d4 * d2 : (rescaleElement.y < 0.0 ? (d4 + rescaleElement.y) / d4 * d2 : rescaleElement.y * d2);
                        }
                        if (rescaleElement.w != 0.0) {
                            d8 = d / d3;
                            d8 = rescaleElement.w > 1.0 ? (d8 *= rescaleElement.w / rescaleElement.origW) : (d8 *= rescaleElement.w * d3 / rescaleElement.origW);
                        }
                        if (rescaleElement.h != 0.0) {
                            d7 = d2 / d4;
                            d7 = rescaleElement.h > 1.0 ? (d7 *= rescaleElement.h / rescaleElement.origH) : (d7 *= rescaleElement.h * d4 / rescaleElement.origH);
                        }
                        String string = "translate(" + d6 + "," + d5 + ") scale(" + d8 + "," + d7 + ")";
                        rescaleElement.element.setAttribute("transform", 1, string);
                        rescaleElement.element.updateTime(0.0);
                        this.scaled = true;
                    }
                    if (!this.scaled) continue;
                    this.oldHeight = 0;
                    this.oldWidth = 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SVGElement getElement(String string) {
        return this.diagram.getElement(string);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    class RescaleElement {
        double x;
        double y;
        double w;
        double h;
        double origW;
        double origH;
        double radius;
        double stroke;
        SVGElement element;

        RescaleElement() {
        }
    }
}

