/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg.batik;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.net.URL;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import net.xoetrope.optional.svg.HitTester;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.JSVGComponent;
import org.jdesktop.swingx.painter.Painter;

public class XSvgPainter
extends JSVGComponent
implements Painter,
HitTester {
    private AffineTransform originalTransform;
    private boolean isLoaded;
    private Dimension initialDim;
    private Component parentComp;
    private ButtonModel bm;

    public XSvgPainter() {
        this.initialDim = this.initialDim;
        this.isLoaded = false;
        this.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                XSvgPainter.this.originalTransform = XSvgPainter.this.getRenderingTransform();
                Dimension2D dimension2D = XSvgPainter.this.getSVGDocumentSize();
                if (XSvgPainter.this.initialDim != null) {
                    double d = XSvgPainter.this.initialDim.getWidth() / dimension2D.getWidth();
                    AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
                    XSvgPainter.this.setSize(XSvgPainter.this.initialDim);
                    if (affineTransform != null) {
                        affineTransform.concatenate(XSvgPainter.this.originalTransform);
                        XSvgPainter.this.setRenderingTransform(affineTransform, true);
                        XSvgPainter.this.isLoaded = true;
                        if (XSvgPainter.this.getParent() != null) {
                            XSvgPainter.this.parentComp.doLayout();
                            XSvgPainter.this.parentComp.repaint();
                        }
                    }
                } else {
                    XSvgPainter.this.parentComp.repaint();
                }
            }
        });
        this.setOpaque(false);
        this.setBackground(new Color(0, true));
    }

    public XSvgPainter(Component component) {
        this.parentComp = component;
        this.initialDim = this.initialDim;
        this.isLoaded = false;
        this.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                XSvgPainter.this.originalTransform = XSvgPainter.this.getRenderingTransform();
                Dimension2D dimension2D = XSvgPainter.this.getSVGDocumentSize();
                if (XSvgPainter.this.initialDim != null) {
                    double d = XSvgPainter.this.initialDim.getWidth() / dimension2D.getWidth();
                    AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
                    XSvgPainter.this.setSize(XSvgPainter.this.initialDim);
                    if (affineTransform == null) return;
                    affineTransform.concatenate(XSvgPainter.this.originalTransform);
                    XSvgPainter.this.isLoaded = true;
                    if (XSvgPainter.this.parentComp == null) return;
                }
                XSvgPainter.this.parentComp.repaint();
            }
        });
        this.setOpaque(false);
        this.setBackground(new Color(0, true));
    }

    public void setImage(URL uRL) {
        try {
            this.loadSVGDocument(uRL.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics2D graphics2D, Object object, int n, int n2) {
        this.paint(graphics2D, (JComponent)object, n, n2);
    }

    public void paint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
        Dimension dimension;
        this.parentComp = jComponent;
        this.initialDim = dimension = new Dimension(n, n2);
        if (!this.isLoaded) {
            return;
        }
        this.setSize(dimension);
        Dimension2D dimension2D = this.getSVGDocumentSize();
        double d = dimension.getWidth() / dimension2D.getWidth();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        if (affineTransform != null) {
            affineTransform.concatenate(this.originalTransform);
        }
        if (!this.isLoaded) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D;
        if (this.image != null) {
            if (this.paintingTransform != null) {
                graphics2D2.transform(this.paintingTransform);
            }
            graphics2D2.drawRenderedImage(this.image, null);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Iterator iterator = this.overlays.iterator();
            while (iterator.hasNext()) {
                ((Overlay)iterator.next()).paint((Graphics)graphics2D);
            }
        }
    }

    public void setBackground(Color color) {
    }

    public boolean contains(int n, int n2) {
        return false;
    }
}

