/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg;

import com.tinyline.svg.ImageLoader;
import com.tinyline.svg.SVGAttr;
import com.tinyline.svg.SVGDocument;
import com.tinyline.svg.SVGImageElem;
import com.tinyline.svg.SVGImageProducer;
import com.tinyline.svg.SVGParser;
import com.tinyline.svg.SVGRaster;
import com.tinyline.tiny2d.TinyBitmap;
import com.tinyline.tiny2d.TinyPixbuf;
import com.tinyline.tiny2d.TinyString;
import com.tinyline.tiny2d.TinyVector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.xoetrope.optional.svg.XSVGImageProducer;
import net.xoetrope.optional.svg.tinyline.PPSVGBitmap;
import net.xoetrope.optional.svg.tinyline.SVGEventQueue;

public class XSvgIcon
implements Icon,
ImageLoader,
ImageObserver,
Runnable {
    private boolean imageComplete = false;
    Image bimg;
    public SVGRaster raster;
    XSVGImageProducer imageProducer;
    public SVGEventQueue eventQueue;
    TinyVector listeners;
    Hashtable imageCash;
    MediaTracker tracker;
    int width;
    int height;
    Thread thread;
    URL baseURL;
    boolean loaded;
    String currentURL = "";
    JComponent owner;

    public XSvgIcon() {
        this(null, 100, 100);
    }

    public XSvgIcon(String string, int n, int n2) {
        TinyPixbuf tinyPixbuf = new TinyPixbuf(n, n2);
        this.raster = new SVGRaster(tinyPixbuf);
        this.imageProducer = new XSVGImageProducer(this.raster);
        this.raster.setSVGImageProducer((SVGImageProducer)this.imageProducer);
        this.imageProducer.setColorModel(ColorModel.getRGBdefault());
        SVGImageElem.setImageLoader((ImageLoader)this);
        this.raster.setAntialiased(true);
        this.eventQueue = new SVGEventQueue();
        this.listeners = new TinyVector(4);
        this.imageCash = new Hashtable();
    }

    public TinyBitmap createTinyBitmap(TinyString tinyString) {
        String string = new String(tinyString.data);
        PPSVGBitmap pPSVGBitmap = null;
        try {
            URL uRL = new URL(this.baseURL, string);
            pPSVGBitmap = (PPSVGBitmap)this.imageCash.get(uRL);
            if (pPSVGBitmap == null) {
                pPSVGBitmap = new PPSVGBitmap(this.tracker, uRL);
                this.imageCash.put(uRL, pPSVGBitmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pPSVGBitmap;
    }

    public boolean isImageComplete() {
        return this.imageComplete;
    }

    public TinyBitmap createTinyBitmap(String string) {
        return null;
    }

    public TinyBitmap createTinyBitmap(byte[] byArray, int n, int n2) {
        return null;
    }

    public synchronized void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.thread) {
                this.eventQueue.handleEvent(this.eventQueue.getNextEvent());
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.alertError("Internal Error");
        }
    }

    public synchronized void goURL(String string) {
        this.currentURL = string;
        this.start();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0 && this.owner != null) {
            this.owner.repaint(n2, n3, n4, n5);
        }
        return (n & 0x60) == 0;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.bimg == null) {
            this.raster.setCamera();
            this.raster.update();
            this.raster.sendPixels();
            this.bimg = Toolkit.getDefaultToolkit().createImage(this.imageProducer);
        }
        if (this.bimg != null) {
            graphics.drawImage(this.bimg, 0, 0, this);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void flush() {
        this.raster.flush();
        if (this.bimg != null) {
            this.bimg.flush();
            this.bimg = null;
        }
    }

    public SVGDocument loadSVG(String string) {
        System.out.println("" + string);
        this.alertWait("Wait...");
        InputStream inputStream = null;
        try {
            URL uRL;
            this.baseURL = uRL = new URL(this.baseURL, string);
            inputStream = uRL.openStream();
            if (uRL.toString().endsWith("svgz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            this.alertError("Not in SVGT format");
        }
        return this.loadSVG(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGDocument loadSVG(InputStream inputStream) {
        this.alertWait("Wait...");
        String string = "";
        this.loaded = false;
        SVGDocument sVGDocument = this.raster.createSVGDocument();
        try {
            TinyPixbuf tinyPixbuf = this.raster.getPixelBuffer();
            SVGAttr sVGAttr = new SVGAttr(tinyPixbuf.width, tinyPixbuf.height);
            SVGParser sVGParser = new SVGParser(sVGAttr);
            sVGParser.load(sVGDocument, inputStream);
            string = "www.tinyline.com";
            this.loaded = true;
            this.alertInit(string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            sVGDocument = null;
            Runtime.getRuntime().gc();
            this.alertError("Not enought memory");
        }
        catch (SecurityException securityException) {
            sVGDocument = null;
            this.alertError("Security violation");
        }
        catch (Exception exception) {
            sVGDocument = null;
            this.alertError("Not in SVGT format");
        }
        catch (Throwable throwable) {
            sVGDocument = null;
            this.alertError("Not in SVGT format");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.alertError(iOException.getMessage());
            }
        }
        return sVGDocument;
    }

    public void alertError(String string) {
        if (this.owner != null) {
            this.owner.repaint();
        }
        System.out.println(string);
    }

    public void alertWait(String string) {
        if (this.owner != null) {
            this.owner.repaint();
        }
        System.out.println(string);
    }

    public void alertInit(String string) {
        if (this.owner != null) {
            this.owner.repaint();
        }
        System.out.println(string);
    }
}

