/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg;

import com.tinyline.svg.ImageLoader;
import com.tinyline.svg.SVG;
import com.tinyline.svg.SVGAttr;
import com.tinyline.svg.SVGDocument;
import com.tinyline.svg.SVGFontElem;
import com.tinyline.svg.SVGImageElem;
import com.tinyline.svg.SVGImageProducer;
import com.tinyline.svg.SVGParser;
import com.tinyline.svg.SVGRaster;
import com.tinyline.svg.SVGRect;
import com.tinyline.svg.SVGSVGElem;
import com.tinyline.tiny2d.TinyBitmap;
import com.tinyline.tiny2d.TinyPixbuf;
import com.tinyline.tiny2d.TinyString;
import com.tinyline.tiny2d.TinyUtil;
import com.tinyline.tiny2d.TinyVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.xoetrope.optional.svg.XSVGImageProducer;
import net.xoetrope.optional.svg.tinyline.PPSVGBitmap;
import net.xoetrope.optional.svg.tinyline.PlayerListener;
import net.xoetrope.optional.svg.tinyline.SVGEvent;
import net.xoetrope.optional.svg.tinyline.SVGEventQueue;
import net.xoetrope.optional.svg.w3c.dom.events.Event;
import net.xoetrope.optional.svg.w3c.dom.events.EventListener;
import net.xoetrope.optional.svg.w3c.dom.events.EventTarget;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XuiUtilities;

public class XSvgCanvas
extends JComponent
implements Runnable,
ImageLoader,
EventTarget,
XAttributedComponent {
    private Image bimg;
    private int width;
    private int height;
    public SVGRaster raster;
    private XSVGImageProducer imageProducer;
    public SVGEventQueue eventQueue;
    private Thread thread;
    private TinyVector listeners;
    private URL baseURL;
    public String currentURL = "";
    private MediaTracker tracker;
    private PlayerListener defaultListener;
    private boolean loadComplete;
    private XProject currentProject = XProjectManager.getCurrentProject();

    public XSvgCanvas() {
        this.setBackground(new Color(184, 200, 216));
        this.loadComplete = false;
        this.eventQueue = new SVGEventQueue();
        this.listeners = new TinyVector(4);
        this.tracker = new MediaTracker(this);
        this.defaultListener = new PlayerListener(this);
        this.addEventListener("default", this.defaultListener, false);
    }

    public boolean hasFileLoadCompleted() {
        return this.loadComplete;
    }

    public void addNotify() {
        super.addNotify();
        this.start();
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.width != n3 && this.height != n4) {
            this.flush();
            this.raster = null;
            this.width = n3;
            this.height = n4;
        }
        if (this.width > 0) {
            this.init();
        }
    }

    public synchronized void init() {
        if (this.width > 0 && this.raster == null) {
            TinyPixbuf tinyPixbuf = new TinyPixbuf(this.width, this.height);
            this.raster = new SVGRaster(tinyPixbuf);
            this.imageProducer = new XSVGImageProducer(this.raster);
            this.raster.setSVGImageProducer((SVGImageProducer)this.imageProducer);
            this.imageProducer.setColorModel(ColorModel.getRGBdefault());
            SVGImageElem.setImageLoader((ImageLoader)this);
            this.raster.setAntialiased(true);
            if (SVGDocument.defaultFont == null) {
                SVGFontElem sVGFontElem;
                SVGDocument sVGDocument = this.loadSVG(this.getClass().getResourceAsStream("/net/xoetrope/optional/svg/tinyline/helvetica_svg"));
                SVGDocument.defaultFont = sVGFontElem = SVGDocument.getFont((SVGDocument)sVGDocument, (TinyString)SVG.VAL_DEFAULT_FONTFAMILY);
            }
        }
    }

    public TinyBitmap createTinyBitmap(TinyString tinyString) {
        String string = new String(tinyString.data);
        PPSVGBitmap pPSVGBitmap = null;
        try {
            URL uRL = new URL(this.baseURL, string);
            pPSVGBitmap = new PPSVGBitmap(this.tracker, uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pPSVGBitmap;
    }

    public TinyBitmap createTinyBitmap(byte[] byArray, int n, int n2) {
        return new PPSVGBitmap(this.tracker, byArray, n, n2);
    }

    public synchronized void start() {
        this.init();
        if (this.width > 0 && this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        this.flush();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.imageProducer = null;
        this.tracker = null;
        this.eventQueue = null;
        this.removeEventListener(this.defaultListener);
        this.defaultListener = null;
        this.listeners = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.thread) {
            try {
                if (this.raster == null) {
                    this.init();
                } else {
                    this.eventQueue.handleEvent(this.eventQueue.getNextEvent());
                }
                Thread.currentThread();
                Thread.sleep(50L);
                Thread.currentThread();
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.alertError("Internal Error");
            }
        }
        this.thread = null;
    }

    public synchronized void goURL(String string) {
        SVGEvent sVGEvent = new SVGEvent(12, string);
        this.postEvent(sVGEvent);
    }

    public void origView() {
        SVGEvent sVGEvent = new SVGEvent(13, null);
        this.postEvent(sVGEvent);
    }

    public void switchQuality() {
        SVGEvent sVGEvent = new SVGEvent(15, null);
        this.postEvent(sVGEvent);
    }

    public void pauseResumeAnimations() {
        SVGEvent sVGEvent = new SVGEvent(14, null);
        this.postEvent(sVGEvent);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.repaint(n2, n3, n4, n5);
        }
        return (n & 0x60) == 0;
    }

    public void paintComponent(Graphics graphics) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    XSvgCanvas.this.repaint(0L);
                }
            });
        }
        if (this.bimg == null && this.width > 0) {
            if (this.raster == null) {
                this.start();
            }
            this.raster.setCamera();
            this.raster.update();
            this.raster.sendPixels();
            this.bimg = this.createImage(this.imageProducer);
        }
        if (this.bimg != null) {
            graphics.drawImage(this.bimg, 0, 0, this);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void flush() {
        if (this.raster != null) {
            this.raster.flush();
        }
        if (this.bimg != null) {
            this.bimg.flush();
            this.bimg = null;
        }
    }

    public SVGDocument loadSVG(String string) {
        URL uRL;
        this.alertWait("Wait...");
        this.loadComplete = false;
        InputStream inputStream = null;
        try {
            this.baseURL = uRL = new URL(this.baseURL, string);
            inputStream = uRL.openStream();
            if (uRL.toString().endsWith("svgz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            this.alertError("Not in SVGT format");
        }
        uRL = this.loadSVG(inputStream);
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            inputStream = null;
        }
        catch (Exception exception) {
            this.alertError("Not in SVGT format");
        }
        this.loadComplete = true;
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGDocument loadSVG(InputStream inputStream) {
        this.alertWait("Wait...");
        String string = "";
        if (this.raster == null) {
            this.start();
        }
        SVGDocument sVGDocument = this.raster.createSVGDocument();
        try {
            TinyPixbuf tinyPixbuf = this.raster.getPixelBuffer();
            SVGAttr sVGAttr = new SVGAttr(tinyPixbuf.width, tinyPixbuf.height);
            SVGParser sVGParser = new SVGParser(sVGAttr);
            sVGParser.load(sVGDocument, inputStream);
            string = "www.tinyline.com";
            this.alertInit(string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            sVGDocument = null;
            Runtime.getRuntime().gc();
            this.alertError("Not enought memory");
        }
        catch (SecurityException securityException) {
            sVGDocument = null;
            this.alertError("Security violation");
        }
        catch (Exception exception) {
            sVGDocument = null;
            this.alertError("Not in SVGT format");
        }
        catch (Throwable throwable) {
            sVGDocument = null;
            this.alertError("Not in SVGT format");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.alertError(iOException.getMessage());
            }
        }
        return sVGDocument;
    }

    public void alertError(String string) {
    }

    public void alertWait(String string) {
    }

    public void alertInit(String string) {
    }

    public synchronized void postEvent(SVGEvent sVGEvent) {
        sVGEvent.eventTarget = this;
        this.eventQueue.postEvent(sVGEvent);
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        this.listeners.addElement((Object)eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        int n = this.listeners.indexOf((Object)eventListener, 0);
        if (n > 0) {
            this.listeners.removeElementAt(n);
        }
    }

    public boolean dispatchEvent(Event event) {
        if (this.raster == null) {
            this.start();
        }
        for (int i = 0; i < this.listeners.count; ++i) {
            EventListener eventListener = (EventListener)this.listeners.data[i];
            if (eventListener == null) continue;
            eventListener.handleEvent(event);
        }
        return true;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        if (string2.equals("content")) {
            Object object2;
            String string4 = string3 + (string3.toLowerCase().endsWith(".svgz") ? "" : ".svgz");
            URL uRL = this.currentProject.findResource(string4);
            try {
                object2 = uRL.openStream();
                ((InputStream)object2).read();
                ((InputStream)object2).close();
            }
            catch (Throwable throwable) {
                System.out.println("File does not exist: " + object);
                return 0;
            }
            if (uRL != null) {
                object2 = uRL.toExternalForm();
                this.goURL((String)object2);
                if (this.isVisible() && this.isShowing()) {
                    this.start();
                }
            }
        } else if (string2.equals("tooltip")) {
            this.setToolTipText(XuiUtilities.translate((XProject)this.currentProject, (String)((String)object)));
        }
        return 0;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.start();
        }
    }

    public void pan(int n, int n2) {
        SVGRect sVGRect = this.raster.view;
        SVGDocument sVGDocument = this.raster.getSVGDocument();
        SVGSVGElem sVGSVGElem = (SVGSVGElem)sVGDocument.root;
        int n3 = sVGSVGElem.getCurrentScale();
        sVGRect.x += TinyUtil.div((int)(n << 8), (int)n3);
        sVGRect.y += TinyUtil.div((int)(n2 << 8), (int)n3);
        this.updateImage();
    }

    public void zoom(double d) {
        SVGRect sVGRect = this.raster.view;
        sVGRect.width = (int)((double)sVGRect.width / d);
        sVGRect.height = (int)((double)sVGRect.height / d);
        this.updateImage();
    }

    public void reset() {
        SVGRect sVGRect = this.raster.view;
        sVGRect.x = this.raster.origview.x;
        sVGRect.y = this.raster.origview.y;
        sVGRect.width = this.raster.origview.width;
        sVGRect.height = this.raster.origview.height;
        this.updateImage();
    }

    protected void updateImage() {
        this.raster.setCamera();
        this.raster.update();
        this.raster.sendPixels();
    }
}

