/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.svg;

import com.tinyline.svg.SVGImageProducer;
import com.tinyline.svg.SVGRaster;
import com.tinyline.tiny2d.TinyPixbuf;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public class XSVGImageProducer
implements SVGImageProducer,
ImageProducer {
    private ColorModel model;
    private ImageConsumer theConsumer;
    private SVGRaster raster;

    public XSVGImageProducer(SVGRaster sVGRaster) {
        this.raster = sVGRaster;
    }

    public void setConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
    }

    public boolean hasConsumer() {
        return this.theConsumer != null;
    }

    public void sendPixels() {
        TinyPixbuf tinyPixbuf = this.raster.getPixelBuffer();
        int n = tinyPixbuf.width;
        int n2 = n * this.raster.clipRect.ymin + this.raster.clipRect.xmin;
        this.theConsumer.setPixels(this.raster.clipRect.xmin, this.raster.clipRect.ymin, this.raster.clipRect.xmax - this.raster.clipRect.xmin, this.raster.clipRect.ymax - this.raster.clipRect.ymin, this.model, tinyPixbuf.pixels32, n2, n);
    }

    public void imageComplete() {
        this.theConsumer.imageComplete(2);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumer == imageConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        if (this.theConsumer == null) {
            return;
        }
        this.initConsumer();
        this.raster.invalidate();
        this.raster.clearRect(this.raster.clipRect);
        this.sendPixels();
        this.theConsumer.imageComplete(2);
    }

    public synchronized void setColorModel(ColorModel colorModel) {
        this.model = colorModel;
    }

    private final void initConsumer() {
        if (this.theConsumer == null) {
            return;
        }
        TinyPixbuf tinyPixbuf = this.raster.getPixelBuffer();
        if (tinyPixbuf.width > 0 && tinyPixbuf.height > 0) {
            this.theConsumer.setDimensions(tinyPixbuf.width, tinyPixbuf.height);
        }
        this.theConsumer.setColorModel(this.model);
        int n = 10;
        this.theConsumer.setHints(n);
    }
}

