/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.service;

import java.util.Date;
import net.xoetrope.optional.service.ServiceContext;
import net.xoetrope.optional.service.ServiceProxy;
import net.xoetrope.optional.service.ServiceProxyException;
import net.xoetrope.xui.data.XModel;

public class XServiceModelNode
extends XModel {
    protected boolean dirty = true;
    protected long expires;
    protected String serviceId;
    protected ServiceProxy callProxy;

    public void setupService(String string, ServiceProxy serviceProxy, String[] stringArray) {
        this.serviceId = string;
        this.callProxy = serviceProxy;
        this.dirty = true;
    }

    public ServiceProxy getServiceProxy() {
        return this.callProxy;
    }

    public ServiceProxy getServiceProxy(String string) {
        ServiceProxy serviceProxy = this.callProxy;
        while (serviceProxy != null) {
            if (string.compareTo(serviceProxy.getClass().getName()) != 0) {
                serviceProxy = serviceProxy.nextProxy;
                continue;
            }
            return serviceProxy;
        }
        return this.callProxy;
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    protected void sync() {
        if (this.dirty || this.hasExpired()) {
            this.get();
            this.dirty = false;
        }
    }

    public Object get() {
        try {
            if (this.serviceId == null) {
                return this.callProxy.call();
            }
            return this.callProxy.call(this.serviceId, null);
        }
        catch (ServiceProxyException serviceProxyException) {
            serviceProxyException.printStackTrace();
            return null;
        }
    }

    public Object get(ServiceContext serviceContext) {
        try {
            if (this.serviceId == null) {
                return this.callProxy.call();
            }
            return this.callProxy.call(this.serviceId, serviceContext);
        }
        catch (ServiceProxyException serviceProxyException) {
            serviceProxyException.printStackTrace();
            return null;
        }
    }

    public Object append(String string) {
        return null;
    }

    public XModel get(int n) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public void append(XModel xModel) {
        this.dirty = true;
    }

    public void set(Object object) {
        this.dirty = true;
        this.fireModelUpdated();
    }

    public void set(String string, Object object) {
        this.dirty = true;
    }

    public String getId() {
        return this.serviceId;
    }

    public String getAttribName(int n) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public int getAttribute(String string) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public void setAttribValue(int n, Object object) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public void setAttribValue(String string, Object object) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public void setAttribValue(int n, String string, Object object) {
        throw new UnsupportedOperationException("Method setAttribValue() not yet implemented.");
    }

    public double getValueAsDouble(String string) {
        throw new UnsupportedOperationException("Method getValueAsDouble() not yet implemented.");
    }

    public int getAttribValueAsInt(int n) {
        throw new UnsupportedOperationException("Method getAttribValueAsInt() not yet implemented.");
    }

    public int getValueAsInt(String string) {
        throw new UnsupportedOperationException("Method getValueAsInt() not yet implemented.");
    }

    public String getAttribValueAsString(int n) {
        throw new UnsupportedOperationException("Method getAttribValue() not yet implemented.");
    }

    public String getValueAsString(String string) {
        throw new UnsupportedOperationException("Method getValueAsString() not yet implemented.");
    }

    public Object getAttribValue(int n) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public double getAttribValueAsDouble(int n) {
        throw new UnsupportedOperationException("Method getAttribValueAsDouble() not yet implemented.");
    }

    public double getAttribValueAsDouble(int n, char c, char c2) {
        throw new UnsupportedOperationException("Method getAttribValueAsDouble() not yet implemented.");
    }

    public void remove(XModel xModel) {
        throw new UnsupportedOperationException("Method remove() not yet implemented.");
    }

    boolean hasExpired() {
        return this.expires > 0L && new Date().getTime() > this.expires;
    }

    public void setNumAttributes(int n) {
        throw new UnsupportedOperationException("Method get() not yet implemented.");
    }

    public int getStatus() {
        return this.callProxy.getStatus();
    }
}

