/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.service;

import java.util.Hashtable;
import java.util.Vector;

public class ServiceProxyArgs {
    Hashtable passArgs;
    Hashtable returnArgs;
    Hashtable configArgs;
    Vector errors;

    public ServiceProxyArgs(int n) {
        this.passArgs = new Hashtable(n);
        this.returnArgs = new Hashtable();
        this.configArgs = new Hashtable();
        this.errors = new Vector();
    }

    public ServiceProxyArgs(String[] stringArray) {
        this(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.passArgs.put(stringArray[i], null);
        }
    }

    public ServiceProxyArgs(String[] stringArray, Object[] objectArray) {
        this(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.passArgs.put(stringArray[i], objectArray[i]);
        }
    }

    public Object getPassParam(String string) {
        return this.passArgs.get(string);
    }

    public Object getConfigParam(String string) {
        return this.configArgs.get(string);
    }

    public Object getReturnParam(String string) {
        return this.returnArgs.get(string);
    }

    public int getPassParamAsInt(String string) {
        return this.getParamAsInt(string, this.passArgs);
    }

    public int getReturnParamAsInt(String string) {
        return this.getParamAsInt(string, this.returnArgs);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    private int getParamAsInt(String string, Hashtable hashtable) {
        Object v = hashtable.get(string);
        if (v != null) {
            return Integer.parseInt((String)v);
        }
        return -1;
    }

    public void setPassParam(String string, Object object) {
        this.setParam(string, object, this.passArgs);
    }

    public void setReturnParam(String string, Object object) {
        this.setParam(string, object, this.returnArgs);
    }

    public void setConfigParam(String string, Object object) {
        this.setParam(string, object, this.configArgs);
    }

    private void setParam(String string, Object object, Hashtable hashtable) {
        if (object == null) {
            hashtable.remove(string);
        } else {
            hashtable.put(string, object);
        }
    }

    public int getNumPassArgs() {
        return this.passArgs.size();
    }

    public int getNumReturnArgs() {
        return this.passArgs.size();
    }

    public void removePassParam(String string) {
        this.passArgs.remove(string);
    }

    public void removeReturnParam(String string) {
        this.returnArgs.remove(string);
    }

    public Hashtable getPassArgs() {
        return this.passArgs;
    }

    public Hashtable getReturnArgs() {
        return this.returnArgs;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public void addError(String string) {
        this.errors.add(string);
    }

    public void clearErrors() {
        this.errors.clear();
    }
}

