/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.scripts.javascript;

import net.xoetrope.optional.scripts.ScriptEngine;
import net.xoetrope.optional.scripts.ScriptException;
import net.xoetrope.optional.scripts.Session;
import net.xoetrope.xui.XPage;
import net.xoetrope.xui.XPageManager;
import net.xoetrope.xui.XProject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptEngine
implements ScriptEngine {
    private XProject currentProject;
    private XPageManager pageMgr;

    public void setProject(XProject xProject) {
        this.currentProject = xProject;
        this.pageMgr = this.currentProject.getPageManager();
    }

    public String getPageScript() {
        XPage xPage = (XPage)this.pageMgr.getCurrentPage(null);
        return (String)xPage.getAttribute("source", "scripts");
    }

    public void configureScriptEnvironment(Scriptable scriptable, Context context) {
        scriptable.put("session", scriptable, (Object)Session.getSession());
        scriptable.put("console", scriptable, (Object)System.out);
        scriptable.put("pageManager", scriptable, (Object)this.pageMgr);
        scriptable.put("document", scriptable, (Object)((XPage)this.pageMgr.getCurrentPage(null)));
        context.evaluateString(scriptable, this.getPageScript(), "<cmd>", 1, null);
    }

    public Object executeScript(String string) throws ScriptException {
        Object object = null;
        Context context = Context.enter();
        try {
            ScriptableObject scriptableObject = context.initStandardObjects();
            this.configureScriptEnvironment((Scriptable)scriptableObject, context);
            object = context.evaluateString((Scriptable)scriptableObject, string, "<cmd>", 1, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ScriptException(exception.getMessage(), exception);
        }
        finally {
            Context.exit();
        }
        return object;
    }
}

