/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import net.xoetrope.optional.resources.XResourceLoader;
import net.xoetrope.xui.XProject;

public class XRemoteClassLoader
extends ClassLoader
implements XResourceLoader {
    protected URI[] uri;

    public XRemoteClassLoader(XProject xProject) {
        try {
            XProject xProject2 = xProject;
            int n = new Integer(xProject2.getStartupParam("NumRemoteClassLoaderPaths"));
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = xProject2.getStartupParam("RemoteClassLoaderPath" + (i + 1));
            }
            this.setSources(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public boolean setSources(String[] stringArray) {
        try {
            this.uri = new URI[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.uri[i] = new URI(stringArray[i]);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        return true;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            for (int i = 0; i < this.uri.length; ++i) {
                URL uRL = new URL(this.uri[i].toURL(), string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDefaultUseCaches(false);
                uRLConnection.setDoOutput(true);
                uRLConnection.setIfModifiedSince(0L);
                InputStream inputStream = uRLConnection.getInputStream();
                if (inputStream == null) continue;
                return inputStream;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public URL findResource(String string) {
        try {
            for (int i = 0; i < this.uri.length; ++i) {
                String string2 = string.indexOf("\\") > -1 || string.indexOf("/") > -1 ? "" : this.uri[i].toString() + File.separatorChar;
                File file = new File(string2 + string);
                if (!file.exists()) continue;
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, true);
    }

    public synchronized Class findClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            Class<?> clazz = super.findSystemClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] byArray = this.loadClassBytes(string);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            Class<?> clazz = this.defineClass(byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private byte[] loadClassBytes(String string) {
        byte[] byArray = new byte[]{};
        InputStream inputStream = this.getResourceAsStream(string + ".class");
        try {
            byte[] byArray2 = new byte[1000];
            int n = inputStream.read(byArray2);
            while (n != -1) {
                byte[] byArray3 = byArray;
                byArray = new byte[byArray.length + n];
                System.arraycopy(byArray2, 0, byArray, byArray3.length, n);
                byArray2 = new byte[1000];
                n = inputStream.read(byArray2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }
}

