/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.pool;

public abstract class PoolObject {
    private boolean inUse;
    private long timeStamp;

    public synchronized boolean lease() {
        if (this.inUse) {
            return false;
        }
        this.inUse = true;
        this.timeStamp = System.currentTimeMillis();
        return true;
    }

    public abstract boolean validate();

    public boolean getInUse() {
        return this.inUse;
    }

    public long getLastUse() {
        return this.timeStamp;
    }

    public abstract void close() throws Exception;

    public void expireLease() {
        this.inUse = false;
    }
}

