/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.pool;

import java.util.Enumeration;
import java.util.Vector;
import net.xoetrope.optional.pool.ObjectReaper;
import net.xoetrope.optional.pool.PoolObject;

public abstract class PoolManager {
    private static final long timeout = 60000L;
    private int poolSize = 10;
    protected Vector objects;
    private ObjectReaper objectReaper;

    public PoolManager(int n) {
        this.poolSize = n;
        this.objects = new Vector(this.poolSize);
        this.objectReaper = new ObjectReaper(this);
        this.objectReaper.start();
    }

    public synchronized void reapObjects() {
        long l = System.currentTimeMillis() - 60000L;
        Enumeration enumeration = this.objects.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            PoolObject poolObject = (PoolObject)enumeration.nextElement();
            if (!poolObject.getInUse() || l <= poolObject.getLastUse() || poolObject.validate()) continue;
            this.removeObject(poolObject);
        }
    }

    public synchronized void closeObjects() {
        Enumeration enumeration = this.objects.elements();
        while (this.objects != null && enumeration.hasMoreElements()) {
            PoolObject poolObject = (PoolObject)enumeration.nextElement();
            this.removeObject(poolObject);
        }
    }

    private synchronized void removeObject(PoolObject poolObject) {
        this.objects.removeElement(poolObject);
    }

    public PoolObject getObject(String string) throws Exception {
        PoolObject poolObject;
        for (int i = 0; i < this.objects.size(); ++i) {
            poolObject = (PoolObject)this.objects.elementAt(i);
            if (!poolObject.lease()) continue;
            return poolObject;
        }
        poolObject = this.getNewObject(string);
        poolObject.lease();
        this.objects.addElement(poolObject);
        return poolObject;
    }

    public abstract PoolObject getNewObject(String var1) throws Exception;

    public synchronized void returnObject(PoolObject poolObject) {
        poolObject.expireLease();
    }
}

