/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import net.xoetrope.optional.layout.Scaleable;

public class ScaleLayout
implements LayoutManager {
    private Dimension lastSize;
    private double scaleX;
    private double scaleY;
    private boolean scaleAll = true;
    private boolean scaleFonts;

    public ScaleLayout() {
    }

    public ScaleLayout(int n, int n2) {
        this.lastSize = new Dimension(n, n2);
    }

    public ScaleLayout(int n, int n2, boolean bl) {
        this.lastSize = new Dimension(n, n2);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        double d = container.getSize().width;
        if (this.lastSize == null) {
            this.lastSize = container.getSize();
        }
        if (d > 0.0) {
            double d2 = container.getSize().height;
            this.scaleX = d / (double)this.lastSize.width;
            this.scaleY = d2 / (double)this.lastSize.height;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.iterateComps(container.getComponent(i));
            }
            this.lastSize = container.getSize();
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return null;
    }

    public Dimension preferredLayoutSize(Container container) {
        return null;
    }

    public void removeLayoutComponent(Component component) {
    }

    protected void iterateComps(Component component) {
        this.scaleComponent(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            if (this.scaleAll || container.getLayout() == null) {
                int n = ((Container)component).getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.iterateComps(((Container)component).getComponent(i));
                }
            }
        }
    }

    public void scaleComponent(Component component) {
        int n;
        int n2;
        boolean bl = true;
        if (component instanceof Scaleable) {
            bl = ((Scaleable)((Object)component)).isScalable();
        }
        Dimension dimension = component.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (int)component.getLocation().getX();
        int n6 = (int)component.getLocation().getY();
        if (bl) {
            n2 = (int)((double)n3 * this.scaleX + 0.5);
            n = (int)((double)n4 * this.scaleY + 0.5);
        } else {
            n2 = n3;
            n = n4;
        }
        component.setBounds((int)((double)n5 * this.scaleX + 0.5), (int)((double)n6 * this.scaleY + 0.5), n2, n);
        if (this.scaleFonts) {
            Font font = component.getFont();
            Font font2 = new Font(font.getFontName(), font.getStyle(), n4 * font.getSize());
            component.setFont(font2);
        }
    }

    public void setScaleAll(boolean bl) {
        this.scaleAll = bl;
    }

    public boolean getScaleAll() {
        return this.scaleAll;
    }

    public void setScaleFonts(boolean bl) {
        this.scaleFonts = bl;
    }

    public boolean getScaleFonts() {
        return this.scaleFonts;
    }
}

