/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.layout;

import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import net.xoetrope.builder.BuilderSupport;
import net.xoetrope.optional.layout.Guide;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;

public class GuideSupport
implements BuilderSupport {
    private int left = 0;
    private int top = 0;
    private int width;
    private int height;
    private XProject currentProject;
    public static final int GUIDE_SELECTION_TOLERANCE = 5;
    private Vector horzGuides = new Vector();
    private Vector vertGuides = new Vector();

    public GuideSupport(XProject xProject) {
        this.currentProject = xProject;
    }

    public void setPageBounds(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.width = n3;
        this.height = n4;
        this.updateGuides(this.vertGuides, n3);
        this.updateGuides(this.horzGuides, n4);
    }

    public Vector getGuideCoords(boolean bl) {
        if (bl) {
            return this.vertGuides;
        }
        return this.horzGuides;
    }

    public void setGuideCoords(Vector vector, boolean bl) {
        if (bl) {
            this.vertGuides = vector;
        } else {
            this.horzGuides = vector;
        }
    }

    public void addGuide(Guide guide) {
        if (guide.getIsVertical()) {
            this.vertGuides.add(guide);
        } else {
            this.horzGuides.add(guide);
        }
    }

    public void read(String string) {
        String string2;
        Reader reader = null;
        try {
            string2 = string;
            if (string2.indexOf(".xml") < 0) {
                string2 = string2 + ".xml";
            }
            reader = this.currentProject.getBufferedReader(string2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (reader == null || !reader.ready()) {
                return;
            }
            string2 = XmlSource.read((Reader)reader);
            this.read((XmlElement)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void read(XmlElement xmlElement) {
        Object object;
        int n = Integer.parseInt(xmlElement.getAttribute("width"));
        int n2 = Integer.parseInt(xmlElement.getAttribute("height"));
        String string = xmlElement.getAttribute("vert");
        if (string != null && string.length() > 0) {
            this.readGuides(this.vertGuides, string, n, true);
        } else {
            object = xmlElement.getChildren("vert");
            if (((Vector)object).size() > 0) {
                this.readGuides(this.vertGuides, (XmlElement)((Vector)object).elementAt(0), n, true);
            }
        }
        object = xmlElement.getAttribute("horz");
        if (object != null && ((String)object).length() > 0) {
            this.readGuides(this.horzGuides, (String)object, n2, false);
        } else {
            Vector vector = xmlElement.getChildren("horz");
            if (vector.size() > 0) {
                this.readGuides(this.horzGuides, (XmlElement)vector.elementAt(0), n2, false);
            }
        }
    }

    private void readGuides(Vector vector, XmlElement xmlElement, int n, boolean bl) {
        int n2;
        vector.clear();
        Vector vector2 = xmlElement.getChildren("Guide");
        int n3 = vector2.size();
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            XmlElement xmlElement2 = (XmlElement)vector2.elementAt(n2);
            int n5 = Integer.parseInt(xmlElement2.getAttribute("id"));
            double d = Double.parseDouble(xmlElement2.getAttribute("pos"));
            Guide guide = new Guide(d, n5, n, bl);
            int n6 = Integer.parseInt(xmlElement2.getAttribute("type"));
            guide.setPositioning(n6);
            guide.setCoordinates(Integer.parseInt(xmlElement2.getAttribute("coords")));
            nArray[n2] = n6 == 4 ? (n4 = Integer.parseInt(xmlElement2.getAttribute("prev"))) : -1;
            vector.add(guide);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n7 = nArray[n2];
            if (n7 < 0) continue;
            Guide guide = (Guide)vector.elementAt(n2);
            guide.setPreviousGuide((Guide)vector.elementAt(n7));
        }
    }

    private void readGuides(Vector vector, String string, int n, boolean bl) {
        vector.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
            double d = Double.parseDouble(stringTokenizer2.nextToken());
            int n3 = Integer.parseInt(stringTokenizer2.nextToken());
            int n4 = Integer.parseInt(stringTokenizer2.nextToken());
            Guide guide = new Guide(d, n2, n, bl);
            guide.positioning = n3;
            guide.coordinates = n4;
            if (n3 == 4) {
                int n5 = Integer.parseInt(stringTokenizer2.nextToken());
                guide.previousGuide = (Guide)vector.elementAt(n5);
            }
            vector.add(guide);
        }
    }

    private void updateGuides(Vector vector, int n) {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            Guide guide = (Guide)vector.elementAt(i);
            guide.setMaxExtent(n);
        }
    }
}

