/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.layout;

public class Guide
implements Comparable {
    public static final int ABSOLUTE_COORDINATES = 0;
    public static final int RELATIVE_COORDINATES = 1;
    public static final int ABSOLUTE_POSITION = 2;
    public static final int RELATIVE_POSITION = 4;
    protected boolean isVertical;
    protected int positioning;
    protected int coordinates;
    protected double position;
    protected double minPosition;
    protected double maxPosition;
    protected int maxExtent;
    protected int snapRange;
    protected int id;
    protected Guide previousGuide;

    public Guide(int n, int n2, int n3, boolean bl) {
        this.position = n;
        this.id = n2;
        this.maxExtent = n3;
        this.isVertical = bl;
        this.positioning = 2;
        this.coordinates = 0;
    }

    public Guide(double d, int n, int n2, boolean bl) {
        this.position = d;
        this.id = n;
        this.maxExtent = n2;
        this.isVertical = bl;
        this.positioning = 2;
        this.coordinates = 1;
    }

    public void setPreviousGuide(Guide guide) {
        this.previousGuide = guide;
    }

    public Guide getPreviousGuide() {
        return this.previousGuide;
    }

    public int getAbsoluteCoordinates() {
        if (this.coordinates == 0) {
            return (int)this.position;
        }
        return (int)(this.position * (double)this.maxExtent / 100.0);
    }

    public int getAbsolutePosition() {
        if (this.positioning == 2 || this.previousGuide == null) {
            int n = this.getAbsoluteCoordinates();
            if (n < 0) {
                n = this.maxExtent + n;
            }
            return n;
        }
        return this.previousGuide.getAbsolutePosition() + this.getAbsoluteCoordinates();
    }

    public void setAbsolutePosition(int n) {
        if (this.positioning == 2 || this.previousGuide == null) {
            this.positioning = 2;
            this.position = this.coordinates == 0 ? (double)n : 100.0 * (double)n / (double)this.maxExtent;
        } else {
            this.position = this.coordinates == 0 ? (double)(n - this.previousGuide.getAbsolutePosition()) : 100.0 * (double)(n - this.previousGuide.getAbsolutePosition()) / (double)this.maxExtent;
        }
    }

    public void useAbsolutePosition() {
        this.position = this.getAbsolutePosition();
        this.positioning = 2;
        this.coordinates = 0;
    }

    public boolean equals(Object object) {
        return this.id == ((Guide)object).id;
    }

    public int compareTo(Object object) {
        int n;
        Guide guide = (Guide)object;
        int n2 = this.getAbsolutePosition();
        if (n2 < (n = guide.getAbsolutePosition())) {
            return -1;
        }
        if (n2 == n) {
            return 0;
        }
        return 1;
    }

    public boolean getIsVertical() {
        return this.isVertical;
    }

    public int getPositioning() {
        return this.positioning;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    public double getPosition() {
        return this.position;
    }

    public double getMinPosition() {
        return this.minPosition;
    }

    public double getMaxPosition() {
        return this.maxPosition;
    }

    public int getMaxExtent() {
        return this.maxExtent;
    }

    public int getSnapRange() {
        return this.snapRange;
    }

    public int getId() {
        return this.id;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public void setPositioning(int n) {
        this.positioning = n;
    }

    public void setCoordinates(int n) {
        this.coordinates = n;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setMaxExtent(int n) {
        if (n > 0) {
            this.maxExtent = n;
        }
    }
}

