/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;

public class ColumnLayout
implements LayoutManager2 {
    private int padding = 2;
    private int indentX;
    private int indentY;
    private int minRowHeight = 12;
    private double maxRowWidth = 1.0;
    private ArrayList rows;
    private XRow currentRow;
    private int currentCol;
    private int numCols;
    private int[] colSizes;
    private int[] minColSizes;
    private Dimension preferredSize;
    private Dimension minimumSize;

    public ColumnLayout(int n, int n2) {
        this.padding = n2;
        this.indentY = 0;
        this.indentX = 0;
        this.numCols = n;
        this.rows = new ArrayList();
        this.currentRow = new XRow(n);
        this.currentCol = 0;
        this.colSizes = new int[this.numCols];
        this.minColSizes = new int[this.numCols];
    }

    public void setMaxRowWidth(double d) {
        this.maxRowWidth = d;
    }

    public void setMaxRowWidth(String string) {
        this.maxRowWidth = Double.parseDouble(string);
    }

    public void setPadding(String string) {
        this.padding = Integer.parseInt(string);
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public void setNumCols(String string) {
        this.numCols = Integer.parseInt(string);
    }

    public void setNumCols(int n) {
        this.numCols = n;
    }

    public void setIndentX(int n) {
        this.indentX = n;
    }

    public void setIndentY(int n) {
        this.indentY = n;
    }

    public void endRow() {
        this.rows.add(this.currentRow);
        this.currentRow = new XRow(this.numCols);
        this.currentCol = 0;
    }

    public void addRowSpacer() {
        this.endRow();
    }

    public void addSpacer() {
        ++this.currentCol;
    }

    public void addSpacer(int n) {
        this.currentCol += Math.max(n, 1);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (this.currentCol == this.numCols) {
            this.endRow();
        }
        this.currentRow.components[this.currentCol++] = component;
    }

    public Dimension maximumLayoutSize(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.numCols; ++n4) {
            n3 = 0;
            n2 = this.rows.size();
            for (n = 0; n < n2; ++n) {
                n3 = Math.max(((XRow)this.rows.get(n)).getMaximumWidth(n4), n3);
            }
            n5 += n3;
            this.minColSizes[n4] = n3;
        }
        n5 += (this.numCols + 1) * this.padding + this.indentX;
        n4 = 0;
        n3 = this.rows.size();
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            for (int i = 0; i < this.numCols; ++i) {
                n = Math.max(((XRow)this.rows.get(n2)).getMaximumHeight(i), n);
            }
            n4 += n;
        }
        return new Dimension(n5, n4 += (n3 + 1) * this.padding + this.indentY);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.minColSizes = null;
        this.colSizes = null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n;
        int n2;
        int n3;
        if (this.colSizes == null) {
            this.colSizes = new int[this.numCols];
        }
        int n4 = 0;
        int n5 = this.rows.size();
        for (n3 = 0; n3 < this.numCols; ++n3) {
            n2 = 0;
            for (n = 0; n < n5; ++n) {
                n2 = Math.max(((XRow)this.rows.get(n)).getPreferredWidth(n3), n2);
            }
            this.colSizes[n3] = n2;
            n4 += n2;
        }
        n4 += (this.numCols + 1) * this.padding + this.indentX;
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            n = 0;
            for (int i = 0; i < this.numCols; ++i) {
                n = Math.max(((XRow)this.rows.get(n2)).getPreferredHeight(i), n);
            }
            n3 += n;
        }
        return new Dimension(n4, n3 += (n5 + 1) * this.padding + this.indentY);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2;
        int n3;
        if (this.minColSizes == null) {
            this.minColSizes = new int[this.numCols];
        }
        int n4 = 0;
        int n5 = this.rows.size();
        for (n3 = 0; n3 < this.numCols; ++n3) {
            n2 = 0;
            for (n = 0; n < n5; ++n) {
                n2 = Math.max(((XRow)this.rows.get(n)).getMinimumWidth(n3), n2);
            }
            n4 += n2;
            this.minColSizes[n3] = n2;
        }
        n4 += (this.numCols + 1) * this.padding + this.indentX;
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            n = 0;
            for (int i = 0; i < this.numCols; ++i) {
                n = Math.max(((XRow)this.rows.get(n2)).getMinimumHeight(i), n);
            }
            n3 += n;
        }
        n3 = Math.max(this.minRowHeight, n3);
        return new Dimension(n4, n3 += (n5 + 1) * this.padding + this.indentY);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.colSizes == null) {
            this.preferredSize = this.preferredLayoutSize(container);
        }
        if (this.minColSizes == null) {
            this.minimumSize = this.minimumLayoutSize(container);
        }
        int n = dimension.width;
        int n2 = this.rows.size();
        n = this.maxRowWidth > 1.0 ? Math.max((int)this.maxRowWidth, n) : (int)(this.maxRowWidth * (double)n);
        int n3 = Math.max(Math.max(this.minimumSize.width, this.preferredSize.width), n);
        double d = (double)n3 / (double)this.preferredSize.width;
        int n4 = this.padding + this.indentY;
        for (int i = 0; i < n2; ++i) {
            XRow xRow = (XRow)this.rows.get(i);
            int n5 = xRow.getPreferredHeight();
            int n6 = this.padding + this.indentX;
            for (int j = 0; j < this.numCols; ++j) {
                Component component = xRow.components[j];
                if (component != null) {
                    component.setBounds((int)(d * (double)n6), n4, (int)(d * (double)this.colSizes[j]), n5);
                }
                n6 += this.colSizes[j] + this.padding;
            }
            n4 += n5 + this.padding;
        }
    }

    private class XRow {
        public Component[] components;

        public XRow(int n) {
            this.components = new Component[n];
        }

        public int getPreferredHeight() {
            int n = 0;
            for (int i = 0; i < this.components.length; ++i) {
                n = Math.max(n, this.getPreferredHeight(i));
            }
            return n;
        }

        public int getWidth(int n) {
            if (this.components[n] != null) {
                return this.components[n].getWidth();
            }
            return 0;
        }

        public int getHeight(int n) {
            if (this.components[n] != null) {
                return this.components[n].getHeight();
            }
            return 0;
        }

        public int getMinimumWidth(int n) {
            if (this.components[n] != null) {
                return this.components[n].getMinimumSize().width;
            }
            return 0;
        }

        public int getMinimumHeight(int n) {
            if (this.components[n] != null) {
                return this.components[n].getMinimumSize().height;
            }
            return 0;
        }

        public int getMaximumWidth(int n) {
            if (this.components[n] != null) {
                return this.components[n].getMaximumSize().width;
            }
            return 0;
        }

        public int getMaximumHeight(int n) {
            if (this.components[n] != null) {
                return this.components[n].getMaximumSize().height;
            }
            return 0;
        }

        public int getPreferredWidth(int n) {
            if (this.components[n] != null) {
                return this.components[n].getPreferredSize().width;
            }
            return 0;
        }

        public int getPreferredHeight(int n) {
            if (this.components[n] != null) {
                return this.components[n].getPreferredSize().height;
            }
            return 0;
        }
    }
}

