/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.langmgr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import net.xoetrope.xui.helper.ResourceBundleEx;

public class EncodedResourceBundle
extends ResourceBundle
implements ResourceBundleEx {
    private Map lookup;
    private Hashtable encodingProperties;

    public EncodedResourceBundle(BufferedReader bufferedReader, Hashtable hashtable) throws IOException, UnsupportedEncodingException {
        Properties properties = new Properties();
        this.loadProperties(properties, bufferedReader);
        this.lookup = new HashMap<Object, Object>(properties);
        this.encodingProperties = hashtable;
    }

    public Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.lookup.get(string);
    }

    public Hashtable getEncodingProperties() {
        return this.encodingProperties;
    }

    public Enumeration getKeys() {
        ResourceBundle resourceBundle = this.parent;
        return new ResourceBundleEnumeration(this.lookup.keySet(), resourceBundle != null ? resourceBundle.getKeys() : null);
    }

    protected void loadProperties(Properties properties, BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            int n = string.indexOf(61);
            if (n <= 0 || (string2 = string.substring(0, n)).startsWith("#")) continue;
            String string3 = string.substring(n + 1);
            properties.put(string2, string3);
        }
    }

    class ResourceBundleEnumeration
    implements Enumeration {
        Set set;
        Iterator iterator;
        Enumeration enumeration;
        String next = null;

        ResourceBundleEnumeration(Set set, Enumeration enumeration) {
            this.set = set;
            this.iterator = set.iterator();
            this.enumeration = enumeration;
        }

        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = (String)this.iterator.next();
                } else if (this.enumeration != null) {
                    while (this.next == null && this.enumeration.hasMoreElements()) {
                        this.next = (String)this.enumeration.nextElement();
                        if (!this.set.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.next;
                this.next = null;
                return string;
            }
            throw new NoSuchElementException();
        }
    }
}

