/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth.svgsalamander;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.xoetrope.optional.laf.ImageConverter;

public class SvgImageTranscoder
implements ImageConverter {
    protected String imageFormat = "png";

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public boolean convert(String string, InputStream inputStream, OutputStream outputStream, int n, int n2) {
        try {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = this.convert(string, inputStream, n, n2);
            ImageIO.write((RenderedImage)bufferedImage2, this.imageFormat, outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public BufferedImage convert(String string, InputStream inputStream, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            SVGUniverse sVGUniverse = SVGCache.getSVGUniverse();
            SVGDiagram sVGDiagram = sVGUniverse.getDiagram(sVGUniverse.loadSVG(inputStream, string));
            if (sVGDiagram != null) {
                SVGRoot sVGRoot = sVGDiagram.getRoot();
                sVGRoot.setAttribute("width", 1, Double.toString(n));
                sVGRoot.setAttribute("height", 1, Double.toString(n2));
                sVGRoot.build();
                sVGDiagram.setIgnoringClipHeuristic(true);
                sVGRoot.render(graphics2D);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public String getOutputExt() {
        return "." + this.imageFormat;
    }
}

