/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.xoetrope.optional.laf.synth.ImagePainter;

public class WidgetPainter
extends SynthPainter {
    private static HashSet treeCache = new HashSet();
    private static HashMap painters = new HashMap();

    public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTree jTree = (JTree)synthContext.getComponent();
        if (!treeCache.contains(jTree)) {
            treeCache.add(jTree);
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
            if (defaultTreeCellRenderer.getClass().getName().startsWith("javax.swing.plaf.synth.Synth")) {
                defaultTreeCellRenderer = new DefaultTreeCellRenderer();
                jTree.setCellRenderer(defaultTreeCellRenderer);
                Color color = UIManager.getColor("Tree.selectionBackground");
                defaultTreeCellRenderer.setBackgroundSelectionColor(color);
                color = UIManager.getColor("Tree.selectionForeground");
                defaultTreeCellRenderer.setTextSelectionColor(color);
                Icon icon = (Icon)synthContext.getStyle().get(synthContext, "Tree.leafIcon");
                defaultTreeCellRenderer.setLeafIcon(icon);
                Icon icon2 = (Icon)synthContext.getStyle().get(synthContext, "Tree.openIcon");
                defaultTreeCellRenderer.setOpenIcon(icon2);
                Icon icon3 = (Icon)synthContext.getStyle().get(synthContext, "Tree.closedIcon");
                defaultTreeCellRenderer.setClosedIcon(icon3);
            }
        }
    }

    public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComboBox jComboBox = (JComboBox)synthContext.getComponent();
        if (!jComboBox.isEnabled()) {
            Color color = UIManager.getColor("ComboBox.disabledColor");
            jComboBox.setBackground(color);
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        } else if (!jComboBox.isEditable()) {
            Color color = UIManager.getColor("ComboBox.lockedColor");
            jComboBox.setBackground(color);
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = (String)UIManager.get("ScrollBarThumb.image");
        Insets insets = new Insets(3, 3, 3, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
        int n6 = 8;
        if (n3 - 2 <= n6) {
            return;
        }
        String string3 = (String)UIManager.get("ScrollBarThumb.dimple");
        imagePainter = new ImagePainter(synthContext, graphics, n + n3 / 2 - 4, n2 + n4 / 2 - 4, 8, 8, string3, insets, insets2, true, true);
        imagePainter.paint(graphics);
    }

    public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        jTabbedPane.setBackground(jTabbedPane.getBackground());
        String string = (String)UIManager.get("TabbedPane.content.image");
        Insets insets = (Insets)UIManager.get("TabbedPane.content.insets");
        Insets insets2 = (Insets)insets.clone();
        int n5 = 0;
        int n6 = jTabbedPane.getTabPlacement();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(i);
            if (n6 == 1 || n6 == 1) {
                n5 += rectangle.width;
                continue;
            }
            n5 += rectangle.height;
        }
        ImagePainter imagePainter = (ImagePainter)painters.get(string);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, 100, 50, string, insets, insets2, true, true, true);
            imagePainter.setW(n3);
            imagePainter.setH(n4);
            painters.put(string, imagePainter);
        }
        imagePainter.drawTopLeft(graphics);
        imagePainter.drawTopCenter(graphics);
        imagePainter.drawTopRight(graphics);
        imagePainter.drawLeft(graphics);
        imagePainter.drawBottomLeft(graphics);
        imagePainter.drawBottomCenter(graphics);
        imagePainter.drawBottomRight(graphics);
        imagePainter.drawRight(graphics);
        graphics.setColor(new Color(752852));
        this.underlineTabs(jTabbedPane, graphics, n, n2, n3, n4, n5, n6, insets, insets2);
    }

    public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        jTabbedPane.setBackground(jTabbedPane.getBackground());
        String string = (String)UIManager.get("TabbedPane.tab.border");
        Insets insets = (Insets)UIManager.get("TabbedPane.content.insets");
        Insets insets2 = (Insets)insets.clone();
        ImagePainter imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true, true);
        imagePainter.paint(graphics);
    }

    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Insets insets;
        String string;
        graphics.setColor(new Color(61166));
        JComponent jComponent = synthContext.getComponent();
        int n6 = ((JTabbedPane)synthContext.getComponent()).getTabPlacement();
        int n7 = synthContext.getComponentState();
        if ((n7 & 0x200) > 0) {
            string = (String)UIManager.get("TabbedPane.tab.selected");
            insets = (Insets)UIManager.get("TabbedPane.tab.insets.selected");
        } else if ((n7 & 8) > 0) {
            string = (String)UIManager.get("TabbedPane.tab.disabled");
            insets = (Insets)UIManager.get("TabbedPane.tab.insets.disabled");
        } else if (jComponent.hasFocus()) {
            string = (String)UIManager.get("TabbedPane.tab.focused");
            insets = (Insets)UIManager.get("TabbedPane.tab.insets.focused");
        } else {
            string = (String)UIManager.get("TabbedPane.tab.default.image");
            insets = (Insets)UIManager.get("TabbedPane.tab.default.insets");
        }
        if (string == null) {
            string = "tab.svg";
        }
        if (n6 == 2) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        }
        if (n6 == 4) {
            insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        Insets insets2 = (Insets)insets.clone();
        if (n6 == 1) {
            insets2.bottom = 0;
        } else if (n6 == 2) {
            insets2.right = 0;
            insets.right = 4;
        } else if (n6 == 3) {
            insets2.top = 0;
        } else if (n6 == 4) {
            insets2.left = 0;
            insets.left = 4;
        }
        ImagePainter imagePainter = (ImagePainter)painters.get(string);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true, true);
            painters.put(string, imagePainter);
        }
        if (n6 != 3) {
            imagePainter.drawTopLeft(graphics);
            imagePainter.drawTopCenter(graphics);
            imagePainter.drawTopRight(graphics);
        }
        if (n6 != 4) {
            imagePainter.drawLeft(graphics);
        }
        if (n6 != 1) {
            imagePainter.drawBottomLeft(graphics);
            imagePainter.drawBottomCenter(graphics);
            imagePainter.drawBottomRight(graphics);
        }
        if (n6 != 2) {
            imagePainter.drawRight(graphics);
        }
        imagePainter.drawCenter(graphics);
    }

    private void underlineTabs(JTabbedPane jTabbedPane, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Insets insets, Insets insets2) {
        boolean bl = jTabbedPane.getComponentOrientation().isLeftToRight();
        if (n6 == 1) {
            if (bl) {
                graphics.drawLine(n + insets2.left + 1, n2, n + insets2.left + n5 - 1, n2);
            } else {
                graphics.drawLine(n + n3 - insets2.right * 2 - n5, n2, n + n3 - insets2.right * 2 - 1, n2);
            }
        } else if (n6 == 2) {
            graphics.drawLine(n, n2 + insets2.top + 1, n, n2 + insets2.top + n5 - 1);
        } else if (n6 == 3) {
            if (bl) {
                graphics.drawLine(n + insets2.left + 1, n2 + n4 - 1, n + insets2.left + n5 - 1, n2 + n4 - 1);
            } else {
                graphics.drawLine(n + n3 - insets2.right * 2 - n5, n2 + n4 - 1, n + n3 - insets2.right * 2 - 1, n2 + n4 - 1);
            }
        } else if (n6 == 4) {
            graphics.drawLine(n + n3 - 1, n2 + insets2.top + 1, n + n3 - 1, n2 + insets2.top + n5 - 1);
        }
    }
}

