/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import net.xoetrope.optional.laf.synth.ImagePainter;

public class TextPainter
extends SynthPainter {
    private static HashSet opaqueTips = new HashSet();
    private static HashMap painters = new HashMap();

    public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = (String)UIManager.get("TextField.border");
        Insets insets = new Insets(1, 1, 1, 1);
        Insets insets2 = new Insets(1, 1, 1, 1);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, false);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRoundRect(1, 1, n3 - 2, n4 - 2, 3, 3);
    }

    public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JLabel jLabel = (JLabel)synthContext.getComponent();
        Container container = jLabel.getParent();
        String string = jLabel.getName();
        if (string != null && string.startsWith("ComboBox.")) {
            jLabel.setOpaque(true);
        }
        if (string != null && string.startsWith("TableHeader.")) {
            jLabel.setFont(new Font(jLabel.getName(), 1, jLabel.getFont().getSize()));
            Color color = (Color)UIManager.get("TableHeader.gridColor");
            graphics.setColor(color);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            return;
        }
        if (!(container instanceof CellRendererPane) || !(container.getParent() instanceof JComboBox)) {
            super.paintLabelBackground(synthContext, graphics, n, n2, n3, n4);
            return;
        }
        JComboBox jComboBox = (JComboBox)container.getParent();
        Color color = null;
        Color color2 = null;
        if (!jComboBox.isEnabled()) {
            color = UIManager.getColor("Label.TextColor_disabled");
            color2 = UIManager.getColor("Label.BackgroundColor_disabled");
        } else if (!jComboBox.isEditable()) {
            color = UIManager.getColor("Label.lockedTextColor_");
            color2 = UIManager.getColor("Label.lockedBackgroundColor");
        }
        jLabel.setForeground(color);
        jLabel.setBackground(color2);
        graphics.setColor(color2);
        graphics.fillRect(n, n2, n3, n4);
    }

    public void paintEditorPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JEditorPane jEditorPane = (JEditorPane)synthContext.getComponent();
        if (!jEditorPane.isEditable()) {
            graphics.setColor(UIManager.getColor("EditorPane.lockedColor"));
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTextArea jTextArea = (JTextArea)synthContext.getComponent();
        if (!jTextArea.isEnabled()) {
            Color color = UIManager.getColor("TextArea.disabledColor");
            jTextArea.setBackground(color);
        } else if (!jTextArea.isEditable()) {
            Color color = UIManager.getColor("TextArea.lockedColor");
            jTextArea.setBackground(color);
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JToolTip jToolTip = (JToolTip)synthContext.getComponent();
        JPanel jPanel = (JPanel)jToolTip.getParent();
        if (!opaqueTips.contains(jToolTip)) {
            jToolTip.setOpaque(false);
            jPanel.setOpaque(false);
            jPanel.repaint();
            jToolTip.repaint();
            opaqueTips.add(jToolTip);
        }
        String string = (String)UIManager.get("ToolTip.background");
        Insets insets = new Insets(7, 7, 7, 7);
        Insets insets2 = new Insets(7, 7, 7, 7);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }
}

