/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.filter.FilePreprocessor;
import net.xoetrope.optional.laf.ImageConverter;
import net.xoetrope.optional.laf.synth.SvgPreprocessor;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.style.XStyleManager;

public class SynthPreprocessor
implements FilePreprocessor {
    private static Hashtable methodNames = new Hashtable();
    private static String[] weightTags = new String[]{"PLAIN", "BOLD"};
    private static String[] italicTags = new String[]{"PLAIN", "ITALIC"};
    private XStyleManager styleManager;
    private SvgPreprocessor svgPreprocessor;
    private ImageConverter imageConverter;
    private XProject currentProject = XProjectManager.getCurrentProject();
    private String transcoderClassName;

    public SynthPreprocessor() {
        String string = this.currentProject.getStartupParam("TranscoderClass");
        this.transcoderClassName = string != null ? string : "net.xoetrope.optional.laf.synth.batik.PngTranscoderWrapper";
        methodNames.put("getFontFace", new Integer(0));
        methodNames.put("getFontSize", new Integer(1));
        methodNames.put("getColorBackground", new Integer(2));
        methodNames.put("getColorForeground", new Integer(3));
        methodNames.put("getFontWeight", new Integer(4));
        methodNames.put("getFontItalic", new Integer(5));
        methodNames.put("svgToPng", new Integer(6));
        methodNames.put("svgToTiff", new Integer(7));
        methodNames.put("getColorResourceBackground", new Integer(8));
        methodNames.put("getColorResourceForeground", new Integer(9));
    }

    public String process(BufferedInputStream bufferedInputStream) throws IOException {
        this.styleManager = this.currentProject.getStyleManager();
        byte[] byArray = new byte[1000];
        if (bufferedInputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                byArray = new byte[1000];
                n = bufferedInputStream.read(byArray);
            }
            return this.findAndReplace(methodNames, byteArrayOutputStream.toString());
        }
        return null;
    }

    protected String findAndReplace(Hashtable hashtable, String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf("${", n)) > 0) {
            n3 = string.indexOf("(", n2);
            String string3 = string.substring(n2 + 2, n3);
            n4 = string.indexOf(")}", n3);
            if (n4 <= 0) continue;
            string2 = string2 + string.substring(n, n2);
            n = n4 + 2;
            String string4 = "";
            String string5 = string.substring(n3 + 1, n4);
            string5 = this.findAndReplace(hashtable, string5);
            switch ((Integer)hashtable.get(string3)) {
                case 0: {
                    string4 = this.getStyleAttribute(string5, 0);
                    break;
                }
                case 1: {
                    string4 = this.getStyleAttribute(string5, 1);
                    break;
                }
                case 2: {
                    string4 = this.getColorStyleAttribute(string5, 4, false);
                    break;
                }
                case 3: {
                    string4 = this.getColorStyleAttribute(string5, 5, false);
                    break;
                }
                case 4: {
                    string4 = this.getIndexedStyleAttribute(string5, 2, weightTags);
                    break;
                }
                case 5: {
                    string4 = this.getIndexedStyleAttribute(string5, 3, italicTags);
                    break;
                }
                case 6: {
                    string4 = this.getPngForSvg(string5);
                    break;
                }
                case 7: {
                    string4 = this.getTiffForSvg(string5);
                    break;
                }
                case 8: {
                    string4 = this.getColorStyleAttribute(string5, 4, true);
                    break;
                }
                case 9: {
                    string4 = this.getColorStyleAttribute(string5, 5, true);
                }
            }
            string2 = string2 + string4;
        }
        if (n4 == 0) {
            return string;
        }
        if (n4 < string.length()) {
            string2 = string2 + string.substring(n4 + 2);
        }
        return string2;
    }

    protected String getStyleAttribute(String string, int n) {
        return this.styleManager.getStyle(string.trim()).getStyleAsString(n);
    }

    protected String getColorStyleAttribute(String string, int n, boolean bl) {
        Color color = this.styleManager.getStyle(string.trim()).getStyleAsColor(n);
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        String string2 = "";
        if (!bl) {
            if (n2 < 11) {
                string2 = "0";
            }
            string2 = string2 + Integer.toHexString(n2);
            if (n3 < 11) {
                string2 = string2 + "0";
            }
            string2 = string2 + Integer.toHexString(n3);
            if (n4 < 11) {
                string2 = string2 + "0";
            }
            string2 = string2 + Integer.toHexString(n4);
        } else {
            string2 = "<int>";
            string2 = string2 + Integer.toString(n2);
            string2 = string2 + "</int>";
            string2 = string2 + "<int>";
            string2 = string2 + Integer.toString(n3);
            string2 = string2 + "</int>";
            string2 = string2 + "<int>";
            string2 = string2 + Integer.toString(n4);
            string2 = string2 + "</int>";
        }
        return string2;
    }

    protected String getIndexedStyleAttribute(String string, int n, String[] stringArray) {
        int n2 = this.styleManager.getStyle(string.trim()).getStyleAsInt(n);
        return stringArray[Math.min(n2, stringArray.length)];
    }

    protected String getPngForSvg(String string) {
        int n = 50;
        int n2 = 50;
        int n3 = string.indexOf(44);
        if (n3 > 0) {
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(n3 + 1, n4));
            n2 = Integer.parseInt(string.substring(n4 + 1));
            string = string.substring(0, n3);
        }
        return this.convertSvg(string.trim(), n, n2, true);
    }

    protected String getTiffForSvg(String string) {
        int n = 50;
        int n2 = 50;
        int n3 = string.indexOf(44);
        if (n3 > 0) {
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(n3 + 1, n4));
            n2 = Integer.parseInt(string.substring(n4 + 1));
            string = string.substring(0, n3);
        }
        return this.convertSvg(string.trim(), n, n2, false);
    }

    protected String convertSvg(String string, int n, int n2, boolean bl) {
        XProject xProject = XProjectManager.getCurrentProject();
        int n3 = string.indexOf(".svg");
        try {
            Object object;
            Object object2;
            int n4;
            Class<?> clazz;
            URL uRL = xProject.getUrl(string);
            String string2 = uRL.toString();
            if (this.imageConverter == null) {
                clazz = null;
                clazz = !bl ? Class.forName("net.xoetrope.optional.laf.synth.batik.TiffTranscoderWrapper") : Class.forName(this.transcoderClassName.trim());
                if (clazz == null) {
                    return string;
                }
                this.imageConverter = (ImageConverter)clazz.newInstance();
            }
            if ((n4 = ((String)((Object)(clazz = string.substring(0, n3) + this.imageConverter.getOutputExt()))).indexOf("svg/")) >= 0) {
                clazz = ((String)((Object)clazz)).substring(0, n4) + ((String)((Object)clazz)).substring(n4 + 4);
            }
            String string3 = string2.substring(0, string2.indexOf(string)) + (String)((Object)clazz);
            try {
                object2 = new File(uRL.toURI());
                object = new File(new URL(string3).toURI());
                if (((File)object).lastModified() > ((File)object2).lastModified()) {
                    DebugLogger.trace((String)("File up-to-date, no need to convert: " + string));
                    return clazz;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string3.indexOf("file:") == 0) {
                string3 = string3.substring(6);
            }
            if ((object2 = xProject.getBufferedInputStream(string2)) != null) {
                if (this.svgPreprocessor == null) {
                    this.svgPreprocessor = (SvgPreprocessor)SvgPreprocessor.class.newInstance();
                }
                object = this.svgPreprocessor.process((BufferedInputStream)object2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                this.imageConverter.convert(string, byteArrayInputStream, fileOutputStream, n, n2);
                return clazz;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "synth/blank.png";
        }
        return string;
    }
}

