/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.xoetrope.optional.laf.ImageConverter;

public class SynthClassLoader
extends ClassLoader {
    private boolean loadStub = false;
    private static ImageConverter imageConverter;
    private static String convertClassName;
    private static boolean overwriteImages;

    public SynthClassLoader() {
        SynthClassLoader.setupConverter();
    }

    public SynthClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SynthClassLoader.setupConverter();
    }

    private static void setupConverter() {
        if (imageConverter == null) {
            try {
                Class<?> clazz = Class.forName(convertClassName.trim());
                if (clazz == null) {
                    return;
                }
                imageConverter = (ImageConverter)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public URL getResource(String string) {
        if (this.loadStub) {
            return super.getResource(string.replace('.', File.separatorChar) + ".class");
        }
        int n = string.indexOf(".svg");
        if (n > 0) {
            int n2 = string.lastIndexOf(47);
            String string2 = n2 >= 0 ? string.substring(n2 + 1) : string;
            try {
                URL uRL = super.getResource(string2);
                String string3 = uRL.toString();
                String string4 = string3.substring(0, string3.indexOf(".svg")) + ".png";
                String string5 = string4.indexOf("file:") == 0 ? string4.substring(6) : string4;
                this.generatePng(string2, string3, string5, 18, 18);
                return new URL(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return super.getResource(string2);
            }
        }
        return super.getResource(string.substring("net.xoetrope.optional.laf.synth".length() + 1));
    }

    public Class loadStubClass(String string) throws ClassNotFoundException {
        try {
            this.loadStub = true;
            Class clazz = this.findClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        finally {
            this.loadStub = false;
        }
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (string.indexOf(".svg") > 0) {
            return this.findClass(string);
        }
        return super.loadClass(string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        InputStream inputStream = super.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = SynthClassLoader.class.getClassLoader().getResourceAsStream(string.replace('.', '/') + ".class");
        }
        byte[] byArray = new byte[1000];
        try {
            int n = inputStream.read(byArray);
            assert (n < 1000);
            return super.defineClass(string, byArray, 0, n);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return super.findClass(string);
    }

    protected void generatePng(String string, String string2, String string3, int n, int n2) throws Exception {
        InputStream inputStream;
        File file = new File(string3);
        if ((overwriteImages || !file.exists()) && (inputStream = new URL(string2).openStream()) != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            imageConverter.convert(string, inputStream, fileOutputStream, n, n2);
            fileOutputStream.close();
        }
    }

    public static void setConvertClassName(String string) {
        convertClassName = string;
        imageConverter = null;
        SynthClassLoader.setupConverter();
    }

    public static void setOverwriteImages(boolean bl) {
        overwriteImages = bl;
    }

    static {
        convertClassName = "net.xoetrope.optional.laf.synth.svgsalamander.SvgImageTranscoder";
        overwriteImages = true;
    }
}

