/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import net.xoetrope.optional.filter.FilePreprocessor;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.style.XStyleManager;

public class SvgPreprocessor
implements FilePreprocessor {
    private static Hashtable methodNames = new Hashtable();
    private XProject currentProject = XProjectManager.getCurrentProject();

    protected SvgPreprocessor() {
        methodNames.put("getColorForegroundRgb", new Integer(0));
        methodNames.put("getColorForegroundHex", new Integer(1));
        methodNames.put("getColorBackgroundRgb", new Integer(2));
        methodNames.put("getColorBackgroundHex", new Integer(3));
        methodNames.put("getHsbColorForegroundRgb", new Integer(4));
        methodNames.put("getHsbColorForegroundHex", new Integer(5));
        methodNames.put("getHsbColorBackgroundHex", new Integer(6));
        methodNames.put("getHsbColorBackgroundHex", new Integer(7));
    }

    public String process(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1000];
        if (bufferedInputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                byArray = new byte[1000];
                n = bufferedInputStream.read(byArray);
            }
            return this.findAndReplace(methodNames, byteArrayOutputStream.toString());
        }
        return null;
    }

    protected String findAndReplace(Hashtable hashtable, String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf("${", n)) > 0) {
            n3 = string.indexOf("(", n2);
            String string3 = string.substring(n2 + 2, n3);
            n4 = string.indexOf(")}", n3);
            if (n4 <= 0) continue;
            string2 = string2 + string.substring(n, n2);
            n = n4 + 2;
            String string4 = "";
            String string5 = string.substring(n3 + 1, n4);
            string5 = this.findAndReplace(hashtable, string5);
            switch ((Integer)hashtable.get(string3)) {
                case 0: {
                    string4 = this.getColorStyleAttribute(string5, 5, true, false);
                    break;
                }
                case 1: {
                    string4 = this.getColorStyleAttribute(string5, 5, false, false);
                    break;
                }
                case 2: {
                    string4 = this.getColorStyleAttribute(string5, 4, true, false);
                    break;
                }
                case 3: {
                    string4 = this.getColorStyleAttribute(string5, 4, false, false);
                    break;
                }
                case 4: {
                    string4 = this.getColorStyleAttribute(string5, 5, true, true);
                    break;
                }
                case 5: {
                    string4 = this.getColorStyleAttribute(string5, 5, false, true);
                    break;
                }
                case 6: {
                    string4 = this.getColorStyleAttribute(string5, 4, true, true);
                    break;
                }
                case 7: {
                    string4 = this.getColorStyleAttribute(string5, 4, false, true);
                }
            }
            string2 = string2 + string4;
        }
        if (n4 == 0) {
            return string;
        }
        if (n4 < string.length()) {
            string2 = string2 + string.substring(n4 + 2);
        }
        return string2;
    }

    protected String getColorStyleAttribute(String string, int n, boolean bl, boolean bl2) {
        Object object;
        int n2;
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        int n3 = 100;
        int n4 = 100;
        int n5 = 100;
        int n6 = string.indexOf(44);
        if (n6 > 0) {
            int n7 = string.indexOf(44, n6 + 1);
            n2 = string.indexOf(44, n7 + 1);
            n3 = Integer.parseInt(string.substring(n6 + 1, n7));
            n4 = Integer.parseInt(string.substring(n7 + 1, n2));
            n5 = Integer.parseInt(string.substring(n2 + 1));
            string = string.substring(0, n6);
        }
        Color color = xStyleManager.getStyle(string.trim()).getStyleAsColor(n);
        n2 = color.getRed();
        int n8 = color.getGreen();
        int n9 = color.getBlue();
        if (!bl2) {
            if (n3 < 100) {
                n2 = n3 * n2 / 100;
            } else if (n3 > 100) {
                n2 += (255 - n2) * (Math.max(n3, 200) - 100) / 100;
            }
            if (n4 < 100) {
                n8 = n4 * n8 / 100;
            } else if (n4 > 100) {
                n8 += (255 - n8) * (Math.max(n4, 200) - 100) / 100;
            }
            if (n5 < 100) {
                n9 = n5 * n9 / 100;
            } else if (n5 > 100) {
                n9 += (255 - n9) * (Math.max(n5, 200) - 100) / 100;
            }
        } else {
            object = Color.RGBtoHSB(n2, n8, n9, null);
            if ((float)n3 < 100.0f) {
                object[0] = (float)n3 * object[0] / 100.0f;
            } else if ((float)n3 > 100.0f) {
                object[0] = object[0] + (255.0f - object[0]) * (Math.max((float)n3, 200.0f) - 100.0f) / 100.0f;
            }
            if ((float)n4 < 100.0f) {
                object[1] = (float)n4 * object[1] / 100.0f;
            } else if ((float)n4 > 100.0f) {
                object[1] = object[1] + (255.0f - object[1]) * (Math.max((float)n4, 200.0f) - 100.0f) / 100.0f;
            }
            if ((float)n5 < 100.0f) {
                object[2] = (float)n5 * object[2] / 100.0f;
            } else if ((float)n5 > 100.0f) {
                object[2] = object[2] + (255.0f - object[2]) * (Math.max((float)n5, 200.0f) - 100.0f) / 100.0f;
            }
            Color color2 = Color.getHSBColor(object[0], object[1], object[2]);
            n2 = color2.getRed();
            n8 = color2.getGreen();
            n9 = color2.getBlue();
        }
        object = "";
        if (bl) {
            object = "rgb(" + n2 + "," + n8 + "," + n9 + ")";
        } else {
            if (n2 < 11) {
                object = "0";
            }
            object = (String)object + Integer.toHexString(n2);
            if (n8 < 11) {
                object = (String)object + "0";
            }
            object = (String)object + Integer.toHexString(n8);
            if (n9 < 11) {
                object = (String)object + "0";
            }
            object = (String)object + Integer.toHexString(n9);
        }
        return object;
    }
}

