/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import net.xoetrope.optional.laf.synth.ImagePainter;

public class ScrollPainter
extends SynthPainter {
    private static HashSet scrollerCache = new HashSet();
    private static HashMap painters = new HashMap();

    public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        if (scrollerCache.contains(jScrollPane)) {
            return;
        }
        scrollerCache.add(jScrollPane);
        Component component = jScrollPane.getViewport().getView();
        Color color = component.getBackground();
        if (component instanceof JEditorPane) {
            JEditorPane jEditorPane = (JEditorPane)component;
            if (!jEditorPane.isEditable()) {
                color = UIManager.getColor("EditorPane.lockedColor");
            } else if (!jEditorPane.isEnabled()) {
                color = UIManager.getColor("EditorPane.disabledColor");
            }
        } else if (component instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)component;
            if (!jTextArea.isEditable()) {
                color = UIManager.getColor("TextArea.lockedColor");
            } else if (!jTextArea.isEnabled()) {
                color = UIManager.getColor("TextArea.disabledColor");
            }
        } else if (component instanceof JTable) {
            Color color2 = UIManager.getColor("Table.scrollPane.borderColor");
            jScrollPane.setBorder(BorderFactory.createLineBorder(color2));
        }
        jScrollPane.setBackground(color);
    }

    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        Component component = jScrollPane.getViewport().getView();
        String string = null;
        if (component.isEnabled()) {
            object = UIManager.get("ScrollPane.border");
            if (!(object instanceof String)) {
                return;
            }
            string = (String)UIManager.get("ScrollPane.border");
        } else {
            string = (String)UIManager.get("ScrollPane.borderDisabled");
        }
        object = new Insets(3, 3, 3, 3);
        Insets insets = new Insets(3, 3, 3, 3);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, (Insets)object, insets, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = (String)UIManager.get("ScrollBarThumb.image");
        Insets insets = new Insets(3, 3, 3, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
        int n6 = 8;
        if (n3 - 2 <= n6) {
            return;
        }
        String string3 = (String)UIManager.get("ScrollBarThumb.dimple");
        string2 = string3 + "_" + n3 + "_" + n4;
        imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n + n3 / 2 - 4, n2 + n4 / 2 - 4, 8, 8, string3, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }
}

