/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.laf.ImageConverter;
import net.xoetrope.optional.laf.synth.svgsalamander.SvgImageTranscoder;
import net.xoetrope.optional.svg.svgsalamander.XSvgPainter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;

public class ImagePainter
extends SynthPainter {
    private int x;
    private int y;
    private int w;
    private int h;
    private int imageWidth;
    private int imageHeight;
    private Image image;
    private XSvgPainter painter;
    private Insets sourceInsets;
    private Insets destinationInsets;
    private boolean tiles;
    private boolean paintCenter;
    private boolean convertSvg;
    private Object renderingHint;
    private Object lastHint;
    private XProject currentProject = XProjectManager.getCurrentProject();
    private SynthContext context;
    private static ImageConverter imageConverter;

    public ImagePainter() {
    }

    public ImagePainter(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, String string, Insets insets, Insets insets2, boolean bl, boolean bl2, boolean bl3) {
        this.convertSvg = bl3;
        this.context = synthContext;
        this.x = n;
        this.y = n2;
        this.setW(n3);
        this.setH(n4);
        this.tiles = bl;
        this.paintCenter = bl2;
        this.image = this.getImage(string);
        if (this.image != null) {
            this.imageWidth = this.image.getWidth(null);
            this.imageHeight = this.image.getHeight(null);
        }
        this.sourceInsets = insets;
        this.destinationInsets = insets2;
    }

    public ImagePainter(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, String string, Insets insets, Insets insets2, boolean bl, boolean bl2) {
        this(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, bl, bl2, false);
    }

    public Image getImage(String string) {
        return this.getImage(string, this.convertSvg);
    }

    public Image getImage(String string, boolean bl) {
        URL uRL;
        block10: {
            try {
                if (this.painter == null) {
                    this.painter = new XSvgPainter(this.context.getComponent());
                }
                if (this.image != null) {
                    return this.image;
                }
                if (bl) {
                    if (imageConverter == null) {
                        imageConverter = new SvgImageTranscoder();
                    }
                    if ((uRL = this.currentProject.findResource(string.substring(0, string.lastIndexOf(46)) + ".svg")) != null) {
                        String string2;
                        String string3 = string2 = uRL.getPath();
                        File file = new File(string2.substring(0, string2.lastIndexOf(46)) + ".png");
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        imageConverter.convert(string3, uRL.openStream(), fileOutputStream, this.w, this.h);
                        fileOutputStream.close();
                        string = string3.substring(0, string3.indexOf(46)) + ".png";
                    } else {
                        DebugLogger.logError((String)("Image not found: " + string));
                    }
                    break block10;
                }
                int n = string.lastIndexOf(47);
                String string4 = string.substring(0, n + 1);
                String string5 = string.substring(n + 1);
                string5 = string5.substring(0, string5.indexOf(46));
                URL uRL2 = this.currentProject.getUrl(string5 + ".svg");
                this.painter.setImage(uRL2);
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        uRL = this.currentProject.getUrl(string);
        if (uRL != null) {
            this.image = new ImageIcon(uRL).getImage();
        }
        if (this.image == null) {
            return new ImageIcon(string, null).getImage();
        }
        return this.image;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.renderingHint != null) {
            this.lastHint = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (this.lastHint == null) {
                this.lastHint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHint);
        } else {
            this.lastHint = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (this.painter != null) {
            this.painter.setInsets(this.sourceInsets);
            this.painter.paint(graphics2D, this.context.getComponent(), this.w, this.h);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, this.lastHint);
            return;
        }
        this.drawTopLeft(graphics);
        this.drawTopCenter(graphics);
        this.drawTopRight(graphics);
        this.drawLeft(graphics);
        this.drawRight(graphics);
        this.drawBottomLeft(graphics);
        this.drawBottomCenter(graphics);
        this.drawBottomRight(graphics);
        this.drawCenter(graphics);
    }

    public void drawTopLeft(Graphics graphics) {
        graphics.drawImage(this.image, this.x, this.y, this.x + this.destinationInsets.left, this.y + this.destinationInsets.top, 0, 0, this.sourceInsets.left, this.sourceInsets.top, null);
    }

    public void drawTopCenter(Graphics graphics) {
        this.drawChunk(this.image, graphics, this.tiles, this.x + this.destinationInsets.left, this.y, this.x + this.w - this.destinationInsets.right, this.y + this.destinationInsets.top, this.sourceInsets.left, 0, this.imageWidth - this.sourceInsets.right, this.sourceInsets.top, true);
    }

    public void drawTopRight(Graphics graphics) {
        graphics.drawImage(this.image, this.x + this.w - this.destinationInsets.right, this.y, this.x + this.w, this.y + this.destinationInsets.top, this.imageWidth - this.sourceInsets.right, 0, this.imageWidth, this.sourceInsets.top, null);
    }

    public void drawRight(Graphics graphics) {
        this.drawChunk(this.image, graphics, this.tiles, this.x + this.w - this.destinationInsets.right, this.y + this.destinationInsets.top, this.x + this.w, this.y + this.h - this.destinationInsets.bottom, this.imageWidth - this.sourceInsets.right, this.sourceInsets.top, this.imageWidth, this.imageHeight - this.sourceInsets.bottom, false);
    }

    public void drawBottomRight(Graphics graphics) {
        graphics.drawImage(this.image, this.x + this.w - this.destinationInsets.right, this.y + this.h - this.destinationInsets.bottom, this.x + this.w, this.y + this.h, this.imageWidth - this.sourceInsets.right, this.imageHeight - this.sourceInsets.bottom, this.imageWidth, this.imageHeight, null);
    }

    public void drawBottomCenter(Graphics graphics) {
        this.drawChunk(this.image, graphics, this.tiles, this.x + this.destinationInsets.left, this.y + this.h - this.destinationInsets.bottom, this.x + this.w - this.destinationInsets.right, this.y + this.h, this.sourceInsets.left, this.imageHeight - this.sourceInsets.bottom, this.imageWidth - this.sourceInsets.right, this.imageHeight, true);
    }

    public void drawBottomLeft(Graphics graphics) {
        graphics.drawImage(this.image, this.x, this.y + this.h - this.destinationInsets.bottom, this.x + this.destinationInsets.left, this.y + this.h, 0, this.imageHeight - this.sourceInsets.bottom, this.sourceInsets.left, this.imageHeight, null);
    }

    public void drawLeft(Graphics graphics) {
        this.drawChunk(this.image, graphics, this.tiles, this.x, this.y + this.destinationInsets.top, this.x + this.destinationInsets.left, this.y + this.h - this.destinationInsets.bottom, 0, this.sourceInsets.top, this.sourceInsets.left, this.imageHeight - this.sourceInsets.bottom, false);
    }

    public void drawCenter(Graphics graphics) {
        if (this.paintCenter) {
            graphics.drawImage(this.image, this.x + this.destinationInsets.left, this.y + this.destinationInsets.top, this.x + this.w - this.destinationInsets.right, this.y + this.h - this.destinationInsets.bottom, this.sourceInsets.left, this.sourceInsets.top, this.imageWidth - this.sourceInsets.right, this.imageHeight - this.sourceInsets.bottom, null);
        }
    }

    private void drawChunk(Image image, Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (bl) {
            graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
        } else {
            int n9;
            int n10;
            int n11 = n7 - n5;
            int n12 = n8 - n6;
            if (bl2) {
                n10 = n11;
                n9 = 0;
            } else {
                n10 = 0;
                n9 = n12;
            }
            while (n < n3 && n2 < n4) {
                int n13 = Math.min(n3, n + n11);
                int n14 = Math.min(n4, n2 + n12);
                graphics.drawImage(image, n, n2, n13, n14, n5, n6, n5 + n13 - n, n6 + n14 - n2, null);
                n += n10;
                n2 += n9;
            }
        }
    }

    public void setW(int n) {
        this.w = n;
    }

    public void setH(int n) {
        this.h = n;
    }
}

