/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.synth.SynthContext;
import net.xoetrope.optional.laf.synth.ImagePainter;

public class ButtonPainter
extends ImagePainter {
    private static final String[] checkBoxImageKeys = new String[]{"checkBoxIconOver", "checkBoxIconOnOver", "checkBoxIconDisabled", "checkBoxIconOnDisabled", "checkBoxIconOn", "checkBoxIconOff"};
    private static ImageIcon[] checkBoxImages;
    private static HashSet buttonCache;
    private static HashMap painters;

    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImagePainter imagePainter;
        String string;
        String string2;
        JButton jButton = (JButton)synthContext.getComponent();
        if (jButton.getParent() != null && jButton.getParent() instanceof JToolBar) {
            String string3;
            Insets insets = (Insets)synthContext.getStyle().get(synthContext, "Button.margin");
            if (!(buttonCache.contains(jButton) || (string3 = jButton.getText()) != null && string3.trim().length() != 0)) {
                Insets insets2 = jButton.getInsets();
                Border border = BorderFactory.createEmptyBorder(insets2.bottom - insets.bottom, insets2.left - insets.left, insets2.top - insets.top, insets2.right - insets.right);
                jButton.setBorder(border);
            }
            buttonCache.add(jButton);
            return;
        }
        if (jButton.isBorderPainted() && (string2 = (String)UIManager.get(jButton.isEnabled() ? "Button.border" : "Button.border.disabled")) != null) {
            string = string2 + "_" + n3 + "_" + n4;
            imagePainter = (ImagePainter)painters.get(string);
            if (imagePainter == null) {
                imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string2, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
                painters.put(string, imagePainter);
            }
            imagePainter.paint(graphics);
        }
        if ((string2 = (String)UIManager.get(jButton.getModel().isPressed() ? "Button.pressed" : (jButton.getModel().isRollover() ? "Button.background.over" : "Button.background"))) != null) {
            string = string2 + "_" + n3 + "_" + n4;
            imagePainter = (ImagePainter)painters.get(string);
            if (imagePainter == null) {
                imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string2, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
                painters.put(string, imagePainter);
            }
            imagePainter.paint(graphics);
        }
    }

    public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        JButton jButton = (JButton)synthContext.getComponent();
        if (jButton.isBorderPainted() && (string = (String)UIManager.get(jButton.hasFocus() ? "Button.focused" : "Button.border")) != null) {
            String string2 = string + "_" + n3 + "_" + n4;
            ImagePainter imagePainter = (ImagePainter)painters.get(string2);
            if (imagePainter == null) {
                imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
                painters.put(string2, imagePainter);
            }
            imagePainter.paint(graphics);
        }
    }

    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        if (jToggleButton.getParent() != null && jToggleButton.getParent() instanceof JToolBar) {
            return;
        }
        if (jToggleButton.isBorderPainted()) {
            String string = jToggleButton.isEnabled() ? (String)UIManager.get("ToggleButton.border") : (String)UIManager.get("ToggleButton.border.disabled");
            String string2 = string + "_" + n3 + "_" + n4;
            ImagePainter imagePainter = (ImagePainter)painters.get(string2);
            if (imagePainter == null) {
                imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
                painters.put(string2, imagePainter);
            }
            imagePainter.paint(graphics);
        }
    }

    public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = null;
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        ButtonModel buttonModel = jToggleButton.getModel();
        int n5 = 0;
        Icon icon = jToggleButton.getIcon();
        if (icon != null) {
            n5 = 1;
        }
        n5 = !jToggleButton.isEnabled() ? (jToggleButton.isSelected() ? 5 : 4) : (buttonModel.isRollover() ? (jToggleButton.isSelected() ? 3 : 2) : (jToggleButton.isSelected() ? 6 : 7));
        int n6 = n;
        int n7 = n2;
        int n8 = jToggleButton.getHorizontalTextPosition();
        int n9 = jToggleButton.getVerticalTextPosition();
        if (n8 == 2) {
            n6 += n3 - 18;
        } else if (n8 == 0) {
            n6 += (n3 - 18) / 2;
        }
        if (n9 == 1) {
            n7 += n4 - 18;
        } else if (n9 == 0) {
            n7 += (n4 - 18) / 2;
        }
        string = (String)UIManager.get(checkBoxImageKeys[0]);
        ImagePainter imagePainter = (ImagePainter)painters.get(string);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n6, n7, 18, 18, string, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
            painters.put(string, imagePainter);
        }
        if (checkBoxImages == null) {
            checkBoxImages = new ImageIcon[6];
            for (int i = 0; i < 6; ++i) {
                ButtonPainter.checkBoxImages[i] = new ImageIcon(imagePainter.getImage((String)UIManager.get(checkBoxImageKeys[i]), true));
            }
        }
        if (n5 == 2) {
            jToggleButton.setRolloverIcon(checkBoxImages[0]);
        } else if (n5 == 3) {
            jToggleButton.setRolloverSelectedIcon(checkBoxImages[1]);
        } else if (n5 == 4) {
            jToggleButton.setDisabledIcon(checkBoxImages[2]);
        } else if (n5 == 5) {
            jToggleButton.setDisabledSelectedIcon(checkBoxImages[3]);
        } else if (n5 > 1) {
            jToggleButton.setIcon(checkBoxImages[n5 - 2]);
        }
    }

    public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = null;
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        ButtonModel buttonModel = jToggleButton.getModel();
        Icon icon = jToggleButton.getIcon();
        if (icon != null) {
            return;
        }
        string = !jToggleButton.isEnabled() ? (jToggleButton.isSelected() ? (String)UIManager.get("radioButtonIconOnDisabled") : (String)UIManager.get("radioButtonIconDisabled")) : (buttonModel.isRollover() ? (jToggleButton.isSelected() ? (String)UIManager.get("radioButtonIconOnOver") : (String)UIManager.get("radioButtonIconOver")) : (jToggleButton.isSelected() ? (String)UIManager.get("radioButtonIconOn") : (String)UIManager.get("radioButtonIconOff")));
        int n5 = n;
        int n6 = n2;
        int n7 = jToggleButton.getHorizontalTextPosition();
        int n8 = jToggleButton.getVerticalTextPosition();
        if (n7 == 2) {
            n5 += n3 - 18;
        } else if (n7 == 0) {
            n5 += (n3 - 18) / 2;
        }
        if (n8 == 1) {
            n6 += n4 - 18;
        } else if (n8 == 0) {
            n6 += (n4 - 18) / 2;
        }
        String string2 = string + "_" + n5 + "_" + n6;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n5, n6, 18, 18, string, new Insets(4, 4, 4, 4), new Insets(4, 4, 4, 4), true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JButton jButton = (JButton)synthContext.getComponent();
        if (jButton.getName() != null && jButton.getName().startsWith("SplitPaneDivider.")) {
            return;
        }
        Insets insets = new Insets(3, 3, 3, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        int n5 = synthContext.getComponentState();
        String string = "ArrowButton";
        string = (n5 & 4) > 0 ? string + ".background.pressed" : ((n5 & 8) > 0 ? string + ".background.disabled" : string + ".background");
        String string2 = (string = (String)UIManager.get(string)) + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = "Arrow";
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        int n6 = 16;
        if (n3 < n6 || n4 < n6) {
            n6 = 8;
            insets = new Insets(4, 4, 4, 4);
        }
        n += (n3 - n6) / 2;
        n2 += (n4 - n6 + 1) / 2;
        n3 = n6;
        n4 = n6;
        if (n5 == 1) {
            string = string + ".up";
        } else if (n5 == 5) {
            string = string + ".down";
        } else if (n5 == 7) {
            string = string + ".left";
        } else if (n5 == 3) {
            string = string + ".right";
        }
        string = (String)UIManager.get(string);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, false, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    static {
        buttonCache = new HashSet();
        painters = new HashMap();
    }
}

