/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.laf.synth;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import net.xoetrope.optional.laf.synth.ImagePainter;
import net.xoetrope.swing.painter.XLogoBackground;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XuiUtilities;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleManager;

public class BackgroundPainter
extends SynthPainter {
    private static XLogoBackground painter = new XLogoBackground();
    private XProject currentProject = XProjectManager.getCurrentProject();
    private static HashMap painters = new HashMap();

    public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        String string = (String)UIManager.get("Desktop.desktopStyle");
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        XStyle xStyle = xStyleManager.getStyle(string);
        Color color = xStyle.getStyleAsColor(5);
        Color color2 = xStyle.getStyleAsColor(4);
        painter.paint((Graphics2D)graphics, jComponent, n3, n4);
    }

    public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintPanelBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JPanel jPanel = (JPanel)synthContext.getComponent();
        Border border = jPanel.getBorder();
        if (border instanceof TitledBorder) {
            this.paintTitledBorder((TitledBorder)border, synthContext, graphics, n, n2, n3, n4);
        } else if (border instanceof CompoundBorder) {
            this.paintCompoundBorder((CompoundBorder)border, synthContext, graphics, n, n2, n3, n4);
        }
    }

    private void paintCompoundBorder(CompoundBorder compoundBorder, SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Border border = compoundBorder.getOutsideBorder();
        if (border instanceof CompoundBorder) {
            this.paintCompoundBorder((CompoundBorder)border, synthContext, graphics, n, n2, n3, n4);
        } else if (border instanceof TitledBorder) {
            this.paintTitledBorder((TitledBorder)border, synthContext, graphics, n, n2, n3, n4);
        }
        Border border2 = compoundBorder.getInsideBorder();
        if (border2 == null) {
            return;
        }
        Insets insets = border.getBorderInsets(synthContext.getComponent());
        n2 += insets.top;
        n += insets.left;
        n4 -= insets.top + insets.bottom;
        n3 -= insets.left + insets.right;
        if (border2 instanceof CompoundBorder) {
            this.paintCompoundBorder((CompoundBorder)border2, synthContext, graphics, n, n2, n3, n4);
        } else if (border2 instanceof TitledBorder) {
            this.paintTitledBorder((TitledBorder)border2, synthContext, graphics, n, n2, n3, n4);
        }
    }

    private void paintTitledBorder(TitledBorder titledBorder, SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 2;
        n += n5;
        n2 += 2;
        n3 -= n5 * 2;
        n4 -= 4;
        JPanel jPanel = (JPanel)synthContext.getComponent();
        FontMetrics fontMetrics = jPanel.getFontMetrics(jPanel.getFont());
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.stringWidth(titledBorder.getTitle());
        int n8 = 0;
        if (titledBorder.getTitlePosition() == 2) {
            n8 = (fontMetrics.getAscent() - 1) / 2;
            n2 += n8;
        } else if (titledBorder.getTitlePosition() == 1) {
            n8 = n6 + 2;
            n2 += n8;
        } else if (titledBorder.getTitlePosition() == 3) {
            n8 = 2;
            n2 += n8;
        } else if (titledBorder.getTitlePosition() == 5) {
            n8 = (n6 - 1) / 2;
        } else if (titledBorder.getTitlePosition() == 4) {
            n8 = 2;
        } else if (titledBorder.getTitlePosition() == 6) {
            n8 = n6;
        }
        String string = (String)UIManager.get("Panel.border");
        Insets insets = new Insets(3, 3, 3, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        String string2 = string + "_" + n3 + "_" + (n4 -= n8);
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, true);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
        if (titledBorder.getTitlePosition() == 2) {
            n2 -= n8;
        } else if (titledBorder.getTitlePosition() == 5) {
            n2 = n2 + n4 - n8;
        } else {
            return;
        }
        n2 += 4;
        n6 = 1;
        Insets insets3 = titledBorder.getBorderInsets(jPanel);
        graphics.setColor(jPanel.getBackground());
        if (titledBorder.getTitleJustification() == 2) {
            graphics.fillRect(n + (n3 - n7) / 2 - 1, n2, n7 + 2, n6);
        } else if (titledBorder.getTitleJustification() == 3) {
            graphics.fillRect(n + n3 - insets3.right * 2 - n7 + n5, n2, n7 + 2, n6);
        } else {
            graphics.fillRect(n + insets3.left * 2 - 1 - 1 - n5, n2, n7 + 2, n6);
        }
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = (String)UIManager.get("InternalFrameBorderBackgroundSelected.background");
        JInternalFrame jInternalFrame = (JInternalFrame)synthContext.getComponent();
        if (jInternalFrame.isSelected()) {
            string = (String)UIManager.get("InternalFrameBorderBackgroundSelected.background");
        }
        Insets insets = new Insets(1, 1, 1, 1);
        Insets insets2 = new Insets(1, 1, 1, 1);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, false);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = (String)UIManager.get("InternalFrameBorderBackground.background");
        JInternalFrame jInternalFrame = (JInternalFrame)synthContext.getComponent();
        jInternalFrame.setOpaque(false);
        if (jInternalFrame.isSelected()) {
            string = (String)UIManager.get("InternalFrameBorderBackgroundSelected.background");
        }
        Insets insets = new Insets(3, 3, 3, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        String string2 = string + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string2);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, string, insets, insets2, true, false);
            painters.put(string2, imagePainter);
        }
        imagePainter.paint(graphics);
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        BasicInternalFrameTitlePane basicInternalFrameTitlePane = (BasicInternalFrameTitlePane)synthContext.getComponent();
        int n5 = basicInternalFrameTitlePane.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            object2 = (JComponent)basicInternalFrameTitlePane.getComponent(i);
            ((JComponent)object2).setBorder(null);
        }
        basicInternalFrameTitlePane.getLayout().minimumLayoutSize(basicInternalFrameTitlePane);
        Container container = basicInternalFrameTitlePane.getParent();
        object2 = "";
        if (container instanceof JInternalFrame) {
            object2 = ((JInternalFrame)container).getTitle();
        } else {
            object = (JInternalFrame.JDesktopIcon)container;
            object2 = ((JInternalFrame.JDesktopIcon)object).getInternalFrame().getTitle();
        }
        object = (String)UIManager.get("InternalFrameTitlePane.background");
        if ((synthContext.getComponentState() & 0x200) > 0) {
            object = (String)UIManager.get("InternalFrameTitlePaneSelected.background");
        }
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 1, 0, 0);
        String string = (String)object + "_" + n3 + "_" + n4;
        ImagePainter imagePainter = (ImagePainter)painters.get(string);
        if (imagePainter == null) {
            imagePainter = new ImagePainter(synthContext, graphics, n, n2, n3, n4, (String)object, insets, insets2, true, true);
            painters.put(string, imagePainter);
        }
        imagePainter.paint(graphics);
        if (XuiUtilities.getMinorVersion() < 6) {
            Color color = UIManager.getColor("InternalFrameTitlePaneText.forground");
            graphics.setColor(color);
            graphics.drawString((String)object2, 25, 14);
        }
    }
}

