/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import net.xoetrope.optional.http.XHttpResponse;
import net.xoetrope.optional.http.XHttpResponseHandler;

public class XHttpSession
implements Runnable {
    private XHttpResponseHandler responseHandler;
    private Socket sessionSocket;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);

    public XHttpSession(Socket socket, XHttpResponseHandler xHttpResponseHandler) {
        this.sessionSocket = socket;
        this.responseHandler = xHttpResponseHandler;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            Object object;
            Object object2;
            String string;
            InputStream inputStream = this.sessionSocket.getInputStream();
            if (inputStream == null) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError("400 Bad Request", "400 Bad Request");
            }
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError("400 Bad Request", "BAD REQUEST: Invalid URI");
            }
            String string3 = string = URLDecoder.decode(stringTokenizer.nextToken(), "UTF-8");
            Properties properties = new Properties();
            int n = string3.indexOf(63);
            if (n > 0) {
                object2 = new StringTokenizer(string3.substring(n + 1), "&");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    n = ((String)object).indexOf(61);
                    if (n < 0) continue;
                    properties.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
                }
            }
            object2 = new Properties();
            if (stringTokenizer.hasMoreTokens()) {
                object = bufferedReader.readLine().trim();
                while (((String)object).length() > 0) {
                    n = ((String)object).indexOf(58);
                    ((Properties)object2).put(((String)object).substring(0, n), ((String)object).substring(n + 1));
                    object = bufferedReader.readLine().trim();
                }
            }
            if ((object = this.responseHandler.getResponse(string, string2, (Properties)object2, properties)) == null) {
                this.sendError("500 Internal Server Error", "INTERNAL ERROR: no response.");
            } else {
                this.sendResponse(((XHttpResponse)object).status, ((XHttpResponse)object).mimeType, ((XHttpResponse)object).headers, ((XHttpResponse)object).data);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            try {
                this.sendError("500 Internal Server Error", "INTERNAL ERROR: IOException: " + iOException.getMessage());
            }
            catch (Throwable throwable) {}
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void sendError(String string, String string2) throws InterruptedException {
        this.sendResponse(string, "text/plain", null, new ByteArrayInputStream(string2.getBytes()));
        throw new InterruptedException();
    }

    protected void sendResponse(String string, String string2, Properties properties, InputStream inputStream) {
        try {
            OutputStream outputStream = this.sessionSocket.getOutputStream();
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.print("HTTP/1.0 " + string + " \r\n");
            printWriter.print("Date: " + dateFormatter.format(new Date()) + "\r\n");
            printWriter.print("\r\n");
            printWriter.flush();
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                this.sessionSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

