/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import net.xoetrope.optional.data.XOptionalDataSource;
import net.xoetrope.optional.data.sql.ConnectionManager;
import net.xoetrope.optional.data.sql.ConnectionObject;
import net.xoetrope.optional.data.sql.ConnectionParameters;
import net.xoetrope.optional.data.sql.NamedConnectionObject;
import net.xoetrope.optional.pool.PoolObject;
import net.xoetrope.xui.XProjectManager;

public class NamedConnectionManager
extends ConnectionManager {
    protected Vector connectionParameters = new Vector();

    protected NamedConnectionManager(String string, String string2, String string3, String string4, String string5, int n) {
        super(string2, string3, string4, string5, n);
        this.addConnection(string == null ? "default" : string, string2, string3, string4, string5);
    }

    public PoolObject getObject(String string) throws Exception {
        NamedConnectionObject namedConnectionObject;
        String string2 = "default";
        if (string != null) {
            string2 = string;
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            namedConnectionObject = (NamedConnectionObject)this.objects.elementAt(i);
            if (namedConnectionObject.getInUse() || !namedConnectionObject.getName().equals(string2)) continue;
            namedConnectionObject.lease();
            return namedConnectionObject;
        }
        namedConnectionObject = (NamedConnectionObject)this.getNewObject(string2);
        namedConnectionObject.lease();
        this.objects.addElement(namedConnectionObject);
        return namedConnectionObject;
    }

    public PoolObject getNewObject(String string) throws SQLException {
        ConnectionParameters connectionParameters = (ConnectionParameters)this.findConnectionParams(string);
        Connection connection = null;
        try {
            Object object;
            Class<?> clazz = connectionParameters.driverClass;
            if (clazz == null) {
                object = XProjectManager.getCurrentProject().getProjectClassLoader();
                if (object == null) {
                    object = this.getClass().getClassLoader();
                }
                clazz = Class.forName(connectionParameters.driverName.trim(), true, (ClassLoader)object);
            }
            object = (Driver)clazz.newInstance();
            Properties properties = new Properties();
            properties.put("user", connectionParameters.user);
            properties.put("password", connectionParameters.password);
            connection = object.connect(connectionParameters.url, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection != null ? new NamedConnectionObject(connectionParameters.name, connection, this) : null;
    }

    public static ConnectionManager getInstance() {
        if (connMgr != null) {
            return connMgr;
        }
        connMgr = new NamedConnectionManager(null, defaultDriverName, defaultDatabaseUrl, "sa", "", 10);
        return connMgr;
    }

    public ConnectionObject getConnection(String string) throws SQLException {
        try {
            ConnectionObject connectionObject = (ConnectionObject)ConnectionManager.getInstance().getObject(string);
            if (connectionObject.isClosed()) {
                this.reset(string, defaultDriverName, this.url, this.user, this.password);
                connectionObject = (ConnectionObject)ConnectionManager.getInstance().getObject(string);
            }
            return connectionObject;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void addConnection(String string, String string2, String string3, String string4, String string5, Class clazz) {
        ConnectionParameters connectionParameters = (ConnectionParameters)this.findConnectionParams(string);
        if (connectionParameters != null) {
            return;
        }
        connectionParameters = new ConnectionParameters();
        connectionParameters.name = string;
        connectionParameters.driverName = string2;
        connectionParameters.url = string3;
        connectionParameters.user = string4;
        connectionParameters.password = string5;
        connectionParameters.driverClass = clazz;
        this.connectionParameters.addElement(connectionParameters);
    }

    public void addConnection(String string, String string2, String string3, String string4, String string5) {
        this.addConnection(string, string2, string3, string4, string5, null);
    }

    public Object findConnectionParams(String string) {
        int n = this.connectionParameters.size();
        for (int i = 0; i < n; ++i) {
            if (((ConnectionParameters)this.connectionParameters.elementAt((int)i)).name.compareTo(string) != 0) continue;
            return this.connectionParameters.elementAt(i);
        }
        return null;
    }

    public ConnectionManager reset(String string, String string2, String string3, String string4, String string5) {
        if (connMgr != null) {
            connMgr.closeObjects();
        }
        defaultDriverName = string2;
        string3 = XOptionalDataSource.checkLocalHsqldb(this.getClass().getClassLoader(), string2, string3);
        connMgr = new NamedConnectionManager(string, string2, string3, string4, string5, 10);
        return connMgr;
    }

    public String[] getConnectionParams(String string) {
        ConnectionParameters connectionParameters = (ConnectionParameters)this.findConnectionParams(string);
        if (connectionParameters != null) {
            String[] stringArray = new String[]{connectionParameters.name, connectionParameters.url, connectionParameters.user, connectionParameters.password, connectionParameters.driverName, connectionParameters.databaseUrl};
            return stringArray;
        }
        return null;
    }
}

