/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.io.Writer;
import java.sql.ResultSetMetaData;
import net.xoetrope.debug.DumpWriter;
import net.xoetrope.optional.data.sql.CachedDatabaseTable;
import net.xoetrope.optional.data.sql.DatabaseRowModel;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.XRowSelector;
import net.xoetrope.xui.data.table.XTableModel;

public class DatabaseTableModel
extends XTableModel
implements DumpWriter,
XRowSelector {
    CachedDatabaseTable xtable;
    boolean dirty;
    boolean readOnly;
    private boolean doesEscapeProcessing;
    private static boolean allowNull = false;
    protected String modelId;
    protected XProject currentProject;

    public DatabaseTableModel(XProject xProject) {
        this.currentProject = xProject;
        this.dirty = true;
        this.readOnly = true;
    }

    public static void setAllowNull(boolean bl) {
        allowNull = bl;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setName(String string) {
        this.modelId = string;
    }

    public int hashCode() {
        return this.modelId.hashCode();
    }

    public void setupTable(String string) {
        this.setupTable(string, null, null);
    }

    public void setupTable(String string, String string2, String string3) {
        this.setupTable(string, string2, string3, null, false);
    }

    public void setupTable(String string, String string2, String string3, String string4, boolean bl) {
        this.xtable = new CachedDatabaseTable(this.currentProject, string, string2, string3, string4, bl);
        this.xtable.setDoesEscapeProcessing(this.doesEscapeProcessing);
        if (this.modelId == null) {
            this.modelId = string;
        }
        this.dirty = true;
    }

    public void setSqlStatement(String string, String string2, boolean bl) {
        String string3 = null;
        if (this.xtable != null) {
            string3 = this.xtable.getOriginalSql();
        }
        this.xtable = new CachedDatabaseTable(this.currentProject, string3 == null ? string : string3, string2, bl);
        this.xtable.setDoesEscapeProcessing(this.doesEscapeProcessing);
        this.xtable.setSql(string);
        this.dirty = true;
    }

    public String getOriginalSql() {
        return this.xtable.getOriginalSql();
    }

    public int executeUpdate(String string) throws Exception {
        this.dirty = true;
        return this.xtable.executeUpdate(string);
    }

    public void setDistinct(boolean bl) {
        this.xtable.setDistinct(bl);
    }

    public boolean isDistinct() {
        return this.xtable.isDistinct();
    }

    public void setOrderField(String string) {
        this.xtable.setOrderField(string);
    }

    public void setupTable(String string, String string2, String string3, boolean bl) {
        this.xtable = new CachedDatabaseTable(this.currentProject, string, string2, string3, null, bl);
        this.xtable.setDoesEscapeProcessing(this.doesEscapeProcessing);
        if (this.modelId == null) {
            this.modelId = string;
        }
        this.dirty = true;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public synchronized void sync() {
        if (this.dirty) {
            this.xtable.retrieve();
            this.dirty = false;
        }
    }

    public Object get(String string) {
        this.sync();
        DatabaseRowModel databaseRowModel = new DatabaseRowModel(this, this.xtable.getCurrentRow());
        return databaseRowModel.get(string);
    }

    public void set(String string, String string2, Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public void set(String string, Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public XModel get(int n) {
        this.sync();
        DatabaseRowModel databaseRowModel = new DatabaseRowModel(this, n);
        databaseRowModel.setParent((XModel)this);
        return databaseRowModel;
    }

    public Object get() {
        this.sync();
        return this;
    }

    public Object append(String string) {
        return null;
    }

    public void set(Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public Object getAttribValue(int n) {
        this.sync();
        return this.xtable.getValue(n);
    }

    public String getAttribValueAsString(int n) {
        this.sync();
        return this.xtable.getValue(n);
    }

    public double getAttribValueAsDouble(int n) {
        this.sync();
        try {
            String string = this.xtable.getValue(n);
            if (string == null) {
                if (allowNull) {
                    return Double.NaN;
                }
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0.0;
        }
    }

    public int getAttribValueAsInt(int n) {
        this.sync();
        try {
            String string = this.xtable.getValue(n);
            if (string == null && allowNull) {
                return Integer.MIN_VALUE;
            }
            return Integer.parseInt(string);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getAttribute(String string) {
        this.sync();
        return this.xtable.getFieldIndex(string);
    }

    public void retrieve() {
        this.sync();
    }

    public void first() {
        this.xtable.first();
    }

    public void last() {
        this.xtable.last();
    }

    public boolean next() {
        return this.xtable.next();
    }

    public boolean hasMoreRows() {
        return this.xtable.hasMoreRows();
    }

    public boolean previous() {
        return this.xtable.previous();
    }

    public String getValue() {
        return this.getFieldValue(0, 0);
    }

    public XModel getValue(int n) {
        return this.get(n);
    }

    public String getFieldValue(int n) {
        return this.xtable.getValue(n);
    }

    public String getFieldValue(int n, int n2) {
        return this.xtable.getValue(n, n2);
    }

    public void setFieldValue(int n, String string) {
        this.xtable.setValue(n, string);
        this.fireModelUpdated();
    }

    public void setFieldValue(int n, int n2, String string) {
        this.xtable.setValue(n, n2, string);
        this.fireModelUpdated();
    }

    public double getValueAsDouble(String string) {
        return Double.parseDouble(this.getFieldValue(this.xtable.getFieldIndex(string)));
    }

    public int getValueAsInt(String string) {
        return Integer.parseInt(this.getFieldValue(this.xtable.getFieldIndex(string)));
    }

    public String getAttribName(int n) {
        return this.xtable.getFieldName(n);
    }

    public String getId() {
        return this.modelId;
    }

    public void setAttribValue(int n, Object object) {
        this.setFieldValue(n, object.toString());
    }

    public int getNumChildren() {
        this.sync();
        return this.xtable.getNumRows();
    }

    public int getNumAttributes() {
        return this.xtable.getNumFields();
    }

    public String getTagName() {
        return "";
    }

    public DatabaseTableModel findRows(int n, String string) {
        DatabaseTableModel databaseTableModel = new DatabaseTableModel(this.currentProject);
        databaseTableModel.setupTable(this.xtable.getTableName(), null, this.xtable.getFieldName(n) + "='" + string + "'");
        databaseTableModel.sync();
        return databaseTableModel;
    }

    public DatabaseTableModel findRows(String string) {
        return this.findRows(this.xtable.getFields(), string);
    }

    public void setParams(String[] stringArray) {
        this.xtable.setParams(stringArray);
    }

    public DatabaseTableModel findRows(String string, String string2) {
        DatabaseTableModel databaseTableModel = new DatabaseTableModel(this.currentProject);
        if (this.xtable.getTableName() != null) {
            String string3 = this.xtable.getWhereClause();
            databaseTableModel.setupTable(this.xtable.getTableName(), string, string2 + (string3 != null ? " AND " + string3 : ""), this.xtable.getConnName(), false);
            databaseTableModel.setDistinct(this.xtable.isDistinct());
            databaseTableModel.setOrderField(this.xtable.orderField);
        } else {
            String string4 = this.xtable.getSQL("");
            String string5 = string4.toUpperCase();
            int n = string5.indexOf("GROUP BY");
            if (n < 0) {
                n = string5.indexOf("HAVING ");
            }
            if (n < 0) {
                n = string5.indexOf("ORDER BY");
            }
            string5 = n > 0 ? string4.substring(0, n) + string2 + " " + string4.substring(n) : string4 + " " + string2;
            databaseTableModel.setSqlStatement(string5, this.xtable.getConnName(), false);
        }
        databaseTableModel.sync();
        return databaseTableModel;
    }

    public DatabaseRowModel findRow(int n, String string) {
        if (this.dirty) {
            return null;
        }
        return (DatabaseRowModel)this.findRows(n, string).get(0);
    }

    public DatabaseRowModel findRow(String string) {
        if (this.dirty) {
            return null;
        }
        return (DatabaseRowModel)this.findRows(string).get(0);
    }

    public static DatabaseTableModel getTable(XProject xProject, String string) {
        return (DatabaseTableModel)((XModel)xProject.getModel().get(string));
    }

    public void dump(Writer writer) {
    }

    public void setSelectedRow(int n) {
        this.xtable.setCurrentRow(n);
    }

    public int getSelectedRow() {
        return this.xtable.getCurrentRow();
    }

    public ResultSetMetaData getMetaData() {
        return this.xtable.getMetaData();
    }

    public CachedDatabaseTable getTable() {
        return this.xtable;
    }

    public boolean getDoesEscapeProcessing() {
        return this.doesEscapeProcessing;
    }

    public void setDoesEscapeProcessing(boolean bl) {
        this.doesEscapeProcessing = bl;
    }
}

