/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import net.xoetrope.optional.data.sql.DataConnection;
import net.xoetrope.xui.XProject;

public class DatabaseTable {
    public static final int PARANOID_UPDATE = 0;
    public static final int NORMAL_UPDATE = 1;
    public static final int OPTIMISTIC_UPDATE = 2;
    protected DataConnection connection;
    private ResultSetMetaData metaData;
    protected int numFields;
    protected int numRows = 0;
    protected int currentRow = 0;
    protected boolean dirty = false;
    protected String queryFields;
    protected String queryTable;
    protected ResultSet RS;
    protected boolean distinct = false;
    protected String orderField;
    protected String sqlStatement;
    protected String defaultWhereClause;
    protected String connName;
    protected boolean writable;
    protected static boolean caseSensitive = true;
    protected String[] params;
    protected String[] fieldNames;
    protected int[] fieldTypes;
    protected XProject currentProject;

    public DatabaseTable(XProject xProject, String string) {
        this(xProject, string, null, null, null, false);
    }

    public DatabaseTable(XProject xProject, String string, String string2, boolean bl) {
        this.currentProject = xProject;
        this.sqlStatement = string;
        this.writable = bl;
        this.connName = string2;
        this.connection = new DataConnection(this.currentProject, this.connName);
    }

    public void setSql(String string) {
        this.sqlStatement = string;
    }

    public DatabaseTable(XProject xProject, String string, String string2, String string3, String string4, boolean bl) {
        this.queryFields = string2;
        this.queryTable = string;
        this.defaultWhereClause = string3;
        this.connName = string4;
        this.writable = bl;
        this.connection = new DataConnection(xProject, this.connName);
    }

    public void setParams(String[] stringArray) {
        this.params = stringArray;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setOrderField(String string) {
        this.orderField = "".equals(string) ? null : string;
    }

    public String getValue(int n) {
        try {
            return this.RS.getString(n + 1);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String getValue(int n, int n2) {
        try {
            this.RS.absolute(n + 1);
            return this.RS.getString(n2 + 1);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void setValue(int n, int n2, String string) {
        try {
            if (!this.writable || !this.metaData.isWritable(n2 + 1)) {
                return;
            }
            this.RS.absolute(n + 1);
            try {
                this.RS.refreshRow();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            switch (this.fieldTypes[n2]) {
                case 4: {
                    this.RS.updateInt(n2 + 1, (int)new Integer(string));
                    break;
                }
                case 6: {
                    this.RS.updateFloat(n2 + 1, new Float(string).floatValue());
                    break;
                }
                case 8: {
                    this.RS.updateDouble(n2 + 1, (double)new Double(string));
                    break;
                }
                default: {
                    this.RS.updateString(n2 + 1, string);
                }
            }
            this.RS.updateRow();
        }
        catch (SQLException sQLException) {
            this.setValueWithPseudoColumn(n, n2, string);
        }
        this.dirty = true;
    }

    private void setValueWithPseudoColumn(int n, int n2, String string) {
        try {
            if (!this.writable || !this.metaData.isWritable(n2 + 1)) {
                return;
            }
            int n3 = this.numFields - 1;
            this.RS.absolute(n + 1);
            String string2 = "UPDATE " + this.queryTable + " SET " + this.fieldNames[n2] + "=";
            switch (this.fieldTypes[n2]) {
                case 4: 
                case 6: 
                case 8: {
                    string2 = string2 + string;
                    break;
                }
                default: {
                    string2 = string2 + "'" + string + "'";
                }
            }
            string2 = string2 + ", " + this.fieldNames[this.numFields - 2] + "='" + new Timestamp(new Date().getTime()).toString() + "'";
            string2 = string2 + " WHERE " + this.fieldNames[this.numFields - 1] + "=" + this.RS.getString(n3);
            this.connection.executeUpdate(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getFieldIndex(String string) {
        for (int i = 0; i < this.numFields; ++i) {
            if (!caseSensitive && string.equalsIgnoreCase(this.fieldNames[i])) {
                return i;
            }
            if (!string.equals(this.fieldNames[i])) continue;
            return i;
        }
        return -1;
    }

    public String getFieldName(int n) {
        return this.fieldNames[n];
    }

    public synchronized void retrieve() {
        if (this.params != null) {
            this.retrieve(this.params);
        } else {
            this.retrieve(this.defaultWhereClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void retrieve(String string) {
        String string2 = null;
        try {
            string2 = this.getSQL(string);
            this.RS = this.connection.executeQuery(string2, this.connName, this.writable);
            this.metaData = this.RS.getMetaData();
            this.numFields = this.metaData.getColumnCount();
            this.fieldNames = new String[this.numFields];
            this.fieldTypes = new int[this.numFields];
            for (int i = 0; i < this.numFields; ++i) {
                this.fieldNames[i] = this.metaData.getColumnName(i + 1);
                this.fieldTypes[i] = this.metaData.getColumnType(i + 1);
            }
            this.RS.last();
            this.numRows = this.RS.getRow();
            this.cacheData();
            this.connection.closeQuery();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.numRows = 0;
            try {
                this.cacheData();
                this.connection.closeQuery();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        finally {
            this.connection.closeQuery();
        }
    }

    public synchronized void retrieve(String[] stringArray) {
        this.retrieve(stringArray, false);
    }

    public synchronized void retrieve(String[] stringArray, boolean bl) {
        try {
            int n;
            String string = this.getSQL(null);
            PreparedStatement preparedStatement = this.connection.createPreparedStatement(string, this.connName, bl);
            for (n = 0; n < stringArray.length; ++n) {
                preparedStatement.setString(n + 1, stringArray[n]);
            }
            this.RS = preparedStatement.executeQuery();
            this.metaData = this.RS.getMetaData();
            this.numFields = this.metaData.getColumnCount();
            this.fieldNames = new String[this.numFields];
            this.fieldTypes = new int[this.numFields];
            for (n = 0; n < this.numFields; ++n) {
                this.fieldNames[n] = this.metaData.getColumnName(n + 1);
                this.fieldTypes[n] = this.metaData.getColumnType(n + 1);
            }
            this.RS.last();
            this.numRows = this.RS.getRow();
            this.cacheData();
            preparedStatement.close();
            this.connection.closePreparedStatement(preparedStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        return this.getPreparedStatement(string, this.connName, false);
    }

    public PreparedStatement getPreparedStatement(String string, String string2, boolean bl) throws SQLException {
        String string3 = string;
        if (string3 == null) {
            string3 = this.getSQL(null);
        }
        return this.connection.createPreparedStatement(string3, string2, bl);
    }

    public void releasePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement != null) {
            preparedStatement.close();
            this.connection.closePreparedStatement(preparedStatement);
            preparedStatement = null;
            this.dirty = true;
        }
    }

    public int executeUpdate(String string) throws Exception {
        return this.connection.executeUpdate(string);
    }

    protected void cacheData() throws SQLException {
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setCurrentRow(int n) {
        this.currentRow = n;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public void first() {
        this.currentRow = 0;
    }

    public void last() {
        this.currentRow = this.numRows - 1;
    }

    public boolean next() {
        this.dirty = false;
        if (this.currentRow + 1 == this.numRows) {
            return false;
        }
        ++this.currentRow;
        return true;
    }

    public boolean previous() {
        this.dirty = false;
        if (this.currentRow == 0) {
            return false;
        }
        --this.currentRow;
        return true;
    }

    public boolean hasMoreRows() {
        return this.currentRow + 1 < this.numRows;
    }

    protected void finalize() throws Throwable {
        try {
            this.RS.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getNumFields() {
        return this.numFields;
    }

    public String getTableName() {
        return this.queryTable;
    }

    public void getTableName(String string) {
        this.queryTable = string;
    }

    public String getConnName() {
        return this.connName;
    }

    public String getWhereClause() {
        return this.defaultWhereClause;
    }

    public String getFields() {
        return this.queryFields;
    }

    public static void setCaseSensitive(boolean bl) {
        caseSensitive = bl;
    }

    public String getSQL(String string) {
        if (this.sqlStatement != null) {
            return this.sqlStatement;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        if (this.distinct) {
            stringBuffer.append("DISTINCT ");
        }
        if (this.queryFields != null) {
            stringBuffer.append(this.queryFields);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.queryTable);
        if (string != null && string.length() > 0) {
            stringBuffer.append(" WHERE " + string);
        }
        if (this.orderField != null) {
            stringBuffer.append(" ORDER BY " + this.orderField);
        }
        return stringBuffer.toString();
    }

    ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public long getNextId(String string) {
        long l = this.connection.getNextId(string);
        if (l < 0L) {
            return this.getNextPseudoId(string);
        }
        return l;
    }

    public long getNextPseudoId(String string) {
        return this.connection.getNextPseudoId(string);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    public boolean getDoesEscapeProcessing() {
        return this.connection.getDoesEscapeProcessing();
    }

    public void setDoesEscapeProcessing(boolean bl) {
        this.connection.setDoesEscapeProcessing(bl);
    }
}

