/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.lang.reflect.Constructor;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.data.sql.ConnectionObject;
import net.xoetrope.optional.data.sql.NamedConnectionManager;
import net.xoetrope.optional.data.sql.XReplicationEngine;
import net.xoetrope.xui.XProject;

public class DataConnection {
    private ConnectionObject connObj = null;
    private String connName;
    private static boolean replicationEnabled = true;
    private boolean doesEscapeProcessing = true;
    private XReplicationEngine replicationEngine;

    public DataConnection(XProject xProject, String string) {
        this.connName = string;
        this.createReplicationEngine(xProject);
    }

    public DataConnection(XProject xProject, String string, boolean bl) {
        this.connName = string;
        replicationEnabled = bl;
        if (replicationEnabled) {
            this.createReplicationEngine(xProject);
        }
    }

    private void createReplicationEngine(XProject xProject) {
        String string = xProject.getStartupParam("XReplicationEngineClass");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(XProject.class, this.getClass());
                this.replicationEngine = (XReplicationEngine)constructor.newInstance(xProject, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                replicationEnabled = false;
                this.replicationEngine = null;
            }
        }
    }

    public XReplicationEngine getReplicationEngine() {
        return this.replicationEngine;
    }

    public void setReplicationEngine(XReplicationEngine xReplicationEngine) {
        this.replicationEngine = xReplicationEngine;
    }

    public ConnectionObject getConnectionObject() {
        return this.connObj;
    }

    public synchronized int executeUpdate(String string) throws Exception {
        try {
            this.connObj = NamedConnectionManager.getInstance().getConnection(this.connName);
            Statement statement = this.connObj.createStatement();
            statement.setEscapeProcessing(this.doesEscapeProcessing);
            int n = statement.executeUpdate(string);
            return n;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.connObj.closeStatement();
            this.connObj.expireLease();
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, this.connName, false);
    }

    public static String getTableName(String string) {
        int n = string.indexOf("FROM ") + 5;
        int n2 = string.indexOf(32, n);
        String string2 = n2 < 0 ? string.substring(n) : string.substring(n, n2);
        return string2.toUpperCase();
    }

    public synchronized ResultSet executeQuery(String string, String string2, boolean bl) throws SQLException {
        try {
            Object object;
            this.connObj = NamedConnectionManager.getInstance().getConnection(string2);
            ResultSet resultSet = null;
            if (this.replicationEngine != null && replicationEnabled) {
                object = DataConnection.getTableName(string);
                resultSet = this.replicationEngine.synchronizeTable((String)object, 1);
            }
            if (resultSet != null) {
                return resultSet;
            }
            object = null;
            if (bl) {
                try {
                    object = this.connObj.createStatement(1004, 1008);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (object == null) {
                object = this.connObj.createStatement(1004, 1007);
            }
            object.setEscapeProcessing(this.doesEscapeProcessing);
            object.setFetchDirection(1000);
            return object.executeQuery(string);
        }
        catch (SQLException sQLException) {
            DebugLogger.logError((String)sQLException.getMessage());
            throw sQLException;
        }
    }

    public void closeQuery() {
        this.connObj.closeStatement();
    }

    public synchronized PreparedStatement createPreparedStatement(String string, String string2, boolean bl) throws SQLException {
        try {
            NamedConnectionManager namedConnectionManager = (NamedConnectionManager)NamedConnectionManager.getInstance();
            this.connObj = namedConnectionManager.getConnection(string2);
            PreparedStatement preparedStatement = bl ? this.connObj.prepareStatement(string) : this.connObj.prepareStatement(string, 1004, 1008);
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            if (this.connObj != null) {
                this.connObj.expireLease();
            }
            System.err.println(sQLException.getMessage());
            throw sQLException;
        }
    }

    public synchronized PreparedStatement createPreparedStatement(String string, String string2) throws SQLException {
        return this.createPreparedStatement(string, string2, true);
    }

    public void closePreparedStatement(PreparedStatement preparedStatement) {
        this.connObj.closePreparedStatement();
    }

    public void closeStatement(Statement statement) {
        this.connObj.closeStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getMetaData(String string) {
        try {
            this.connObj = NamedConnectionManager.getInstance().getConnection(this.connName);
            DatabaseMetaData databaseMetaData = this.connObj.connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, string.toUpperCase(), null);
            return resultSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.connObj.expireLease();
        }
        return null;
    }

    public synchronized ConnectionObject borrowConnection() throws SQLException {
        this.connObj = NamedConnectionManager.getInstance().getConnection(this.connName);
        return this.connObj;
    }

    public void returnConnection() {
        this.connObj.expireLease();
    }

    public ResultSet doQuery(String string) {
        try {
            Statement statement = this.connObj.createStatement(1004, 1008);
            statement.setEscapeProcessing(this.doesEscapeProcessing);
            return statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(String string) {
        try {
            int n;
            Statement statement = this.connObj.createStatement();
            statement.setEscapeProcessing(this.doesEscapeProcessing);
            int n2 = n = statement.executeUpdate(string);
            return n2;
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.connObj.closeStatement();
        }
        return Integer.MIN_VALUE;
    }

    public static void shutdown(String string) throws Exception {
        ConnectionObject connectionObject = NamedConnectionManager.getInstance().getConnection(string);
        Statement statement = connectionObject.createStatement();
        statement.executeQuery("SHUTDOWN");
        connectionObject.closeStatement();
        connectionObject.expireLease();
    }

    public static void setReplicationEnabled(boolean bl) {
        replicationEnabled = bl;
    }

    public void commit() throws SQLException {
        this.connObj.getConnection().commit();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.connObj.getConnection().setAutoCommit(bl);
    }

    public boolean getDoesEscapeProcessing() {
        return this.doesEscapeProcessing;
    }

    public void setDoesEscapeProcessing(boolean bl) {
        this.doesEscapeProcessing = bl;
    }

    public long getNextPseudoId(String string) {
        return this.replicationEngine != null ? this.replicationEngine.getNextPseudoId(string) : -1L;
    }

    public long getNextId(String string) {
        return this.replicationEngine != null ? this.replicationEngine.getNextId(string) : -1L;
    }
}

