/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import net.xoetrope.optional.pool.PoolManager;
import net.xoetrope.optional.pool.PoolObject;

public class ConnectionObject
extends PoolObject {
    Connection connection;
    PoolManager poolManager;
    Statement statement;
    PreparedStatement preparedStatement;

    public ConnectionObject(Connection connection, PoolManager poolManager) {
        this.connection = connection;
        this.poolManager = poolManager;
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public boolean validate() {
        try {
            this.connection.getMetaData();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void close() throws Exception {
        this.poolManager.returnObject(this);
    }

    public Statement createStatement() throws SQLException {
        this.checkStatementIsClosed();
        this.statement = this.connection.createStatement();
        return this.statement;
    }

    private void checkStatementIsClosed() throws SQLException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkStatementIsClosed();
        this.statement = this.connection.createStatement(n, n2);
        return this.statement;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkStatementIsClosed();
        this.statement = this.connection.createStatement(n, n2, n3);
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            this.statement = null;
        }
        super.expireLease();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.preparedStatement != null) {
            return null;
        }
        this.preparedStatement = this.connection.prepareStatement(string);
        return this.preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.preparedStatement != null) {
            return null;
        }
        this.preparedStatement = this.connection.prepareStatement(string, n, n2);
        return this.preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.preparedStatement != null) {
            return null;
        }
        this.preparedStatement = this.connection.prepareStatement(string, n, n2, n3);
        return this.preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePreparedStatement() {
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            this.preparedStatement = null;
        }
        super.expireLease();
    }

    public Connection getConnection() {
        return this.connection;
    }
}

