/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.xoetrope.optional.data.sql.ConnectionObject;
import net.xoetrope.optional.pool.PoolManager;
import net.xoetrope.optional.pool.PoolObject;

public class ConnectionManager
extends PoolManager {
    protected String url;
    protected String user;
    protected String password;
    protected static String defaultDriverName = "sun.jdbc.odbc.JdbcOdbcDriver";
    protected static String defaultDatabaseUrl = "jdbc:odbc:xlib";
    protected static ConnectionManager connMgr = null;

    protected ConnectionManager(String string, String string2, String string3, String string4, int n) {
        super(n);
        defaultDriverName = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
    }

    public PoolObject getNewObject(String string) throws SQLException {
        try {
            Class.forName(defaultDriverName.trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
        return new ConnectionObject(connection, this);
    }

    public static ConnectionManager getInstance() {
        if (connMgr != null) {
            return connMgr;
        }
        connMgr = new ConnectionManager(defaultDriverName, defaultDatabaseUrl, "sa", "", 10);
        return connMgr;
    }

    public ConnectionManager reset(String string, String string2, String string3, String string4) {
        if (connMgr != null) {
            connMgr.closeObjects();
        }
        defaultDriverName = string;
        try {
            Class.forName(defaultDriverName.trim());
            connMgr = new ConnectionManager(defaultDriverName, string2, string3, string4, 10);
            return connMgr;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public ConnectionObject getConnection(String string) throws SQLException {
        try {
            return (ConnectionObject)ConnectionManager.getInstance().getObject(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }
}

