/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.data.pojo.XPojoAdapter;
import net.xoetrope.optional.data.pojo.XPojoDataSource;
import net.xoetrope.optional.data.pojo.XPojoHelper;
import net.xoetrope.optional.data.pojo.XPojoIterator;
import net.xoetrope.xui.data.XBaseModel;
import net.xoetrope.xui.data.XModel;

public class XPojoModel
extends XModel {
    private volatile int hashcode;
    protected XPojoAdapter adapter;
    protected XPojoDataSource dataSource;
    protected String propertyName;
    protected Object[] getterArgValues;
    protected Class[] getterArgTypes;
    protected String propertyKey;
    protected int elIdx;
    protected Object pojo;
    protected XPojoModel[] collectionElements;
    protected Hashtable properties;
    protected boolean dirty;

    protected XPojoModel(XModel xModel, String string, XPojoDataSource xPojoDataSource) {
        this.setParent(xModel);
        this.properties = new Hashtable();
        this.dataSource = xPojoDataSource;
        this.dirty = true;
        this.setPojo(null);
        this.setProperties(string);
        xModel.append((XModel)this);
    }

    protected XPojoModel(XModel xModel, Object object, XPojoDataSource xPojoDataSource) {
        this.setParent(xModel);
        this.properties = new Hashtable();
        this.dataSource = xPojoDataSource;
        this.setPojo(object);
        this.dirty = false;
        this.setProperties(null);
    }

    private void setProperties(String string) {
        if (string != null) {
            this.propertyName = XPojoHelper.getPropertyName(string);
            this.getterArgValues = XPojoHelper.getArgumentValues(string);
            String string2 = XPojoHelper.getElementIndex(string);
            this.getterArgTypes = XPojoHelper.getTypes(this.getterArgValues);
            this.propertyKey = XPojoHelper.getPropertyKey(this.propertyName, this.getterArgTypes);
            try {
                this.elIdx = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.elIdx = -1;
            }
        } else {
            this.propertyName = null;
            this.getterArgValues = null;
            this.propertyKey = null;
            this.elIdx = -1;
        }
    }

    protected void setPojo(Object object) {
        this.pojo = object;
        if (this.pojo instanceof Collection) {
            Collection collection = (Collection)this.pojo;
            this.collectionElements = new XPojoModel[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.collectionElements[n] = this.dataSource.createPojoModel((XModel)this, iterator.next());
                ++n;
            }
        } else {
            this.collectionElements = null;
        }
        this.adapter = this.pojo != null ? this.dataSource.getAdapter(this.pojo) : null;
    }

    public XPojoDataSource getDataSource() {
        return this.dataSource;
    }

    protected String getPropertyKey() {
        return this.propertyKey;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected Object[] getGetterArgValues() {
        return this.getterArgValues;
    }

    protected Class[] getGetterArgTypes() {
        return this.getterArgTypes;
    }

    protected int getElIdx() {
        return this.elIdx;
    }

    protected void markSubtreeAsDirty() {
        Iterator iterator = this.properties.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((XPojoModel)((Object)iterator2.next())).setDirty(true);
            }
        }
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (this.dirty) {
            this.markSubtreeAsDirty();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected Object getPojo() {
        return this.pojo;
    }

    protected XPojoModel[] getCollectionElements() {
        return this.collectionElements;
    }

    public String getId() {
        return this.propertyName;
    }

    public void setId(String string) {
        this.hashcode = string.hashCode();
    }

    public void set(String string, Object object) {
    }

    public int getAttribute(String string) {
        return -1;
    }

    public void setAttribValue(int n, Object object) {
    }

    public void setAttribValue(int n, String string, Object object) {
    }

    protected void sync() {
        if (this.parentModel instanceof XPojoModel && !this.isTransient()) {
            this.setPojo(((XPojoModel)this.parentModel).getPropertyValue(this));
            this.dirty = false;
        }
    }

    public XModel get(int n) {
        if (this.dirty) {
            this.sync();
        }
        if (this.collectionElements != null) {
            return n < this.collectionElements.length ? this.collectionElements[n] : null;
        }
        DebugLogger.logError((String)"unsupported operation exception: get(int)");
        return null;
    }

    public Object get() {
        if (this.dirty) {
            this.sync();
        }
        return this.pojo;
    }

    protected boolean isTransient(String string) {
        if (this.dirty) {
            this.sync();
        }
        return this.adapter != null && this.adapter.isTransient(string);
    }

    public boolean isTransient() {
        if (this.propertyName == null) {
            return true;
        }
        if (!(this.parentModel instanceof XPojoModel)) {
            return true;
        }
        return ((XPojoModel)this.parentModel).isTransient(this.propertyName);
    }

    public boolean isCollection() {
        return this.pojo instanceof Collection;
    }

    protected Object getPropertyValue(XPojoModel xPojoModel) {
        Method method;
        if (this.dirty) {
            this.sync();
        }
        if (this.pojo == null) {
            return null;
        }
        if (!this.pojo.getClass().equals(this.adapter.getAdapterClass())) {
            this.adapter = this.dataSource.getAdapter(this.pojo);
        }
        if ((method = this.adapter.getGetter(xPojoModel)) == null) {
            String string = "Incorrect binding path element: " + xPojoModel.getPropertyName();
            DebugLogger.logError((String)string);
            throw new RuntimeException(string);
        }
        Object object = null;
        try {
            object = method.invoke(this.pojo, xPojoModel.getGetterArgValues());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        int n = xPojoModel.getElIdx();
        if (n >= 0) {
            if (object instanceof Collection) {
                object = ((Collection)object).toArray()[n];
            } else {
                String string = "Incorrect binding path element: " + xPojoModel.getPropertyName();
                DebugLogger.logError((String)string);
                throw new RuntimeException(string);
            }
        }
        return object;
    }

    public void set(Object object) {
        if (!(this.parentModel instanceof XPojoModel)) {
            return;
        }
        if (!this.isTransient()) {
            ((XPojoModel)this.parentModel).setPropertyValue(this, object);
            this.dirty = true;
        } else {
            this.setPojo(object);
            this.dirty = false;
        }
        this.markSubtreeAsDirty();
    }

    public void clear() {
        this.setPojo(null);
        Iterator iterator = this.properties.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((XPojoModel)((Object)iterator2.next())).clear();
            }
        }
    }

    protected void setPropertyValue(XPojoModel xPojoModel, Object object) {
        Method method;
        if (this.dirty) {
            this.sync();
        }
        if (this.pojo == null) {
            return;
        }
        if (!this.pojo.getClass().equals(this.adapter.getAdapterClass())) {
            this.adapter = this.dataSource.getAdapter(this.pojo);
        }
        if ((method = this.adapter.getSetter(xPojoModel, object)) == null) {
            String string = "Incorrect binding path element: " + xPojoModel.getPropertyName();
            DebugLogger.logError((String)string);
            throw new RuntimeException(string);
        }
        try {
            method.invoke(this.pojo, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected XPojoModel retrieveModelNode(String string) {
        List list;
        XPojoModel xPojoModel = null;
        if (string != null && (list = (List)this.properties.get(string)) != null) {
            xPojoModel = (XPojoModel)((Object)list.get(0));
        }
        return xPojoModel;
    }

    protected void saveModelNode(String string, XPojoModel xPojoModel) {
        ArrayList<XPojoModel> arrayList = (ArrayList<XPojoModel>)this.properties.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<XPojoModel>();
            this.properties.put(string, arrayList);
        }
        arrayList.add(xPojoModel);
    }

    public Object get(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string3 = XBaseModel.getAttribFromPath((String)string);
        String string4 = null;
        int n = string.indexOf(47);
        if (string3 != null) {
            int n2 = string3.indexOf(61);
            if (n2 > 0) {
                if (string3.charAt(n2 + 1) == '[') {
                    int n3 = string3.indexOf(93);
                    string4 = string3.substring(n2 + 2, n3).trim();
                    n = string.indexOf(47, string.indexOf(93));
                } else {
                    string4 = string3.substring(n2 + 1).trim();
                }
            } else {
                return this.getAttribValue(this.getAttribute(string3));
            }
            string3 = string3.substring(0, n2).trim();
            string2 = XBaseModel.getBaseFromPath((String)string);
        } else {
            string2 = n > -1 ? string.substring(0, n) : string;
        }
        XPojoModel xPojoModel = this.retrieveModelNode(string2);
        if (xPojoModel == null) {
            xPojoModel = "iterator".equals(string2) ? new XPojoIterator(this, this.dataSource) : this.dataSource.createPojoModel((XModel)this, string2);
            this.saveModelNode(string2, xPojoModel);
        }
        if (n >= 0) {
            xPojoModel = (XPojoModel)((Object)xPojoModel.get(string.substring(n + 1)));
        }
        return xPojoModel;
    }

    public void hasAutoId(boolean bl) {
    }

    public String getAttribName(int n) {
        return null;
    }

    public String getAttribValueAsString(int n) {
        return null;
    }

    public Object getAttribValue(int n) {
        return null;
    }

    public double getAttribValueAsDouble(int n) {
        return Double.NaN;
    }

    public double getAttribValueAsDouble(int n, char c, char c2) {
        return Double.NaN;
    }

    public int getAttribValueAsInt(int n) {
        return -1;
    }

    public double getValueAsDouble(String string) {
        return Double.NaN;
    }

    public int getValueAsInt(String string) {
        return -1;
    }

    public String getValueAsString(String string) {
        return null;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public int getNumChildren() {
        if (this.dirty) {
            this.sync();
        }
        return this.collectionElements != null ? this.collectionElements.length : 0;
    }

    public int getNumAttributes() {
        return 0;
    }

    public void setNumChildren(int n) {
    }

    public void append(XModel xModel) {
        if (!(xModel instanceof XPojoModel)) {
            DebugLogger.logError((String)"Unsupported operation: append(XModel)");
            throw new UnsupportedOperationException("append");
        }
        xModel.setParent((XModel)this);
        this.saveModelNode(xModel.getId(), (XPojoModel)xModel);
    }

    public Object append(String string) {
        return this.get(string);
    }
}

