/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import net.xoetrope.optional.data.XIterator;
import net.xoetrope.optional.data.pojo.XPojoDataSource;
import net.xoetrope.optional.data.pojo.XPojoModel;
import net.xoetrope.xui.data.XModel;

public class XPojoIterator
extends XPojoModel
implements XIterator {
    protected XPojoModel[] elements;
    protected int curIdx;

    public XPojoIterator(XModel xModel, XPojoDataSource xPojoDataSource) {
        super(xModel, null, xPojoDataSource);
        this.setId("iterator");
        this.elements = null;
        this.curIdx = 0;
    }

    public void sync() {
        XPojoModel xPojoModel = (XPojoModel)this.getParent();
        if (xPojoModel.isDirty()) {
            xPojoModel.sync();
        }
        this.elements = xPojoModel.getCollectionElements();
        if (this.elements != null && this.elements.length > 0) {
            this.curIdx = 0;
            this.setPojo(this.elements[0].getPojo());
        } else {
            this.setPojo(null);
        }
        this.dirty = false;
    }

    public Object current() {
        if (this.dirty) {
            this.sync();
        }
        return this.elements != null && this.elements.length > 0 ? this.elements[this.curIdx] : null;
    }

    public boolean hasNext() {
        if (this.dirty) {
            this.sync();
        }
        return this.elements != null && this.curIdx < this.elements.length - 1;
    }

    public Object next() {
        if (this.dirty) {
            this.sync();
        }
        if (this.hasNext()) {
            this.setPojo(this.elements[++this.curIdx].getPojo());
            this.markSubtreeAsDirty();
        }
        return this.current();
    }

    public Object first() {
        if (this.dirty) {
            this.sync();
        }
        if (this.elements != null && this.elements.length > 0) {
            this.curIdx = 0;
            this.setPojo(this.elements[0].getPojo());
            this.markSubtreeAsDirty();
        }
        return this.current();
    }

    public Object last() {
        if (this.dirty) {
            this.sync();
        }
        if (this.elements != null && this.elements.length > 0) {
            this.curIdx = this.elements.length - 1;
            this.setPojo(this.elements[this.curIdx].getPojo());
            this.markSubtreeAsDirty();
        }
        return this.current();
    }

    public boolean hasPrevious() {
        if (this.dirty) {
            this.sync();
        }
        return this.elements != null && this.elements.length > 0 && this.curIdx > 0;
    }

    public Object previous() {
        if (this.dirty) {
            this.sync();
        }
        if (this.hasPrevious()) {
            this.setPojo(this.elements[--this.curIdx].getPojo());
            this.markSubtreeAsDirty();
        }
        return this.current();
    }

    public String getId() {
        return "iterator";
    }
}

