/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import net.xoetrope.optional.data.pojo.XPojoModel;
import net.xoetrope.xui.XProject;

public class XPojoHelper {
    private static XProject currentProject;
    private XPojoModel pojoBase;

    public XPojoHelper(Object object) {
        this.pojoBase = (XPojoModel)((Object)object);
    }

    public void setDirty(String string) {
        this.get(string).setDirty(true);
    }

    public void setDirty() {
        this.pojoBase.setDirty(true);
    }

    public boolean isDirty(String string) {
        return this.get(string).isDirty();
    }

    public XPojoModel getRootModel() {
        return this.pojoBase;
    }

    public XPojoModel get(String string) {
        return (XPojoModel)((Object)this.pojoBase.get(string));
    }

    public XPojoModel set(String string, Object object) {
        XPojoModel xPojoModel = (XPojoModel)((Object)this.pojoBase.get(string));
        xPojoModel.set(object);
        return xPojoModel;
    }

    public static void setCurrentProject(XProject xProject) {
        currentProject = xProject;
    }

    public static boolean needsAdapter(Class clazz) {
        return clazz != null && !Collection.class.isAssignableFrom(clazz) && !XPojoHelper.isPrimitiveType(clazz);
    }

    public static boolean isPrimitiveType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        boolean bl = clazz.isPrimitive();
        bl = bl || String.class.isAssignableFrom(clazz);
        bl = bl || Boolean.class.isAssignableFrom(clazz);
        bl = bl || Character.class.isAssignableFrom(clazz);
        bl = bl || Byte.class.isAssignableFrom(clazz);
        bl = bl || Short.class.isAssignableFrom(clazz);
        bl = bl || Integer.class.isAssignableFrom(clazz);
        bl = bl || Long.class.isAssignableFrom(clazz);
        bl = bl || Float.class.isAssignableFrom(clazz);
        bl = bl || Double.class.isAssignableFrom(clazz);
        return bl;
    }

    protected static Object convertValue(String string, String string2) {
        Object object = null;
        try {
            if ("null".equals(string2)) {
                object = null;
            } else if ("String".equals(string)) {
                object = string2;
            } else if ("Boolean".equals(string)) {
                if ("true".equals(string2.toLowerCase())) {
                    object = Boolean.TRUE;
                } else if ("false".equals(string2.toLowerCase())) {
                    object = Boolean.FALSE;
                }
            } else if ("Character".equals(string)) {
                if (string2.length() == 1) {
                    object = new Character(string2.charAt(0));
                }
            } else if ("Byte".equals(string)) {
                object = Byte.valueOf(string2);
            } else if ("Short".equals(string)) {
                object = new Short(Short.parseShort(string2));
            } else if ("Integer".equals(string)) {
                object = new Integer(Integer.parseInt(string2));
            } else if ("Long".equals(string)) {
                object = new Long(Long.parseLong(string2));
            } else if ("Float".equals(string)) {
                object = new Float(Float.parseFloat(string2));
            } else if ("Double".equals(string)) {
                object = new Double(Double.parseDouble(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = null;
        }
        return object;
    }

    protected static Class convertType(String string) {
        Class clazz = null;
        if ("String".equals(string)) {
            clazz = String.class;
        } else if ("Boolean".equals(string)) {
            clazz = Boolean.class;
        } else if ("Character".equals(string)) {
            clazz = Character.class;
        } else if ("Byte".equals(string)) {
            clazz = Byte.class;
        } else if ("Short".equals(string)) {
            clazz = Short.class;
        } else if ("Integer".equals(string)) {
            clazz = Integer.class;
        } else if ("Long".equals(string)) {
            clazz = Long.class;
        } else if ("Float".equals(string)) {
            clazz = Float.class;
        } else if ("Double".equals(string)) {
            clazz = Double.class;
        }
        return clazz;
    }

    protected static String getMethodName(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n != -1 && n2 != -1 && n2 > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected static Class[] getArgumentTypes(String string) {
        if (string == null) {
            return null;
        }
        Class[] classArray = null;
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n != -1 && n2 != -1 && n2 > n) {
            string = string.substring(n + 1, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            classArray = new Class[stringTokenizer.countTokens()];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Class clazz = XPojoHelper.convertType(stringTokenizer.nextToken());
                if (clazz == null) {
                    classArray = null;
                    break;
                }
                classArray[n3] = clazz;
                ++n3;
            }
        }
        return classArray;
    }

    protected static Object[] getArgumentValues(String string) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = new Object[]{};
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n != -1 && n2 != -1 && n2 > n) {
            String string2;
            int n3;
            string = string.substring(n + 1, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            objectArray = new Object[stringTokenizer.countTokens()];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens() && (n3 = (string2 = stringTokenizer.nextToken()).indexOf(":")) != -1) {
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1, string2.length());
                objectArray[n4] = XPojoHelper.convertValue(string3, string4);
                ++n4;
            }
        }
        return objectArray;
    }

    protected static String getElementIndex(String string) {
        int n = -1;
        int n2 = string.indexOf("[");
        int n3 = string.indexOf("]");
        string = n2 != -1 && n3 != -1 && n3 > n2 ? string.substring(n2 + 1, n3) : "";
        return string;
    }

    public static String getPropertyName(String string) {
        int n = string.lastIndexOf("(");
        int n2 = string.lastIndexOf(")");
        if (n != -1 && n2 != -1 && n2 > n) {
            string = string.substring(0, n);
        } else {
            n = string.lastIndexOf("[");
            n2 = string.lastIndexOf("]");
            if (n != -1 && n2 != -1 && n2 > n) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public static String getPropertyKey(String string, Class[] classArray) {
        Integer n = XPojoHelper.getSignatureKey(classArray);
        return string + "@" + n;
    }

    public static Integer getSignatureKey(Class[] classArray) {
        if (classArray == null) {
            return new Integer(0);
        }
        return new Integer(((Object)Arrays.asList(classArray)).hashCode());
    }

    public static Class[] getTypes(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }
}

