/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.data.pojo.XPersistenceController;
import net.xoetrope.optional.data.pojo.XPersistentPojoAdapter;
import net.xoetrope.optional.data.pojo.XPojoDataSource;
import net.xoetrope.optional.data.pojo.XPojoModel;
import net.xoetrope.xui.data.XModel;

public class XPersistentPojoModel
extends XPojoModel {
    protected XPersistentPojoModel(XModel xModel, String string, XPojoDataSource xPojoDataSource) {
        super(xModel, string, xPojoDataSource);
    }

    protected XPersistentPojoModel(XModel xModel, Object object, XPojoDataSource xPojoDataSource) {
        super(xModel, object, xPojoDataSource);
    }

    protected boolean getterRequiresTransaction(XPojoModel xPojoModel) {
        XPersistentPojoAdapter xPersistentPojoAdapter = (XPersistentPojoAdapter)this.adapter;
        return xPersistentPojoAdapter.isDao() || xPersistentPojoAdapter.getterRequiresTransaction(xPojoModel);
    }

    protected boolean setterRequiresTransaction(XPojoModel xPojoModel, Object object) {
        XPersistentPojoAdapter xPersistentPojoAdapter = (XPersistentPojoAdapter)this.adapter;
        return xPersistentPojoAdapter.isDao() || xPersistentPojoAdapter.setterRequiresTransaction(xPojoModel, object);
    }

    protected void setPropertyValue(XPojoModel xPojoModel, Object object) {
        if (this.dirty) {
            this.sync();
        }
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        boolean bl = this.setterRequiresTransaction(xPojoModel, object);
        try {
            if (bl) {
                xPersistenceController.beginWorkUnit();
                if (!xPersistenceController.isTransactionActive()) {
                    xPersistenceController.beginTransaction();
                }
                if (!((XPersistentPojoAdapter)this.adapter).isDao()) {
                    this.merge();
                }
            }
            super.setPropertyValue(xPojoModel, object);
        }
        catch (RuntimeException runtimeException) {
            DebugLogger.logError((String)("error while executing getter: " + runtimeException.getMessage()));
            if (bl && xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (RuntimeException runtimeException2) {
                    DebugLogger.logError((String)"couldn't roll back transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            if (bl) {
                xPersistenceController.endWorkUnit();
            }
        }
    }

    protected Object getPropertyValue(XPojoModel xPojoModel) {
        if (this.dirty) {
            this.sync();
        }
        if (this.pojo == null) {
            return null;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        boolean bl = this.getterRequiresTransaction(xPojoModel);
        Object object = null;
        try {
            if (bl) {
                xPersistenceController.beginWorkUnit();
                if (!xPersistenceController.isTransactionActive()) {
                    xPersistenceController.beginTransaction();
                }
                if (!((XPersistentPojoAdapter)this.adapter).isDao()) {
                    this.merge();
                }
            }
            object = super.getPropertyValue(xPojoModel);
        }
        catch (RuntimeException runtimeException) {
            if (bl && xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (RuntimeException runtimeException2) {
                    DebugLogger.logError((String)"couldn't rollback database transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            if (bl) {
                xPersistenceController.endWorkUnit();
            }
        }
        return object;
    }

    public void persist() {
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        try {
            xPersistenceController.beginWorkUnit();
            if (!xPersistenceController.isTransactionActive()) {
                xPersistenceController.beginTransaction();
            }
            xPersistenceController.persist(this.pojo);
        }
        catch (RuntimeException runtimeException) {
            if (xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (Exception exception) {
                    DebugLogger.logError((String)"couldn't rollback database transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            xPersistenceController.endWorkUnit();
        }
    }

    public void merge() {
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        try {
            xPersistenceController.beginWorkUnit();
            if (!xPersistenceController.isTransactionActive()) {
                xPersistenceController.beginTransaction();
            }
            this.setPojo(xPersistenceController.merge(this.pojo));
        }
        catch (RuntimeException runtimeException) {
            if (xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (Exception exception) {
                    DebugLogger.logError((String)"couldn't rollback database transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            xPersistenceController.endWorkUnit();
        }
    }

    public void lock() {
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        try {
            xPersistenceController.beginWorkUnit();
            if (!xPersistenceController.isTransactionActive()) {
                xPersistenceController.beginTransaction();
            }
            xPersistenceController.lock(this.pojo);
        }
        catch (RuntimeException runtimeException) {
            if (xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (Exception exception) {
                    DebugLogger.logError((String)"couldn't rollback database transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            xPersistenceController.endWorkUnit();
        }
    }

    public void delete() {
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        try {
            xPersistenceController.beginWorkUnit();
            if (!xPersistenceController.isTransactionActive()) {
                xPersistenceController.beginTransaction();
            }
            xPersistenceController.delete(this.pojo);
        }
        catch (RuntimeException runtimeException) {
            if (xPersistenceController.isTransactionActive()) {
                try {
                    xPersistenceController.rollbackTransaction();
                }
                catch (RuntimeException runtimeException2) {
                    DebugLogger.logError((String)"couldn't rollback transaction");
                }
            }
            throw runtimeException;
        }
        finally {
            xPersistenceController.endWorkUnit();
        }
        this.clear();
    }

    public void evict() {
        if (this.pojo == null) {
            return;
        }
        XPersistenceController xPersistenceController = (XPersistenceController)this.dataSource.getPojoContext();
        xPersistenceController.evict(this.pojo);
        this.clear();
    }
}

