/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import java.awt.Component;
import net.xoetrope.optional.data.pojo.XPersistentPojoModel;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XListHolder;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.data.XListBinding;

public class XPersistentListHelper {
    private XPersistentPojoModel selectionModel;
    private XPersistentPojoModel sourceModel;
    private int oldIdx;
    private XListHolder listHolder;
    private PageSupport page;

    public XPersistentListHelper(XListHolder xListHolder, PageSupport pageSupport, XPersistentPojoModel xPersistentPojoModel) {
        this.listHolder = xListHolder;
        this.page = pageSupport;
        this.oldIdx = this.listHolder.getSelectedIndex();
        this.sourceModel = (XPersistentPojoModel)this.page.getBinding((Object)this.listHolder).getSource();
        this.selectionModel = xPersistentPojoModel;
    }

    public XPersistentListHelper(XListHolder xListHolder, PageSupport pageSupport) {
        this.listHolder = xListHolder;
        this.page = pageSupport;
        this.oldIdx = -1;
        this.sourceModel = (XPersistentPojoModel)this.page.getBinding((Object)this.listHolder).getSource();
        this.selectionModel = null;
    }

    public XPersistentListHelper(XListHolder xListHolder, PageSupport pageSupport, String string) {
        this.listHolder = xListHolder;
        this.page = pageSupport;
        this.oldIdx = -1;
        this.sourceModel = (XPersistentPojoModel)this.page.getBinding((Object)this.listHolder).getSource();
        this.selectionModel = (XPersistentPojoModel)((Object)this.page.getProject().getModel().get(string));
    }

    public XPersistentPojoModel getListSelectedModel() {
        int n = this.listHolder.getSelectedIndex();
        return n >= 0 ? (XPersistentPojoModel)this.sourceModel.get(n) : null;
    }

    public XPersistentPojoModel getSelectionModel() {
        return this.selectionModel;
    }

    public void persistSelectedPojo() {
        XPersistentPojoModel xPersistentPojoModel = this.getListSelectedModel();
        if (xPersistentPojoModel != null) {
            xPersistentPojoModel.persist();
            if (this.selectionModel != null) {
                this.selectionModel.merge();
            }
        }
    }

    public void mergeSelectedPojo() {
        XPersistentPojoModel xPersistentPojoModel = this.getListSelectedModel();
        if (xPersistentPojoModel != null) {
            xPersistentPojoModel.merge();
        }
        if (this.selectionModel != null) {
            this.selectionModel.merge();
        }
    }

    public void deleteSelectedPojo() {
        XPersistentPojoModel xPersistentPojoModel = this.getListSelectedModel();
        if (xPersistentPojoModel != null) {
            xPersistentPojoModel.delete();
        }
        if (this.selectionModel != null) {
            this.selectionModel.set(null);
        }
    }

    public void clearSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.set(null);
        }
    }

    public boolean selectionChanged() {
        int n = this.listHolder.getSelectedIndex();
        if (n == this.oldIdx) {
            return false;
        }
        this.oldIdx = n;
        if (this.selectionModel != null) {
            XPersistentPojoModel xPersistentPojoModel = this.getListSelectedModel();
            this.selectionModel.set(xPersistentPojoModel != null ? xPersistentPojoModel.get() : null);
        }
        return true;
    }

    public boolean selectionEmpty() {
        return this.listHolder.getSelectedIndex() == -1;
    }

    public Object getSelectedPojo() {
        Object object = null;
        if (this.selectionModel != null) {
            object = this.selectionModel.get();
        } else {
            XPersistentPojoModel xPersistentPojoModel = this.getListSelectedModel();
            if (xPersistentPojoModel != null) {
                object = xPersistentPojoModel.get();
            }
        }
        return object;
    }

    public void clearSelection() {
        this.listHolder.select(-1);
        this.oldIdx = -1;
        if (this.selectionModel != null) {
            this.selectionModel.set(null);
        }
        if (this.listHolder instanceof Component) {
            ((Component)this.listHolder).repaint();
        }
    }

    public void updateBinding() {
        XDataBinding xDataBinding = this.page.getBinding((Object)this.listHolder);
        if (xDataBinding instanceof XListBinding) {
            ((XListBinding)xDataBinding).setDirty(true);
        }
        this.page.updateBinding(xDataBinding);
    }

    public void updateListHolder() {
        this.sourceModel.setDirty(true);
        XDataBinding xDataBinding = this.page.getBinding((Object)this.listHolder);
        if (xDataBinding instanceof XListBinding) {
            ((XListBinding)xDataBinding).setDirty(true);
        }
        this.page.updateBinding(xDataBinding);
    }
}

