/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.data.pojo.XPojoContext;

public abstract class XPersistenceController
extends XPojoContext {
    private int counter = 0;

    public void beginWorkUnit() {
        this.beginWorkUnit(true);
    }

    public void beginWorkUnit(boolean bl) {
        try {
            ++this.counter;
            if (!bl && !this.isTransactionActive()) {
                this.beginTransaction();
            }
        }
        catch (RuntimeException runtimeException) {
            DebugLogger.logError((String)"coulnd't begin database transaction");
            --this.counter;
        }
    }

    public void endWorkUnit() {
        if (--this.counter == 0 && this.isTransactionActive()) {
            try {
                this.commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                DebugLogger.logError((String)runtimeException.getMessage());
                if (this.isTransactionActive()) {
                    try {
                        this.rollbackTransaction();
                    }
                    catch (RuntimeException runtimeException2) {
                        DebugLogger.logError((String)"couldn't rollback database transaction");
                    }
                }
                throw runtimeException;
            }
        }
    }

    public boolean isWorkUnitOpen() {
        return this.counter > 0;
    }

    public abstract void beginTransaction();

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public abstract boolean isTransactionActive();

    public abstract void persist(Object var1);

    public abstract void delete(Object var1);

    public abstract void evict(Object var1);

    public abstract Object merge(Object var1);

    public abstract void lock(Object var1);

    public abstract Object getTransactionObject();

    public abstract void flush();
}

