/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.pojo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.optional.data.pojo.XHibernatePojoModel;
import net.xoetrope.optional.data.pojo.XPersistentPojoAdapter;
import net.xoetrope.optional.data.pojo.XPersistentPojoDataSource;
import net.xoetrope.optional.data.pojo.XPojoAdapter;
import net.xoetrope.optional.data.pojo.XPojoDataSource;
import net.xoetrope.optional.data.pojo.XPojoModel;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xml.jaxp.JaxpXmlParser;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHibernatePojoDataSource
extends XPersistentPojoDataSource {
    private static final String[] COLLECTION_TYPES = new String[]{"bag", "idbag", "set", "list", "map"};
    private static final String[] FETCH_TYPES = new String[]{"join", "select", "subselect"};
    protected Hashtable hibernateConfiguration = new Hashtable();
    protected JaxpXmlParser xmlParser;

    public XHibernatePojoDataSource(XProject xProject) {
        super(xProject);
        this.xmlParser = JaxpXmlParser.getInstance((XProject)xProject);
        this.xmlParser.setEntityResolver((EntityResolver)new XHibernateEntityResolver());
        this.readMappingFiles();
    }

    protected XmlElement getOverrideXml(XPojoAdapter xPojoAdapter) {
        String string = this.getSourceClassName(xPojoAdapter.getAdapterClassName());
        return (XmlElement)this.overrides.get(string);
    }

    protected void overrideAdapter(XPojoAdapter xPojoAdapter) {
        String string = this.getSourceClassName(xPojoAdapter.getAdapterClassName());
        List list = (List)this.hibernateConfiguration.get(string);
        if (list != null) {
            XPersistentPojoAdapter xPersistentPojoAdapter = (XPersistentPojoAdapter)xPojoAdapter;
            for (String string2 : list) {
                xPersistentPojoAdapter.setGetterTransaction(string2, null);
            }
        }
        super.overrideAdapter(xPojoAdapter);
    }

    private String getSourceClassName(String string) {
        int n = string.indexOf("$");
        return n > 0 ? string.substring(0, n) : string;
    }

    protected XPojoModel createPojoModel(XModel xModel, String string) {
        return new XHibernatePojoModel(xModel, string, (XPojoDataSource)this);
    }

    protected XPojoModel createPojoModel(XModel xModel, Object object) {
        return new XHibernatePojoModel(xModel, object, (XPojoDataSource)this);
    }

    private void readMappingFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = this.currentProject.getBufferedReader("hibernate.cfg.xml");
            XmlElement object = XmlSource.read((Reader)bufferedReader).getFirstChildNamed("session-factory");
            if (object != null) {
                Enumeration enumeration = object.getChildren().elements();
                while (enumeration.hasMoreElements()) {
                    String string;
                    XmlElement xmlElement = (XmlElement)enumeration.nextElement();
                    if (!"mapping".equals(xmlElement.getName()) || (string = xmlElement.getAttribute("resource")) == null) continue;
                    arrayList.add(string);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            DebugLogger.logError((String)"failed to read Hibernate mapping file names");
            exception.printStackTrace();
            return;
        }
        for (String string : arrayList) {
            if (string == null) continue;
            this.readMappingFile(string);
        }
    }

    private void readMappingFile(String string) {
        try {
            BufferedReader bufferedReader = this.currentProject.getBufferedReader(string);
            XmlElement xmlElement = this.xmlParser.parse((Reader)bufferedReader);
            String string2 = xmlElement.getAttribute("package");
            if (string2 == null) {
                return;
            }
            Enumeration enumeration = xmlElement.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                XmlElement xmlElement2 = (XmlElement)enumeration.nextElement();
                if (!"class".equals(xmlElement2.getName())) continue;
                String string3 = string2 + "." + xmlElement2.getAttribute("name");
                Enumeration enumeration2 = xmlElement2.getChildren().elements();
                while (enumeration2.hasMoreElements()) {
                    XmlElement xmlElement3 = (XmlElement)enumeration2.nextElement();
                    if (!this.isLazyCollection(xmlElement3)) continue;
                    String string4 = xmlElement3.getAttribute("name");
                    ArrayList<String> arrayList = (ArrayList<String>)this.hibernateConfiguration.get(string3);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        this.hibernateConfiguration.put(string3, arrayList);
                    }
                    arrayList.add(string4);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            DebugLogger.logError((String)("unable to read the file: " + string));
            exception.printStackTrace();
        }
    }

    private boolean isLazyCollection(XmlElement xmlElement) {
        if (xmlElement == null) {
            return false;
        }
        String string = xmlElement.getName();
        boolean bl = false;
        for (int i = 0; !bl && i < COLLECTION_TYPES.length; ++i) {
            bl = COLLECTION_TYPES[i].equalsIgnoreCase(string);
        }
        if (!bl) {
            return false;
        }
        String string2 = xmlElement.getAttribute("fetch");
        if (string2 == null) {
            return true;
        }
        boolean bl2 = true;
        for (int i = 0; bl2 && i < FETCH_TYPES.length; ++i) {
            bl2 = !FETCH_TYPES[i].equalsIgnoreCase(string2);
        }
        return bl2;
    }

    private class XHibernateEntityResolver
    implements EntityResolver {
        private XHibernateEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            InputSource inputSource = null;
            if (string2.endsWith(".dtd")) {
                InputStream inputStream = new InputStream(){

                    public int read() throws IOException {
                        return -1;
                    }
                };
                inputSource = new InputSource(inputStream);
            }
            return inputSource;
        }
    }
}

