/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data.collection;

import java.io.Writer;
import java.util.List;
import net.xoetrope.debug.DumpWriter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.XRowSelector;
import net.xoetrope.xui.data.table.XRowModel;
import net.xoetrope.xui.data.table.XTableModel;

public class XCollectionTableModel
extends XTableModel
implements DumpWriter,
XRowSelector {
    private List sourceData;
    private List columnNames;
    private boolean dirty;
    private boolean readOnly;
    private static boolean allowNull = false;
    protected String modelId;
    protected XProject currentProject;
    private int rowIdx;
    private int colIdx;
    private int numRows;
    private int numCols;

    public XCollectionTableModel(XProject xProject, String string, List list, List list2) {
        this.currentProject = xProject;
        this.sourceData = list2;
        this.modelId = string;
        this.colIdx = -1;
        this.rowIdx = -1;
        this.columnNames = list;
        this.dirty = true;
        this.readOnly = true;
        this.retrieve();
    }

    public static void setAllowNull(boolean bl) {
        allowNull = bl;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setName(String string) {
        this.modelId = string;
    }

    public int hashCode() {
        return this.modelId.hashCode();
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public Object get(String string) {
        XRowModel xRowModel = new XRowModel((XTableModel)this, this.rowIdx);
        return xRowModel.get(string);
    }

    public void set(String string, String string2, Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public void set(String string, Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public XModel get(int n) {
        XRowModel xRowModel = new XRowModel((XTableModel)this, n);
        xRowModel.setParent((XModel)this);
        return xRowModel;
    }

    public Object get() {
        return this;
    }

    public Object append(String string) {
        return null;
    }

    public void set(Object object) {
        if (this.readOnly) {
            return;
        }
        this.dirty = true;
        this.fireModelUpdated();
    }

    public Object getAttribValue(int n) {
        return this.sourceData.get(n);
    }

    public String getAttribValueAsString(int n) {
        return ((List)this.sourceData.get(this.rowIdx)).get(n).toString();
    }

    public double getAttribValueAsDouble(int n) {
        try {
            Object e = ((List)this.sourceData.get(this.rowIdx)).get(n);
            if (e == null) {
                if (allowNull) {
                    return Double.NaN;
                }
                return 0.0;
            }
            if (e instanceof Integer) {
                return ((Integer)e).intValue();
            }
            if (e instanceof Double) {
                return (Double)e;
            }
            if (e instanceof Long) {
                return ((Long)e).longValue();
            }
            if (e instanceof Float) {
                return ((Float)e).floatValue();
            }
            return Double.parseDouble(e.toString());
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0.0;
        }
    }

    public int getAttribValueAsInt(int n) {
        try {
            Object e = ((List)this.sourceData.get(this.rowIdx)).get(n);
            if (e == null && allowNull) {
                return Integer.MIN_VALUE;
            }
            if (e instanceof Integer) {
                return (Integer)e;
            }
            if (e instanceof String) {
                return Integer.parseInt((String)e);
            }
            if (e instanceof Double) {
                return (int)((Double)e).doubleValue();
            }
            if (e instanceof Long) {
                return (int)((Long)e).longValue();
            }
            if (e instanceof Float) {
                return (int)((Float)e).floatValue();
            }
            return Integer.parseInt(e.toString());
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getAttribute(String string) {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.columnNames.get(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void sync() {
        this.retrieve();
    }

    public void retrieve() {
        this.numRows = this.sourceData.size();
        this.numCols = this.columnNames != null ? this.columnNames.size() : (this.numRows > 0 ? ((List)this.sourceData.get(0)).size() : 0);
    }

    public void first() {
        this.rowIdx = 0;
    }

    public void last() {
        this.rowIdx = this.numRows - 1;
    }

    public boolean next() {
        if (this.rowIdx < this.numRows - 1) {
            ++this.rowIdx;
            return true;
        }
        return false;
    }

    public boolean hasMoreRows() {
        return this.rowIdx < this.numRows - 1;
    }

    public boolean previous() {
        if (this.rowIdx > 0) {
            --this.rowIdx;
            return true;
        }
        return false;
    }

    public String getValue() {
        return this.getFieldValue(this.rowIdx, this.colIdx);
    }

    public XModel getValue(int n) {
        return this.get(n);
    }

    public String getFieldValue(int n) {
        return this.getFieldValue(this.rowIdx, n);
    }

    public String getFieldValue(int n, int n2) {
        Object e = ((List)this.sourceData.get(n)).get(n2);
        if (e != null) {
            return e.toString();
        }
        return null;
    }

    public void setFieldValue(int n, String string) {
        this.setFieldValue(this.rowIdx, n, string);
        this.fireModelUpdated();
    }

    public void setFieldValue(int n, int n2, String string) {
        this.setFieldValue(n, n2, string);
        this.fireModelUpdated();
    }

    public double getValueAsDouble(String string) {
        return this.getAttribValueAsDouble(this.getAttribute(string));
    }

    public int getValueAsInt(String string) {
        return this.getAttribValueAsInt(this.getAttribute(string));
    }

    public String getAttribName(int n) {
        return this.columnNames.get(n).toString();
    }

    public String getId() {
        return this.modelId;
    }

    public void setAttribValue(int n, Object object) {
        this.setFieldValue(n, object.toString());
    }

    public int getNumChildren() {
        return this.sourceData.size();
    }

    public int getNumAttributes() {
        return this.numCols;
    }

    public String getTagName() {
        return "Collection";
    }

    public static XCollectionTableModel getTable(XProject xProject, String string) {
        return (XCollectionTableModel)((XModel)xProject.getModel().get(string));
    }

    public void dump(Writer writer) {
    }

    public void setSelectedRow(int n) {
        this.rowIdx = n;
    }

    public int getSelectedRow() {
        return this.rowIdx;
    }
}

