/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.optional.data;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.data.XDataSource;
import net.xoetrope.optional.data.XDataModelLoader;
import net.xoetrope.optional.data.XModelVisualiser;
import net.xoetrope.optional.data.XOptionalBindingFactory;
import net.xoetrope.optional.data.sql.DatabaseTable;
import net.xoetrope.optional.data.sql.DatabaseTableModel;
import net.xoetrope.optional.data.sql.NamedConnectionManager;
import net.xoetrope.optional.service.XRouteManager;
import net.xoetrope.optional.service.XServiceModelNode;
import net.xoetrope.optional.service.XServiceProxyNotFoundException;
import net.xoetrope.os.LibraryLoader;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.helper.ReflectionHelper;

public class XOptionalDataSource
extends XDataSource {
    protected XRouteManager routeMgr;
    protected XDataModelLoader modelLoader;

    public XOptionalDataSource(XProject xProject) {
        super(xProject);
        XOptionalBindingFactory.register(xProject);
        String string = this.currentProject.getStartupParam("CaseSensitiveDatabase");
        if (string != null && string.toLowerCase().equals("false")) {
            DatabaseTable.setCaseSensitive(false);
        }
        this.modelLoader = new XDataModelLoader(){

            public void loadModel(String string, XmlElement xmlElement, XModel xModel) {
                Object[] objectArray = new Object[]{XOptionalDataSource.this.currentProject};
                XDataSource xDataSource = (XDataSource)ReflectionHelper.constructViaReflection((String)string, (Object[])objectArray);
                xDataSource.loadTable(xmlElement, xModel);
            }
        };
    }

    public XDataModelLoader setModelLoader() {
        return this.modelLoader;
    }

    public void setModelLoader(XDataModelLoader xDataModelLoader) {
        this.modelLoader = xDataModelLoader;
    }

    protected void showVisualisation() {
        String string = this.currentProject.getStartupParam("ShowVisualiser");
        if (string != null && string.compareTo("true") == 0) {
            String string2 = this.currentProject.getStartupParam("VisualiseClass");
            try {
                XModelVisualiser xModelVisualiser = (XModelVisualiser)Class.forName(string2.trim()).newInstance();
                xModelVisualiser.showDlg("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void read(Reader reader) {
        XmlElement xmlElement = XmlSource.read((Reader)reader);
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        Vector vector = xmlElement.getChildren();
        if (vector != null) {
            int n = vector.size();
            XModel xModel = this.currentProject.getModel();
            for (int i = 0; i < n; ++i) {
                try {
                    XmlElement xmlElement5 = (XmlElement)vector.elementAt(i);
                    BufferedReader bufferedReader = this.currentProject.getBufferedReader(xmlElement5.getAttribute("filename"), "UTF8");
                    if (bufferedReader == null) continue;
                    XmlElement xmlElement6 = XmlSource.read((Reader)bufferedReader);
                    String string = xmlElement5.getAttribute("type");
                    if (string == null || string.length() == 0) {
                        this.loadTable(xmlElement6, xModel);
                    } else if (string.equals("database")) {
                        xmlElement2 = xmlElement6;
                    } else if (string.equals("routing")) {
                        xmlElement3 = xmlElement6;
                    } else if (string.equals("service")) {
                        xmlElement4 = xmlElement6;
                    } else if (this.modelLoader != null) {
                        this.modelLoader.loadModel(string, xmlElement6, xModel);
                    }
                    this.registerDataSource(xmlElement5);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                if (xmlElement3 != null) {
                    this.loadRoutes(xmlElement3, xModel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (xmlElement4 != null) {
                    this.loadService(xmlElement4, xModel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (xmlElement2 != null) {
                    this.loadDatabase(xmlElement2, xModel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.showVisualisation();
    }

    public void registerDataSource(XmlElement xmlElement) {
    }

    public void registerDatabaseNode(XmlElement xmlElement) {
    }

    public void loadDatabase(XmlElement xmlElement, XModel xModel) {
        XmlElement xmlElement2 = xmlElement.elementAt(0);
        String string = xmlElement2.getAttribute("driver");
        String string2 = xmlElement2.getAttribute("url");
        string2 = this.checkLocalHsqldb(string, string2);
        NamedConnectionManager namedConnectionManager = (NamedConnectionManager)NamedConnectionManager.getInstance();
        namedConnectionManager = (NamedConnectionManager)namedConnectionManager.reset(xmlElement2.getAttribute("id"), string, string2, xmlElement2.getAttribute("user"), xmlElement2.getAttribute("pwd"));
        this.registerDatabaseNode(xmlElement2);
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        int n2 = xModel.getNumChildren();
        xModel.setNumChildren(n2 += n);
        for (int i = 1; i < n; ++i) {
            String string3;
            Object object;
            XmlElement xmlElement3 = (XmlElement)vector.elementAt(i);
            if (xmlElement3.getName().compareTo("Connection") == 0) {
                object = xmlElement3.getAttribute("driver");
                string3 = xmlElement3.getAttribute("url");
                string3 = this.checkLocalHsqldb((String)object, string3);
                namedConnectionManager.addConnection(xmlElement3.getAttribute("id"), (String)object, string3, xmlElement3.getAttribute("user"), xmlElement3.getAttribute("pwd"));
            } else {
                String string4;
                object = new DatabaseTableModel(this.currentProject);
                string3 = xmlElement3.getAttribute("escape");
                if (string3 != null) {
                    ((DatabaseTableModel)((Object)object)).setDoesEscapeProcessing("true".equals(string3));
                }
                ((DatabaseTableModel)((Object)object)).setName(xmlElement3.getAttribute("id"));
                boolean bl = false;
                String string5 = xmlElement3.getAttribute("update");
                if (string5 != null) {
                    boolean bl2 = bl = string5.compareTo("true") == 0;
                }
                if ((string4 = xmlElement3.getAttribute("sql")) != null && string4.length() > 0) {
                    ((DatabaseTableModel)((Object)object)).setSqlStatement(string4, xmlElement3.getAttribute("conn"), bl);
                } else {
                    ((DatabaseTableModel)((Object)object)).setupTable(xmlElement3.getAttribute("from"), xmlElement3.getAttribute("fields"), xmlElement3.getAttribute("where"), xmlElement3.getAttribute("conn"), bl);
                    String string6 = xmlElement3.getAttribute("distinct");
                    if (string6 != null) {
                        ((DatabaseTableModel)((Object)object)).setDistinct(string6.equals("true"));
                    }
                    ((DatabaseTableModel)((Object)object)).setOrderField(xmlElement3.getAttribute("order"));
                }
                xModel.append((XModel)object);
            }
            this.registerDatabaseNode(xmlElement3);
        }
    }

    protected String checkLocalHsqldb(String string, String string2) {
        return XOptionalDataSource.checkLocalHsqldb(((Object)((Object)this)).getClass().getClassLoader(), string, string2);
    }

    public static String checkLocalHsqldb(ClassLoader classLoader, String string, String string2) {
        if (string.equals("org.hsqldb.jdbcDriver") && string2.indexOf(46) < 0) {
            String string3 = string2.substring(string2.lastIndexOf(58) + 1);
            try {
                String string4 = classLoader.getResource(string3 + ".script").getFile();
                if (string4.indexOf(".jar") > 0) {
                    string4 = LibraryLoader.extractFile(classLoader, string3 + ".script");
                    LibraryLoader.extractFile(classLoader, string3 + ".properties");
                    LibraryLoader.extractFile(classLoader, string3 + ".data");
                }
                return string2.substring(0, string2.lastIndexOf(58) + 1) + string4.substring(0, string4.lastIndexOf(46));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public void loadService(XmlElement xmlElement, XModel xModel) {
        this.routeMgr = XRouteManager.setupRouteManager(this.currentProject);
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            String string = xmlElement2.getAttribute("id");
            String string2 = xmlElement2.getAttribute("route");
            String string3 = xmlElement2.getAttribute("server");
            String[] stringArray = new String[]{};
            XServiceModelNode xServiceModelNode = new XServiceModelNode();
            try {
                xServiceModelNode.setupService(string, this.routeMgr.getRoute(string2, string3), stringArray);
                xServiceModelNode.getServiceProxy().setServiceName(string);
                xModel.set(string, (Object)xServiceModelNode);
                continue;
            }
            catch (XServiceProxyNotFoundException xServiceProxyNotFoundException) {
                xServiceProxyNotFoundException.printStackTrace();
            }
        }
    }

    public void loadRoutes(XmlElement xmlElement, XModel xModel) {
        XRouteManager xRouteManager = (XRouteManager)this.currentProject.getObject("RouteMgr");
        if (xRouteManager == null) {
            xRouteManager = new XRouteManager(this.currentProject);
            this.currentProject.setObject("RouteMgr", (Object)xRouteManager);
        }
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            String string = xmlElement2.getAttribute("id");
            if (string == null) continue;
            int n2 = xmlElement2.getChildren().size();
            Hashtable[] hashtableArray = new Hashtable[n2];
            for (int j = 0; j < n2; ++j) {
                XmlElement xmlElement3 = xmlElement2.elementAt(j);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                Enumeration enumeration = xmlElement3.enumerateAttributeNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement().toString();
                    hashtable.put(string2, xmlElement3.getAttribute(string2));
                    int n3 = xmlElement3.getChildren().size();
                    for (int k = 0; k < n3; ++k) {
                        XmlElement xmlElement4 = xmlElement3.elementAt(k);
                        Vector<String> vector2 = new Vector<String>();
                        Enumeration enumeration2 = xmlElement4.enumerateAttributeNames();
                        while (enumeration2.hasMoreElements()) {
                            String string3 = (String)enumeration2.nextElement();
                            if (string3.compareTo("id") != 0) continue;
                            vector2.add(xmlElement4.getAttribute("id"));
                        }
                        hashtable.put(new Integer(k).toString(), vector2);
                    }
                }
                hashtableArray[j] = hashtable;
            }
            xRouteManager.addRoute(string, hashtableArray);
        }
    }

    public String getModelXML(XModel xModel) {
        StringWriter stringWriter = new StringWriter();
        XDataSource.outputModel((Writer)stringWriter, (XModel)xModel);
        return stringWriter.toString();
    }
}

