/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.validation.UsernamePasswordCredentialsValidator;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationViaFormAction
extends FormAction {
    private CredentialsBinder credentialsBinder;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private CookieGenerator warnCookieGenerator;

    protected final void doBind(RequestContext context, DataBinder binder) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        Credentials credentials = (Credentials)binder.getTarget();
        if (this.credentialsBinder != null) {
            this.credentialsBinder.bind(request, credentials);
        }
        super.doBind(context, binder);
    }

    public Event referenceData(RequestContext context) throws Exception {
        context.getRequestScope().put("commandName", (Object)this.getFormObjectName());
        return this.success();
    }

    public final Event submit(RequestContext context) throws Exception {
        Credentials credentials;
        block6: {
            credentials = (Credentials)this.getFormObject(context);
            String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
            WebApplicationService service = WebUtils.getService(context);
            if (StringUtils.hasText((String)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null) {
                try {
                    String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credentials);
                    WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                    this.putWarnCookieIfRequestParameterPresent(context);
                    return this.warn();
                }
                catch (TicketException e) {
                    if (e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass())) {
                        this.populateErrorsInstance(context, e);
                        return this.error();
                    }
                    this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug((Object)"Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            WebUtils.putTicketGrantingTicketInRequestScope(context, this.centralAuthenticationService.createTicketGrantingTicket(credentials));
            this.putWarnCookieIfRequestParameterPresent(context);
            return this.success();
        }
        catch (TicketException e) {
            this.populateErrorsInstance(context, e);
            return this.error();
        }
    }

    private final Event warn() {
        return this.result("warn");
    }

    private final void populateErrorsInstance(RequestContext context, TicketException e) {
        try {
            Errors errors = this.getFormErrors(context);
            errors.reject(e.getCode(), e.getCode());
        }
        catch (Exception fe) {
            this.logger.error((Object)fe, (Throwable)fe);
        }
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse(context);
        if (StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("warn"))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    protected void initAction() {
        if (this.getFormObjectClass() == null) {
            this.setFormObjectClass(UsernamePasswordCredentials.class);
            this.setFormObjectName("credentials");
            this.setValidator(new UsernamePasswordCredentialsValidator());
            this.logger.info((Object)("FormObjectClass not set.  Using default class of " + this.getFormObjectClass().getName() + " with formObjectName " + this.getFormObjectName() + " and validator " + this.getValidator().getClass().getName() + "."));
        }
        Assert.isTrue((boolean)Credentials.class.isAssignableFrom(this.getFormObjectClass()), (String)"CommandClass must be of type Credentials.");
        if (this.credentialsBinder != null) {
            Assert.isTrue((boolean)this.credentialsBinder.supports(this.getFormObjectClass()), (String)("CredentialsBinder does not support supplied FormObjectClass: " + ((Object)((Object)this)).getClass().getName()));
        }
    }
}

