/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.GreaterThan;
import org.inspektr.common.ioc.annotation.NotNull;

public final class HttpClient
implements Serializable {
    private static final long serialVersionUID = -5306738686476129516L;
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    private static final Log log = LogFactory.getLog(HttpClient.class);
    @NotNull
    private int[] acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
    @GreaterThan(value=0)
    private int connectionTimeout = 5000;
    @GreaterThan(value=0)
    private int readTimeout = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageToEndPoint(String url, String message) {
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to access " + url));
            }
            URL logoutUrl = new URL(url);
            String output = "logoutRequest=" + URLEncoder.encode(message, "UTF-8");
            connection = (HttpURLConnection)logoutUrl.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setReadTimeout(this.readTimeout);
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setRequestProperty("Content-Length", "" + Integer.toString(output.getBytes().length));
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream printout = new DataOutputStream(connection.getOutputStream());
            printout.writeBytes(output);
            printout.flush();
            printout.close();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while (in.readLine() != null) {
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished sending message to" + url));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public boolean isValidEndPoint(String url) {
        try {
            URL u = new URL(url);
            return this.isValidEndPoint(u);
        }
        catch (MalformedURLException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidEndPoint(URL url) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.connect();
            int responseCode = connection.getResponseCode();
            for (int i = 0; i < this.acceptableCodes.length; ++i) {
                if (responseCode != this.acceptableCodes[i]) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response code from server matched " + responseCode + "."));
                }
                boolean bl = true;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response Code did not match any of the acceptable response codes.  Code returned was " + responseCode));
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public final void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

