/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketState;

public final class ThrottledUseAndTimeoutExpirationPolicy
implements ExpirationPolicy {
    private static final Log log = LogFactory.getLog(ThrottledUseAndTimeoutExpirationPolicy.class);
    private static final long serialVersionUID = -848036845536731268L;
    private long timeToKillInMilliSeconds;
    private long timeInBetweenUsesInMilliSeconds;

    public void setTimeInBetweenUsesInMilliSeconds(long timeInBetweenUsesInMilliSeconds) {
        this.timeInBetweenUsesInMilliSeconds = timeInBetweenUsesInMilliSeconds;
    }

    public void setTimeToKillInMilliSeconds(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public boolean isExpired(TicketState ticketState) {
        if (ticketState.getCountOfUses() == 0 && System.currentTimeMillis() - ticketState.getLastTimeUsed() < this.timeToKillInMilliSeconds) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ticket is not expired due to a count of zero and the time being less than the timeToKillInMilliseconds");
            }
            return false;
        }
        if (System.currentTimeMillis() - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ticket is expired due to the time being greater than the timeToKillInMilliseconds");
            }
            return true;
        }
        if (System.currentTimeMillis() - ticketState.getLastTimeUsed() <= this.timeInBetweenUsesInMilliSeconds) {
            log.warn((Object)"Ticket is expired due to the time being less than the waiting period.");
            return true;
        }
        return false;
    }
}

